/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.time.DTConst;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.TZ;
import com.iofairy.tcf.Try;
import com.iofairy.top.G;
import com.iofairy.top.S;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import java.math.BigInteger;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;

public final class DateTimes {
    private static final List<Class<? extends Temporal>> SUPPORTED_TEMPORAL_FOR_DOM = Arrays.asList(LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Instant.class, YearMonth.class, ChronoLocalDate.class);

    public static Map<ZoneOffset, List<ZoneId>> getOffsetZoneIds() {
        return TZ.ZONE_IDS.stream().collect(Collectors.groupingBy(DateTimes::zoneOffset));
    }

    public static List<ZoneId> getZoneIds(ZoneOffset zoneOffset) {
        return DateTimes.getOffsetZoneIds().get(zoneOffset);
    }

    public static ZoneOffset defaultOffset() {
        return (ZoneOffset)Try.tcf(() -> OffsetDateTime.now().getOffset(), (boolean)false);
    }

    public static ZoneOffset zoneOffset(String zoneIdName) {
        return DateTimes.zoneOffset((ZoneId)Try.tcf(() -> ZoneId.of(zoneIdName), (boolean)false));
    }

    public static ZoneOffset zoneOffset(ZoneId zoneId) {
        return DateTimes.zoneOffset(zoneId, Instant.now());
    }

    public static ZoneOffset zoneOffset(ZoneId zoneId, Instant instant) {
        if (G.hasNull((Object[])new Object[]{zoneId, instant})) {
            return null;
        }
        return (ZoneOffset)Try.tcf(() -> zoneId.getRules().getOffset(instant), (boolean)false);
    }

    public static ZoneOffset zoneOffset(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return ZoneOffset.ofTotalSeconds(calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 1000);
    }

    public static Date defaultDateToTZ(Date date, ZoneId zoneId) {
        return DateTimes.tzDateToTZ(date, TZ.DEFAULT_ZONE, zoneId);
    }

    public static Date tzDateToTZ(Date date, ZoneId fromZoneId, ZoneId toZoneId) {
        if (fromZoneId == null) {
            fromZoneId = TZ.DEFAULT_ZONE;
        }
        if (toZoneId == null) {
            toZoneId = TZ.DEFAULT_ZONE;
        }
        if (fromZoneId.equals(toZoneId)) {
            return date;
        }
        return Date.from(date.toInstant().atZone(toZoneId).withZoneSameLocal(fromZoneId).toInstant());
    }

    public static LocalDateTime defaultLocalDTToTZ(LocalDateTime localDateTime, ZoneId zoneId) {
        return DateTimes.tzLocalDTToTZ(localDateTime, TZ.DEFAULT_ZONE, zoneId);
    }

    public static LocalDateTime tzLocalDTToTZ(LocalDateTime localDateTime, ZoneId fromZoneId, ZoneId toZoneId) {
        if (fromZoneId == null) {
            fromZoneId = TZ.DEFAULT_ZONE;
        }
        if (toZoneId == null) {
            toZoneId = TZ.DEFAULT_ZONE;
        }
        if (fromZoneId.equals(toZoneId)) {
            return localDateTime;
        }
        return localDateTime.atZone(fromZoneId).withZoneSameInstant(toZoneId).toLocalDateTime();
    }

    public static ZonedDateTime tzDateToZonedDT(Date date, ZoneId fromZoneId, ZoneId toZoneId) {
        if (fromZoneId == null) {
            fromZoneId = TZ.DEFAULT_ZONE;
        }
        if (toZoneId == null) {
            toZoneId = TZ.DEFAULT_ZONE;
        }
        return date.toInstant().atZone(TZ.DEFAULT_ZONE).withZoneSameLocal(fromZoneId).withZoneSameInstant(toZoneId);
    }

    public static ZonedDateTime toZonedDT(Calendar calendar, ZoneId toZoneId) {
        if (calendar == null) {
            return null;
        }
        ZoneId calendarTZ = calendar.getTimeZone().toZoneId();
        toZoneId = toZoneId == null ? calendarTZ : toZoneId;
        return calendar.toInstant().atZone(calendarTZ).withZoneSameInstant(toZoneId);
    }

    public static Calendar toCalendar(Date date, ZoneId zoneId) {
        Calendar calendar = zoneId == null ? Calendar.getInstance() : Calendar.getInstance(TimeZone.getTimeZone(zoneId));
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar toCalendar(Calendar calendar, ZoneId zoneId) {
        if (calendar == null) {
            return null;
        }
        if (zoneId == null) {
            return DateTimes.clone(calendar);
        }
        Calendar newCalendar = DateTimes.clone(calendar);
        newCalendar.setTimeZone(TimeZone.getTimeZone(zoneId));
        return newCalendar;
    }

    public static Calendar toCalendar(Instant instant) {
        if (instant == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(instant.toEpochMilli());
        return calendar;
    }

    public static Calendar toCalendar(ZonedDateTime zonedDateTime) {
        if (zonedDateTime == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zonedDateTime.getZone()));
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    public static Calendar toCalendar(OffsetDateTime offsetDateTime) {
        if (offsetDateTime == null) {
            return null;
        }
        return DateTimes.toCalendar(offsetDateTime.toZonedDateTime());
    }

    public static Calendar clone(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return (Calendar)calendar.clone();
    }

    public static Date clone(Date date) {
        if (date == null) {
            return null;
        }
        return (Date)date.clone();
    }

    public static BigInteger toMicros(long amount, ChronoUnit chronoUnit) {
        if (amount == 0L) {
            return BigInteger.ZERO;
        }
        switch (chronoUnit) {
            case HOURS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(3600000000L));
            }
            case MINUTES: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(60000000L));
            }
            case SECONDS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(1000000L));
            }
            case MILLIS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(1000L));
            }
            case MICROS: {
                return BigInteger.valueOf(amount);
            }
            case NANOS: {
                return BigInteger.valueOf(0L);
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + chronoUnit);
    }

    public static BigInteger toNanos(long amount, ChronoUnit chronoUnit) {
        if (amount == 0L) {
            return BigInteger.ZERO;
        }
        switch (chronoUnit) {
            case HOURS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(3600000000000L));
            }
            case MINUTES: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(60000000000L));
            }
            case SECONDS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(1000000000L));
            }
            case MILLIS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(1000000L));
            }
            case MICROS: {
                return BigInteger.valueOf(amount).multiply(BigInteger.valueOf(1000L));
            }
            case NANOS: {
                return BigInteger.valueOf(amount);
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + chronoUnit);
    }

    public static int daysOfMonth(int year, int month) {
        return YearMonth.of(year, month).lengthOfMonth();
    }

    public static int daysOfMonth(Temporal temporal) {
        Objects.requireNonNull(temporal, "Parameter `temporal` must be non-null!");
        if (SUPPORTED_TEMPORAL_FOR_DOM.stream().noneMatch(c -> c.isAssignableFrom(temporal.getClass()))) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_FOR_DOM.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")) + "] is supported for `temporal` parameter!");
        }
        if (temporal instanceof ChronoLocalDate) {
            return ((ChronoLocalDate)temporal).lengthOfMonth();
        }
        if (temporal instanceof YearMonth) {
            return ((YearMonth)temporal).lengthOfMonth();
        }
        return DateTime.of(temporal).daysOfMonth();
    }

    public static Tuple2<Integer, Integer> daysBetween(DayOfWeek startDayOfWeek, DayOfWeek endDayOfWeek) {
        int endDayOfWeekValue;
        if (G.hasNull((Object[])new Object[]{startDayOfWeek, endDayOfWeek})) {
            throw new NullPointerException("Parameters `startDayOfWeek`, `endDayOfWeek` must be non-null!");
        }
        int startDayOfWeekValue = startDayOfWeek.getValue();
        if (startDayOfWeekValue < (endDayOfWeekValue = endDayOfWeek.getValue())) {
            return Tuple.of((Object)(startDayOfWeekValue - (endDayOfWeekValue - 7)), (Object)(endDayOfWeekValue - startDayOfWeekValue));
        }
        if (startDayOfWeekValue > endDayOfWeekValue) {
            return Tuple.of((Object)(startDayOfWeekValue - endDayOfWeekValue), (Object)(endDayOfWeekValue + 7 - startDayOfWeekValue));
        }
        return Tuple.of((Object)0, (Object)0);
    }

    public static DayOfWeek getLastDayOfWeek(DayOfWeek firstDayOfWeek) {
        return DayOfWeek.of((firstDayOfWeek.getValue() + 5) % DayOfWeek.values().length + 1);
    }

    public static List<String> hoursOfDay(int withMode, String separator) {
        return DateTimes.hoursOfDay("", withMode, separator);
    }

    public static List<String> hoursOfDay(String day, int withMode) {
        return DateTimes.hoursOfDay(day, withMode, "");
    }

    public static List<String> hoursOfDay(String day, int withMode, String separator) {
        if (day == null) {
            day = "";
        }
        if (separator == null) {
            separator = "";
        }
        ArrayList<String> hhs = new ArrayList<String>();
        switch (withMode) {
            case 0: {
                if (S.isEmpty((CharSequence)day)) {
                    return DTConst.HHs;
                }
                for (String hh : DTConst.HHs) {
                    hhs.add(day + hh);
                }
                break;
            }
            case 1: {
                for (String hh : DTConst.HHs) {
                    hhs.add(day + hh + separator + "00");
                }
                break;
            }
            default: {
                for (String hh : DTConst.HHs) {
                    hhs.add(day + hh + separator + "00" + separator + "00");
                }
            }
        }
        return hhs;
    }

    public static List<String> hourMinutesOfDay(boolean withZeroSecond, String separator) {
        if (separator == null) {
            separator = "";
        }
        ArrayList<String> hhmms = new ArrayList<String>();
        if (withZeroSecond) {
            for (String hh : DTConst.HHs) {
                for (String ms : DTConst.MSs) {
                    hhmms.add(hh + separator + ms + separator + "00");
                }
            }
        } else {
            for (String hh : DTConst.HHs) {
                for (String ms : DTConst.MSs) {
                    hhmms.add(hh + separator + ms);
                }
            }
        }
        return hhmms;
    }

    public static List<String> minutesOfHour(String hour, boolean withZeroSecond, String separator) {
        boolean isEmpty;
        if (separator == null) {
            separator = "";
        }
        hour = (isEmpty = S.isEmpty((CharSequence)hour)) ? "" : hour;
        String hmSeparator = isEmpty ? "" : separator;
        ArrayList<String> hhmms = new ArrayList<String>();
        if (withZeroSecond) {
            for (String ms : DTConst.MSs) {
                hhmms.add(hour + hmSeparator + ms + separator + "00");
            }
        } else {
            for (String ms : DTConst.MSs) {
                hhmms.add(hour + hmSeparator + ms);
            }
        }
        return hhmms;
    }

    public static List<String> secondsOfMinute(String minute, String separator) {
        return DateTimes.minutesOfHour(minute, false, separator);
    }
}

