/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.except.UnexpectedParameterException;
import com.iofairy.falcon.os.OS;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.SignedInterval;
import com.iofairy.falcon.time.TZ;
import com.iofairy.top.G;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

public class Interval
extends SignedInterval {
    public static final Interval ZERO = new Interval(0L, 0L, 0L);

    public Interval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        super(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        if (this.centuries < 0L || this.years < 0L || this.months < 0L || this.days < 0L || this.hours < 0L || this.minutes < 0L || this.seconds < 0L || this.millis < 0L || this.micros < 0L || this.nanos < 0L) {
            throw new UnexpectedParameterException(OS.IS_ZH_LANG ? "Interval\u6784\u9020\u51fd\u6570\u7684\u6240\u6709\u53c2\u6570\u90fd\u5fc5\u987b \u2265 0! " : "Interval Constructor all parameters must not be negative number! ");
        }
    }

    public Interval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes, long seconds) {
        this(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes) {
        this(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public Interval(long months, long days, long hours, long minutes) {
        this(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public Interval(long days, long hours, long minutes) {
        this(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    public static Interval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new Interval(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes, long seconds) {
        return new Interval(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes) {
        return new Interval(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long months, long days, long hours, long minutes) {
        return new Interval(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long days, long hours, long minutes) {
        return new Interval(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long amount, TemporalUnit unit) {
        return ZERO.plus(amount, unit);
    }

    public static Interval ofCenturies(long centuries) {
        return ZERO.plus(centuries, ChronoUnit.CENTURIES);
    }

    public static Interval ofYears(long years) {
        return ZERO.plus(years, ChronoUnit.YEARS);
    }

    public static Interval ofMonths(long months) {
        return ZERO.plus(months, ChronoUnit.MONTHS);
    }

    public static Interval ofDays(long days) {
        return ZERO.plus(days, ChronoUnit.DAYS);
    }

    public static Interval ofHours(long hours) {
        return ZERO.plus(hours, ChronoUnit.HOURS);
    }

    public static Interval ofMinutes(long minutes) {
        return ZERO.plus(minutes, ChronoUnit.MINUTES);
    }

    public static Interval ofSeconds(long seconds) {
        return ZERO.plus(seconds, ChronoUnit.SECONDS);
    }

    public static Interval ofMillis(long millis) {
        return ZERO.plus(millis, ChronoUnit.MILLIS);
    }

    public static Interval ofMicros(long micros) {
        return ZERO.plus(micros, ChronoUnit.MICROS);
    }

    public static Interval ofNanos(long nanos) {
        return ZERO.plus(nanos, ChronoUnit.NANOS);
    }

    public Interval plus(Interval interval) {
        long centuries = this.centuries + interval.centuries;
        long years = this.years + interval.years;
        long months = this.months + interval.months;
        long days = this.days + interval.days;
        long hours = this.hours + interval.hours;
        long minutes = this.minutes + interval.minutes;
        long seconds = this.seconds + interval.seconds;
        long millis = this.millis + interval.millis;
        long micros = this.micros + interval.micros;
        long nanos = this.nanos + interval.nanos;
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    @Override
    public Interval plus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries += amount;
                    break;
                }
                case YEARS: {
                    years += amount;
                    break;
                }
                case MONTHS: {
                    months += amount;
                    break;
                }
                case DAYS: {
                    days += amount;
                    break;
                }
                case HOURS: {
                    hours += amount;
                    break;
                }
                case MINUTES: {
                    minutes += amount;
                    break;
                }
                case SECONDS: {
                    seconds += amount;
                    break;
                }
                case MILLIS: {
                    millis += amount;
                    break;
                }
                case MICROS: {
                    micros += amount;
                    break;
                }
                case NANOS: {
                    nanos += amount;
                }
            }
            return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public Interval minus(Interval interval) {
        long years = this.centuries * 100L + this.years - (interval.centuries * 100L + interval.years);
        long months = this.months - interval.months;
        long days = this.days - interval.days;
        long hours = this.hours - interval.hours;
        long minutes = this.minutes - interval.minutes;
        long seconds = this.seconds - interval.seconds;
        long millis = this.millis - interval.millis;
        long micros = this.micros - interval.micros;
        long nanos = this.nanos - interval.nanos;
        return new Interval(this.centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    @Override
    public Interval minus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries -= amount;
                    break;
                }
                case YEARS: {
                    years -= amount;
                    break;
                }
                case MONTHS: {
                    months -= amount;
                    break;
                }
                case DAYS: {
                    days -= amount;
                    break;
                }
                case HOURS: {
                    hours -= amount;
                    break;
                }
                case MINUTES: {
                    minutes -= amount;
                    break;
                }
                case SECONDS: {
                    seconds -= amount;
                    break;
                }
                case MILLIS: {
                    millis -= amount;
                    break;
                }
                case MICROS: {
                    micros -= amount;
                    break;
                }
                case NANOS: {
                    nanos -= amount;
                }
            }
            return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public static Interval between(Temporal startTemporal, Temporal endTemporal) {
        DateTime<Temporal> endDT;
        if (G.hasNull((Object[])new Object[]{startTemporal, endTemporal})) {
            throw new NullPointerException("Parameters `startTemporal` and `endTemporal` must be non-null!");
        }
        if (!Interval.isSupported(startTemporal) || !Interval.isSupported(endTemporal)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_STRING + "] is supported for `startTemporal` and `endTemporal` parameters!");
        }
        DateTime<Temporal> startDT = DateTime.from(startTemporal);
        boolean isBefore = startDT.isBefore(endDT = DateTime.from(endTemporal));
        Temporal tmpStartTemporal = isBefore ? startTemporal : endTemporal;
        Temporal tmpEndTemporal = isBefore ? endTemporal : startTemporal;
        SignedInterval signedInterval = SignedInterval.between(tmpStartTemporal, tmpEndTemporal);
        Interval interval = new Interval(signedInterval.centuries, signedInterval.years, signedInterval.months, signedInterval.days, signedInterval.hours, signedInterval.minutes, signedInterval.seconds, signedInterval.millis, signedInterval.micros, signedInterval.nanos);
        interval.startTime = tmpStartTemporal;
        interval.endTime = tmpEndTemporal;
        interval.totalYears = signedInterval.totalYears;
        interval.totalMonths = signedInterval.totalMonths;
        interval.totalWeeks = signedInterval.totalWeeks;
        interval.totalDays = signedInterval.totalDays;
        interval.totalHours = signedInterval.totalHours;
        interval.totalMinutes = signedInterval.totalMinutes;
        interval.totalSeconds = signedInterval.totalSeconds;
        interval.totalMillis = signedInterval.totalMillis;
        interval.totalMicros = signedInterval.totalMicros;
        interval.totalNanos = signedInterval.totalNanos;
        return interval;
    }

    public static Interval between(Date startDate, Date endDate) {
        if (G.hasNull((Object[])new Object[]{startDate, endDate})) {
            throw new NullPointerException("Parameters `startDate` and `endDate` must be non-null!");
        }
        return Interval.between(DateTime.from(startDate).getZonedDateTime(), DateTime.from(endDate).getZonedDateTime());
    }

    public static Interval between(Calendar startCalendar, Calendar endCalendar) {
        if (G.hasNull((Object[])new Object[]{startCalendar, endCalendar})) {
            throw new NullPointerException("Parameters `startCalendar` and `endCalendar` must be non-null!");
        }
        return Interval.between(DateTime.from(startCalendar).getZonedDateTime(), DateTime.from(endCalendar).getZonedDateTime());
    }

    public static Interval between(DateTime<?> startDateTime, DateTime<?> endDateTime) {
        if (G.hasNull((Object[])new Object[]{startDateTime, endDateTime})) {
            throw new NullPointerException("Parameters `startDateTime` and `endDateTime` must be non-null!");
        }
        Object start = startDateTime.get();
        Object end = endDateTime.get();
        if (start instanceof ZonedDateTime && end instanceof ZonedDateTime || start instanceof OffsetDateTime && end instanceof OffsetDateTime || start instanceof LocalDateTime && end instanceof LocalDateTime) {
            return Interval.between((Temporal)start, (Temporal)end);
        }
        return Interval.between(startDateTime.getZonedDateTime(), endDateTime.getZonedDateTime());
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "Parameter `temporal` must be non-null!");
        if (!Interval.isSupported(temporal)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_STRING + "] is supported for `temporal` parameter!");
        }
        boolean isInstant = temporal instanceof Instant;
        temporal = isInstant ? ZonedDateTime.ofInstant((Instant)temporal, TZ.DEFAULT_ZONE) : temporal;
        temporal = this.minus(temporal, this.nanos, ChronoUnit.NANOS);
        temporal = this.minus(temporal, this.micros, ChronoUnit.MICROS);
        temporal = this.minus(temporal, this.millis, ChronoUnit.MILLIS);
        temporal = this.minus(temporal, this.seconds, ChronoUnit.SECONDS);
        temporal = this.minus(temporal, this.minutes, ChronoUnit.MINUTES);
        temporal = this.minus(temporal, this.hours, ChronoUnit.HOURS);
        temporal = this.minus(temporal, this.days, ChronoUnit.DAYS);
        temporal = this.minus(temporal, this.months, ChronoUnit.MONTHS);
        temporal = this.minus(temporal, this.centuries * 100L + this.years, ChronoUnit.YEARS);
        return isInstant ? ((ZonedDateTime)temporal).toInstant() : temporal;
    }
}

