/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.os.OS;
import com.iofairy.falcon.time.ChronoInterval;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.falcon.time.TZ;
import com.iofairy.top.G;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SignedInterval
implements ChronoInterval,
Comparable<SignedInterval> {
    private static final long serialVersionUID = 7006057265L;
    public final long centuries;
    public final long years;
    public final long months;
    public final long days;
    public final long hours;
    public final long minutes;
    public final long seconds;
    public final long millis;
    public final long micros;
    public final long nanos;
    protected long totalYears;
    protected long totalMonths;
    protected long totalWeeks;
    protected long totalDays;
    protected long totalHours;
    protected long totalMinutes;
    protected long totalSeconds;
    protected long totalMillis;
    protected BigInteger totalMicros;
    protected BigInteger totalNanos;
    protected Temporal startTime;
    protected Temporal endTime;
    public static final SignedInterval ZERO = new SignedInterval(0L, 0L, 0L);
    private static final List<TemporalUnit> SUPPORTED_UNITS = Collections.unmodifiableList(Arrays.asList(ChronoUnit.CENTURIES, ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS, ChronoUnit.MILLIS, ChronoUnit.MICROS, ChronoUnit.NANOS));
    public static final List<Class<? extends Temporal>> SUPPORTED_TEMPORAL = Collections.unmodifiableList(Arrays.asList(ZonedDateTime.class, OffsetDateTime.class, LocalDateTime.class, Instant.class));
    protected static final String SUPPORTED_TEMPORAL_STRING = SUPPORTED_TEMPORAL.stream().map(Class::getSimpleName).collect(Collectors.joining(", "));

    public SignedInterval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        this.centuries = centuries;
        this.years = years;
        this.months = months;
        this.days = days;
        BigInteger totalNanos = this.toNanos(hours, ChronoUnit.HOURS).add(this.toNanos(minutes, ChronoUnit.MINUTES)).add(this.toNanos(seconds, ChronoUnit.SECONDS)).add(this.toNanos(millis, ChronoUnit.MILLIS)).add(this.toNanos(micros, ChronoUnit.MICROS)).add(this.toNanos(nanos, ChronoUnit.NANOS));
        long[] timeValues = this.standardizingTime(totalNanos);
        this.hours = timeValues[0];
        this.minutes = timeValues[1];
        this.seconds = timeValues[2];
        this.millis = timeValues[3];
        this.micros = timeValues[4];
        this.nanos = timeValues[5];
    }

    public SignedInterval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public SignedInterval(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public SignedInterval(long years, long months, long days, long hours, long minutes, long seconds) {
        this(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public SignedInterval(long years, long months, long days, long hours, long minutes) {
        this(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public SignedInterval(long months, long days, long hours, long minutes) {
        this(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public SignedInterval(long days, long hours, long minutes) {
        this(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static SignedInterval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    public static SignedInterval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static SignedInterval of(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new SignedInterval(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static SignedInterval of(long years, long months, long days, long hours, long minutes, long seconds) {
        return new SignedInterval(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public static SignedInterval of(long years, long months, long days, long hours, long minutes) {
        return new SignedInterval(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static SignedInterval of(long months, long days, long hours, long minutes) {
        return new SignedInterval(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static SignedInterval of(long days, long hours, long minutes) {
        return new SignedInterval(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static SignedInterval of(long amount, TemporalUnit unit) {
        return ZERO.plus(amount, unit);
    }

    public static SignedInterval ofCenturies(long centuries) {
        return ZERO.plus(centuries, ChronoUnit.CENTURIES);
    }

    public static SignedInterval ofYears(long years) {
        return ZERO.plus(years, ChronoUnit.YEARS);
    }

    public static SignedInterval ofMonths(long months) {
        return ZERO.plus(months, ChronoUnit.MONTHS);
    }

    public static SignedInterval ofDays(long days) {
        return ZERO.plus(days, ChronoUnit.DAYS);
    }

    public static SignedInterval ofHours(long hours) {
        return ZERO.plus(hours, ChronoUnit.HOURS);
    }

    public static SignedInterval ofMinutes(long minutes) {
        return ZERO.plus(minutes, ChronoUnit.MINUTES);
    }

    public static SignedInterval ofSeconds(long seconds) {
        return ZERO.plus(seconds, ChronoUnit.SECONDS);
    }

    public static SignedInterval ofMillis(long millis) {
        return ZERO.plus(millis, ChronoUnit.MILLIS);
    }

    public static SignedInterval ofMicros(long micros) {
        return ZERO.plus(micros, ChronoUnit.MICROS);
    }

    public static SignedInterval ofNanos(long nanos) {
        return ZERO.plus(nanos, ChronoUnit.NANOS);
    }

    public SignedInterval plus(SignedInterval signedInterval) {
        long centuries = this.centuries + signedInterval.centuries;
        long years = this.years + signedInterval.years;
        long months = this.months + signedInterval.months;
        long days = this.days + signedInterval.days;
        long hours = this.hours + signedInterval.hours;
        long minutes = this.minutes + signedInterval.minutes;
        long seconds = this.seconds + signedInterval.seconds;
        long millis = this.millis + signedInterval.millis;
        long micros = this.micros + signedInterval.micros;
        long nanos = this.nanos + signedInterval.nanos;
        return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    public SignedInterval plus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries += amount;
                    break;
                }
                case YEARS: {
                    years += amount;
                    break;
                }
                case MONTHS: {
                    months += amount;
                    break;
                }
                case DAYS: {
                    days += amount;
                    break;
                }
                case HOURS: {
                    hours += amount;
                    break;
                }
                case MINUTES: {
                    minutes += amount;
                    break;
                }
                case SECONDS: {
                    seconds += amount;
                    break;
                }
                case MILLIS: {
                    millis += amount;
                    break;
                }
                case MICROS: {
                    micros += amount;
                    break;
                }
                case NANOS: {
                    nanos += amount;
                }
            }
            return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public SignedInterval minus(SignedInterval signedInterval) {
        long centuries = this.centuries - signedInterval.centuries;
        long years = this.years - signedInterval.years;
        long months = this.months - signedInterval.months;
        long days = this.days - signedInterval.days;
        long hours = this.hours - signedInterval.hours;
        long minutes = this.minutes - signedInterval.minutes;
        long seconds = this.seconds - signedInterval.seconds;
        long millis = this.millis - signedInterval.millis;
        long micros = this.micros - signedInterval.micros;
        long nanos = this.nanos - signedInterval.nanos;
        return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    public SignedInterval minus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries -= amount;
                    break;
                }
                case YEARS: {
                    years -= amount;
                    break;
                }
                case MONTHS: {
                    months -= amount;
                    break;
                }
                case DAYS: {
                    days -= amount;
                    break;
                }
                case HOURS: {
                    hours -= amount;
                    break;
                }
                case MINUTES: {
                    minutes -= amount;
                    break;
                }
                case SECONDS: {
                    seconds -= amount;
                    break;
                }
                case MILLIS: {
                    millis -= amount;
                    break;
                }
                case MICROS: {
                    micros -= amount;
                    break;
                }
                case NANOS: {
                    nanos -= amount;
                }
            }
            return new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public static SignedInterval between(Temporal startTemporal, Temporal endTemporal) {
        if (startTemporal == null || endTemporal == null) {
            throw new NullPointerException("Parameters `startTemporal` and `endTemporal` must be non-null!");
        }
        if (!SignedInterval.isSupported(startTemporal) || !SignedInterval.isSupported(endTemporal)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_STRING + "] is supported for `startTemporal` and `endTemporal` parameters!");
        }
        Temporal originalStartTemporal = startTemporal;
        Temporal originalEndTemporal = endTemporal;
        startTemporal = startTemporal instanceof Instant ? ZonedDateTime.ofInstant((Instant)startTemporal, TZ.DEFAULT_ZONE) : startTemporal;
        Temporal temporal = endTemporal = endTemporal instanceof Instant ? ZonedDateTime.ofInstant((Instant)endTemporal, TZ.DEFAULT_ZONE) : endTemporal;
        if (!(startTemporal instanceof ZonedDateTime && endTemporal instanceof ZonedDateTime || startTemporal instanceof OffsetDateTime && endTemporal instanceof OffsetDateTime || startTemporal instanceof LocalDateTime && endTemporal instanceof LocalDateTime)) {
            startTemporal = DateTime.of(startTemporal).getZonedDateTime();
            if (endTemporal instanceof LocalDateTime) {
                endTemporal = ((LocalDateTime)endTemporal).atZone(TZ.DEFAULT_ZONE);
            }
        }
        long totalYears = startTemporal.until(endTemporal, ChronoUnit.YEARS);
        long totalMonths = startTemporal.until(endTemporal, ChronoUnit.MONTHS);
        long totalWeeks = startTemporal.until(endTemporal, ChronoUnit.WEEKS);
        long totalDays = startTemporal.until(endTemporal, ChronoUnit.DAYS);
        long totalHours = startTemporal.until(endTemporal, ChronoUnit.HOURS);
        long totalMinutes = startTemporal.until(endTemporal, ChronoUnit.MINUTES);
        long totalSeconds = startTemporal.until(endTemporal, ChronoUnit.SECONDS);
        long totalMillis = startTemporal.until(endTemporal, ChronoUnit.MILLIS);
        long centuries = startTemporal.until(endTemporal, ChronoUnit.CENTURIES);
        startTemporal = startTemporal.plus(centuries, ChronoUnit.CENTURIES);
        long years = startTemporal.until(endTemporal, ChronoUnit.YEARS);
        startTemporal = startTemporal.plus(years, ChronoUnit.YEARS);
        long months = startTemporal.until(endTemporal, ChronoUnit.MONTHS);
        startTemporal = startTemporal.plus(months, ChronoUnit.MONTHS);
        long days = startTemporal.until(endTemporal, ChronoUnit.DAYS);
        startTemporal = startTemporal.plus(days, ChronoUnit.DAYS);
        long hours = startTemporal.until(endTemporal, ChronoUnit.HOURS);
        startTemporal = startTemporal.plus(hours, ChronoUnit.HOURS);
        long minutes = startTemporal.until(endTemporal, ChronoUnit.MINUTES);
        startTemporal = startTemporal.plus(minutes, ChronoUnit.MINUTES);
        long seconds = startTemporal.until(endTemporal, ChronoUnit.SECONDS);
        startTemporal = startTemporal.plus(seconds, ChronoUnit.SECONDS);
        long millis = startTemporal.until(endTemporal, ChronoUnit.MILLIS);
        startTemporal = startTemporal.plus(millis, ChronoUnit.MILLIS);
        long micros = startTemporal.until(endTemporal, ChronoUnit.MICROS);
        startTemporal = startTemporal.plus(micros, ChronoUnit.MICROS);
        long nanos = startTemporal.until(endTemporal, ChronoUnit.NANOS);
        BigInteger totalMicros = BigInteger.valueOf(totalMillis).multiply(BigInteger.valueOf(1000L)).add(BigInteger.valueOf(micros));
        BigInteger totalNanos = totalMicros.multiply(BigInteger.valueOf(1000L)).add(BigInteger.valueOf(nanos));
        SignedInterval signedInterval = new SignedInterval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        signedInterval.startTime = originalStartTemporal;
        signedInterval.endTime = originalEndTemporal;
        signedInterval.totalYears = totalYears;
        signedInterval.totalMonths = totalMonths;
        signedInterval.totalWeeks = totalWeeks;
        signedInterval.totalDays = totalDays;
        signedInterval.totalHours = totalHours;
        signedInterval.totalMinutes = totalMinutes;
        signedInterval.totalSeconds = totalSeconds;
        signedInterval.totalMillis = totalMillis;
        signedInterval.totalMicros = totalMicros;
        signedInterval.totalNanos = totalNanos;
        return signedInterval;
    }

    public static SignedInterval between(Date startDate, Date endDate) {
        if (G.hasNull((Object[])new Object[]{startDate, endDate})) {
            throw new NullPointerException("Parameters `startDate` and `endDate` must be non-null!");
        }
        return SignedInterval.between(DateTime.from(startDate).getZonedDateTime(), DateTime.from(endDate).getZonedDateTime());
    }

    public static SignedInterval between(Calendar startCalendar, Calendar endCalendar) {
        if (G.hasNull((Object[])new Object[]{startCalendar, endCalendar})) {
            throw new NullPointerException("Parameters `startCalendar` and `endCalendar` must be non-null!");
        }
        return SignedInterval.between(DateTime.from(startCalendar).getZonedDateTime(), DateTime.from(endCalendar).getZonedDateTime());
    }

    public static SignedInterval between(DateTime<?> startDateTime, DateTime<?> endDateTime) {
        if (G.hasNull((Object[])new Object[]{startDateTime, endDateTime})) {
            throw new NullPointerException("Parameters `startDateTime` and `endDateTime` must be non-null!");
        }
        Object start = startDateTime.get();
        Object end = endDateTime.get();
        if (start instanceof ZonedDateTime && end instanceof ZonedDateTime || start instanceof OffsetDateTime && end instanceof OffsetDateTime || start instanceof LocalDateTime && end instanceof LocalDateTime) {
            return SignedInterval.between((Temporal)start, (Temporal)end);
        }
        return SignedInterval.between(startDateTime.getZonedDateTime(), endDateTime.getZonedDateTime());
    }

    public static boolean isSupported(Temporal temporal) {
        return temporal != null && SUPPORTED_TEMPORAL.stream().anyMatch(c -> c.isAssignableFrom(temporal.getClass()));
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    return this.centuries;
                }
                case YEARS: {
                    return this.years;
                }
                case MONTHS: {
                    return this.months;
                }
                case DAYS: {
                    return this.days;
                }
                case HOURS: {
                    return this.hours;
                }
                case MINUTES: {
                    return this.minutes;
                }
                case SECONDS: {
                    return this.seconds;
                }
                case MILLIS: {
                    return this.millis;
                }
                case MICROS: {
                    return this.micros;
                }
                case NANOS: {
                    return this.nanos;
                }
            }
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return SUPPORTED_UNITS;
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        Objects.requireNonNull(temporal, "Parameter `temporal` must be non-null!");
        if (!SignedInterval.isSupported(temporal)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_STRING + "] is supported for `temporal` parameter!");
        }
        boolean isInstant = temporal instanceof Instant;
        temporal = isInstant ? ZonedDateTime.ofInstant((Instant)temporal, TZ.DEFAULT_ZONE) : temporal;
        temporal = this.plus(temporal, this.centuries * 100L + this.years, ChronoUnit.YEARS);
        temporal = this.plus(temporal, this.months, ChronoUnit.MONTHS);
        temporal = this.plus(temporal, this.days, ChronoUnit.DAYS);
        temporal = this.plus(temporal, this.hours, ChronoUnit.HOURS);
        temporal = this.plus(temporal, this.minutes, ChronoUnit.MINUTES);
        temporal = this.plus(temporal, this.seconds, ChronoUnit.SECONDS);
        temporal = this.plus(temporal, this.millis, ChronoUnit.MILLIS);
        temporal = this.plus(temporal, this.micros, ChronoUnit.MICROS);
        temporal = this.plus(temporal, this.nanos, ChronoUnit.NANOS);
        return isInstant ? ((ZonedDateTime)temporal).toInstant() : temporal;
    }

    protected Temporal plus(Temporal temporal, long amountToAdd, TemporalUnit unit) {
        return amountToAdd == 0L ? temporal : temporal.plus(amountToAdd, unit);
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Objects.requireNonNull(temporal, "Parameter `temporal` must be non-null!");
        if (!SignedInterval.isSupported(temporal)) {
            throw new UnsupportedTemporalTypeException("Only [" + SUPPORTED_TEMPORAL_STRING + "] is supported for `temporal` parameter!!");
        }
        boolean isInstant = temporal instanceof Instant;
        temporal = isInstant ? ZonedDateTime.ofInstant((Instant)temporal, TZ.DEFAULT_ZONE) : temporal;
        temporal = this.minus(temporal, this.centuries * 100L + this.years, ChronoUnit.YEARS);
        temporal = this.minus(temporal, this.months, ChronoUnit.MONTHS);
        temporal = this.minus(temporal, this.days, ChronoUnit.DAYS);
        temporal = this.minus(temporal, this.hours, ChronoUnit.HOURS);
        temporal = this.minus(temporal, this.minutes, ChronoUnit.MINUTES);
        temporal = this.minus(temporal, this.seconds, ChronoUnit.SECONDS);
        temporal = this.minus(temporal, this.millis, ChronoUnit.MILLIS);
        temporal = this.minus(temporal, this.micros, ChronoUnit.MICROS);
        temporal = this.minus(temporal, this.nanos, ChronoUnit.NANOS);
        return isInstant ? ((ZonedDateTime)temporal).toInstant() : temporal;
    }

    protected Temporal minus(Temporal temporal, long amountToSubtract, TemporalUnit unit) {
        return amountToSubtract == 0L ? temporal : temporal.minus(amountToSubtract, unit);
    }

    public long toYears() {
        return this.totalYears;
    }

    public long toMonths() {
        return this.totalMonths;
    }

    public long toWeeks() {
        return this.totalWeeks;
    }

    public long toDays() {
        return this.totalDays;
    }

    public long toHours() {
        return this.totalHours;
    }

    public long toMinutes() {
        return this.totalMinutes;
    }

    public long toSeconds() {
        return this.totalSeconds;
    }

    public long toMillis() {
        return this.totalMillis;
    }

    public BigInteger toMicros() {
        return this.totalMicros;
    }

    public BigInteger toNanos() {
        return this.totalNanos;
    }

    public Temporal getStartTime() {
        return this.startTime;
    }

    public Temporal getEndTime() {
        return this.endTime;
    }

    public boolean equals(Object baseInterval) {
        return baseInterval instanceof SignedInterval && this.compareTo((SignedInterval)baseInterval) == 0;
    }

    @Override
    public int compareTo(SignedInterval other) {
        Objects.requireNonNull(other);
        if (this.totalNanos != null && other.totalNanos != null) {
            return this.totalNanos.compareTo(other.totalNanos);
        }
        long thisMonths = (this.centuries * 100L + this.years) * 12L + this.months;
        long otherMonths = (other.centuries * 100L + other.years) * 12L + other.months;
        if (thisMonths == otherMonths) {
            if (this.days == other.days) {
                long thisNanos = ((((this.hours * 60L + this.minutes) * 60L + this.seconds) * 1000L + this.millis) * 1000L + this.micros) * 1000L + this.nanos;
                long otherNanos = ((((other.hours * 60L + other.minutes) * 60L + other.seconds) * 1000L + other.millis) * 1000L + other.micros) * 1000L + other.nanos;
                return Long.compare(thisNanos, otherNanos);
            }
            return Long.compare(this.days, other.days);
        }
        return Long.compare(thisMonths, otherMonths);
    }

    public String toFullString() {
        String equivalentlyStr = OS.IS_ZH_LANG ? "\n\u76f8\u5f53\u4e8e\uff1a\n" : "\nAlternative time units: \n";
        String yearsStr = OS.IS_ZH_LANG ? " \u5e74\n" : " years\n";
        String monthsStr = OS.IS_ZH_LANG ? " \u6708\n" : " months\n";
        String weeksStr = OS.IS_ZH_LANG ? " \u5468\n" : " weeks\n";
        String daysStr = OS.IS_ZH_LANG ? " \u5929\n" : " days\n";
        String hoursStr = OS.IS_ZH_LANG ? " \u65f6\n" : " hours\n";
        String minutesStr = OS.IS_ZH_LANG ? " \u5206\n" : " minutes\n";
        String secondsStr = OS.IS_ZH_LANG ? " \u79d2\n" : " seconds\n";
        String millisStr = OS.IS_ZH_LANG ? " \u6beb\u79d2\n" : " millis\n";
        String microsStr = OS.IS_ZH_LANG ? " \u5fae\u79d2\n" : " micros\n";
        String nanosStr = OS.IS_ZH_LANG ? " \u7eb3\u79d2" : " nanos";
        return this + equivalentlyStr + "\u25cf " + this.totalYears + yearsStr + "\u25cf " + this.totalMonths + monthsStr + "\u25cf " + this.totalWeeks + weeksStr + "\u25cf " + this.totalDays + daysStr + "\u25cf " + this.totalHours + hoursStr + "\u25cf " + this.totalMinutes + minutesStr + "\u25cf " + this.totalSeconds + secondsStr + "\u25cf " + this.totalMillis + millisStr + "\u25cf " + (this.totalMicros == null ? "0" : this.totalMicros.toString()) + microsStr + "\u25cf " + (this.totalNanos == null ? "0" : this.totalNanos.toString()) + nanosStr;
    }

    public String toString() {
        String centuriesStr = OS.IS_ZH_LANG ? "\u4e16\u7eaa" : " centuries ";
        String yearsStr = OS.IS_ZH_LANG ? "\u5e74" : " years ";
        String monthsStr = OS.IS_ZH_LANG ? "\u6708" : " months ";
        String daysStr = OS.IS_ZH_LANG ? "\u5929" : " days ";
        String hoursStr = OS.IS_ZH_LANG ? "\u65f6" : " hours ";
        String minutesStr = OS.IS_ZH_LANG ? "\u5206" : " minutes ";
        String secondsStr = OS.IS_ZH_LANG ? "\u79d2" : " seconds ";
        String millisStr = OS.IS_ZH_LANG ? "\u6beb\u79d2" : " millis";
        String microsStr = OS.IS_ZH_LANG ? "\u5fae\u79d2" : " micros";
        String nanosStr = OS.IS_ZH_LANG ? "\u7eb3\u79d2" : " nanos";
        String intervalStr = "";
        intervalStr = this.centuries != 0L ? intervalStr + this.centuries + centuriesStr + this.years + yearsStr + this.months + monthsStr + this.days + daysStr + this.hours + hoursStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.years != 0L ? intervalStr + this.years + yearsStr + this.months + monthsStr + this.days + daysStr + this.hours + hoursStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.months != 0L ? intervalStr + this.months + monthsStr + this.days + daysStr + this.hours + hoursStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.days != 0L ? intervalStr + this.days + daysStr + this.hours + hoursStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.hours != 0L ? intervalStr + this.hours + hoursStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.minutes != 0L ? intervalStr + this.minutes + minutesStr + this.seconds + secondsStr + this.millis + millisStr : (this.seconds != 0L ? intervalStr + this.seconds + secondsStr + this.millis + millisStr : intervalStr + this.millis + millisStr))))));
        if (this.micros != 0L) {
            intervalStr = intervalStr + this.micros + microsStr;
        }
        if (this.nanos != 0L) {
            intervalStr = intervalStr + this.nanos + nanosStr;
        }
        return intervalStr;
    }

    public String toSimpleString() {
        String nanosStr;
        String centuriesStr = OS.IS_ZH_LANG ? "\u4e16\u7eaa" : " centuries ";
        String yearsStr = OS.IS_ZH_LANG ? "\u5e74" : " years ";
        String monthsStr = OS.IS_ZH_LANG ? "\u6708" : " months ";
        String daysStr = OS.IS_ZH_LANG ? "\u5929" : " days ";
        String hoursStr = OS.IS_ZH_LANG ? "\u65f6" : " hours ";
        String minutesStr = OS.IS_ZH_LANG ? "\u5206" : " minutes ";
        String secondsStr = OS.IS_ZH_LANG ? "\u79d2" : " seconds ";
        String millisStr = OS.IS_ZH_LANG ? "\u6beb\u79d2" : " millis";
        String microsStr = OS.IS_ZH_LANG ? "\u5fae\u79d2" : " micros";
        String string = nanosStr = OS.IS_ZH_LANG ? "\u7eb3\u79d2" : " nanos";
        if (this.centuries == 0L && this.years == 0L && this.months == 0L && this.days == 0L && this.hours == 0L && this.minutes == 0L && this.seconds == 0L && this.millis == 0L && this.micros == 0L && this.nanos == 0L) {
            return this.nanos + nanosStr;
        }
        String intervalStr = "";
        if (this.centuries != 0L) {
            intervalStr = intervalStr + this.centuries + centuriesStr;
        }
        if (this.years != 0L) {
            intervalStr = intervalStr + this.years + yearsStr;
        }
        if (this.months != 0L) {
            intervalStr = intervalStr + this.months + monthsStr;
        }
        if (this.days != 0L) {
            intervalStr = intervalStr + this.days + daysStr;
        }
        if (this.hours != 0L) {
            intervalStr = intervalStr + this.hours + hoursStr;
        }
        if (this.minutes != 0L) {
            intervalStr = intervalStr + this.minutes + minutesStr;
        }
        if (this.seconds != 0L) {
            intervalStr = intervalStr + this.seconds + secondsStr;
        }
        if (this.millis != 0L) {
            intervalStr = intervalStr + this.millis + millisStr;
        }
        if (this.micros != 0L) {
            intervalStr = intervalStr + this.micros + microsStr;
        }
        if (this.nanos != 0L) {
            intervalStr = intervalStr + this.nanos + nanosStr;
        }
        return intervalStr;
    }

    protected long[] standardizingTime(BigInteger totalNanos) {
        long[] timeValues = new long[6];
        if (!totalNanos.equals(BigInteger.ZERO)) {
            BigInteger[] hoursAndRemainder = totalNanos.divideAndRemainder(BigInteger.valueOf(3600000000000L));
            timeValues[0] = hoursAndRemainder[0].longValue();
            if (!hoursAndRemainder[1].equals(BigInteger.ZERO)) {
                BigInteger[] minutesAndRemainder = hoursAndRemainder[1].divideAndRemainder(BigInteger.valueOf(60000000000L));
                timeValues[1] = minutesAndRemainder[0].longValue();
                if (!minutesAndRemainder[1].equals(BigInteger.ZERO)) {
                    BigInteger[] secondsAndRemainder = minutesAndRemainder[1].divideAndRemainder(BigInteger.valueOf(1000000000L));
                    timeValues[2] = secondsAndRemainder[0].longValue();
                    if (!secondsAndRemainder[1].equals(BigInteger.ZERO)) {
                        BigInteger[] millisAndRemainder = secondsAndRemainder[1].divideAndRemainder(BigInteger.valueOf(1000000L));
                        timeValues[3] = millisAndRemainder[0].longValue();
                        if (!millisAndRemainder[1].equals(BigInteger.ZERO)) {
                            BigInteger[] microsAndRemainder = millisAndRemainder[1].divideAndRemainder(BigInteger.valueOf(1000L));
                            timeValues[4] = microsAndRemainder[0].longValue();
                            timeValues[5] = microsAndRemainder[1].longValue();
                        }
                    }
                }
            }
        }
        return timeValues;
    }

    protected BigInteger toMicros(long amount, ChronoUnit chronoUnit) {
        return DateTimes.toMicros(amount, chronoUnit);
    }

    protected BigInteger toNanos(long amount, ChronoUnit chronoUnit) {
        return DateTimes.toNanos(amount, chronoUnit);
    }
}

