/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.falcon.time.TZ;
import com.iofairy.tcf.Try;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;

@Deprecated
public class DateTimeUtils {
    public static Map<ZoneOffset, List<ZoneId>> getOffsetZoneIds() {
        return TZ.ZONE_IDS.stream().collect(Collectors.groupingBy(DateTimeUtils::getZoneOffset));
    }

    public static List<ZoneId> getZoneIds(ZoneOffset zoneOffset) {
        return DateTimeUtils.getOffsetZoneIds().get(zoneOffset);
    }

    public static ZoneOffset defaultOffset() {
        return (ZoneOffset)Try.tcf(() -> OffsetDateTime.now().getOffset(), (boolean)false);
    }

    public static ZoneOffset getZoneOffset(String zoneIdName) {
        return DateTimeUtils.getZoneOffset((ZoneId)Try.tcf(() -> ZoneId.of(zoneIdName), (boolean)false));
    }

    public static ZoneOffset getZoneOffset(ZoneId zoneId) {
        return (ZoneOffset)Try.tcf(() -> zoneId.getRules().getOffset(Instant.now()), (boolean)false);
    }

    public static ZonedDateTime toUTCZonedDT(Temporal temporal) {
        if (temporal == null) {
            return null;
        }
        if (temporal instanceof ZonedDateTime) {
            return ((ZonedDateTime)temporal).withZoneSameInstant(TZ.UTC);
        }
        if (temporal instanceof OffsetDateTime) {
            return ((OffsetDateTime)temporal).atZoneSameInstant(TZ.UTC);
        }
        if (temporal instanceof LocalDateTime) {
            return ((LocalDateTime)temporal).atZone(TZ.DEFAULT_ZONE).withZoneSameInstant(TZ.UTC);
        }
        if (temporal instanceof Instant) {
            return ZonedDateTime.ofInstant((Instant)temporal, TZ.UTC);
        }
        throw new UnsupportedTemporalTypeException("Only [ZonedDateTime, OffsetDateTime, LocalDateTime, Instant] is supported!");
    }

    public static Calendar calendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar calendar(Date date, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static Calendar calendar(Instant instant) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(instant.toEpochMilli());
        return calendar;
    }

    public static Calendar calendar(Instant instant, TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(instant.toEpochMilli());
        return calendar;
    }

    public static Date localDateToTZ(Date date, ZoneId zoneId) {
        return DateTimeUtils.tzDateToTZ(date, TZ.DEFAULT_ZONE, zoneId);
    }

    public static Date tzDateToTZ(Date date, ZoneId fromZoneId, ZoneId toZoneId) {
        return Date.from(date.toInstant().atZone(toZoneId).withZoneSameLocal(fromZoneId).toInstant());
    }

    public static Calendar calendarToLocal(Calendar calendar) {
        return DateTimeUtils.calendarToTZ(calendar, TZ.DEFAULT_ZONE);
    }

    public static Calendar calendarToTZ(Calendar calendar, ZoneId zoneId) {
        Date newDate = DateTimeUtils.tzDateToTZ(calendar.getTime(), calendar.getTimeZone().toZoneId(), zoneId);
        Calendar newCalendar = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
        newCalendar.setTime(newDate);
        return newCalendar;
    }
}

