/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.top.O;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;

public class Numbers {
    public static double[] round(float[] floats) {
        return Numbers.round(floats, 2, RoundingMode.HALF_UP);
    }

    public static double[] round(float[] floats, int newScale) {
        return Numbers.round(floats, newScale, RoundingMode.HALF_UP);
    }

    public static double[] round(float[] floats, int newScale, RoundingMode roundingMode) {
        if (floats == null) {
            return null;
        }
        double[] ds = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            ds[i] = Numbers.round(Float.valueOf(floats[i]), newScale, roundingMode);
        }
        return ds;
    }

    public static double[] round(double[] doubles) {
        return Numbers.round(doubles, 2, RoundingMode.HALF_UP);
    }

    public static double[] round(double[] doubles, int newScale) {
        return Numbers.round(doubles, newScale, RoundingMode.HALF_UP);
    }

    public static double[] round(double[] doubles, int newScale, RoundingMode roundingMode) {
        if (doubles == null) {
            return null;
        }
        double[] ds = new double[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ds[i] = Numbers.round(doubles[i], newScale, roundingMode);
        }
        return ds;
    }

    public static Double[] round(Number[] numbers) {
        return Numbers.round(numbers, 2, RoundingMode.HALF_UP);
    }

    public static Double[] round(Number[] numbers, int newScale) {
        return Numbers.round(numbers, newScale, RoundingMode.HALF_UP);
    }

    public static Double[] round(Number[] numbers, int newScale, RoundingMode roundingMode) {
        if (numbers == null) {
            return null;
        }
        Double[] ds = new Double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            ds[i] = Numbers.round(numbers[i], newScale, roundingMode);
        }
        return ds;
    }

    public static Double[] round(Collection<? extends Number> numbers) {
        return Numbers.round(numbers, 2, RoundingMode.HALF_UP);
    }

    public static Double[] round(Collection<? extends Number> numbers, int newScale) {
        return Numbers.round(numbers, newScale, RoundingMode.HALF_UP);
    }

    public static Double[] round(Collection<? extends Number> numbers, int newScale, RoundingMode roundingMode) {
        if (numbers == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return new Double[0];
        }
        Double[] ds = new Double[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ds[i] = Numbers.round(iterator.next(), newScale, roundingMode);
            ++i;
        }
        return ds;
    }

    public static Double round(Number number) {
        return Numbers.round(number, 2, RoundingMode.HALF_UP);
    }

    public static Double round(Number number, int newScale) {
        return Numbers.round(number, newScale, RoundingMode.HALF_UP);
    }

    public static Double round(Number number, int newScale, RoundingMode roundingMode) {
        if (number == null) {
            return null;
        }
        if (O.isInfinityOrNaN((Number)number)) {
            return number.doubleValue();
        }
        if (O.isFloat((Number)number) || number instanceof BigDecimal) {
            return Numbers.round(O.toBigDecimal((Number)number), newScale, roundingMode);
        }
        return newScale < 0 ? Numbers.round(O.toBigDecimal((Number)number), newScale, roundingMode).doubleValue() : number.doubleValue();
    }

    public static Double round(BigDecimal bigDecimal, int newScale, RoundingMode roundingMode) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(newScale, roundingMode).doubleValue();
    }

    public static Double[] doubles(Number ... numbers) {
        if (numbers == null) {
            return null;
        }
        Double[] ds = new Double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            Number number = numbers[i];
            ds[i] = number == null ? null : Double.valueOf(number.doubleValue());
        }
        return ds;
    }

    public static Double[] doubles(Collection<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return new Double[0];
        }
        Double[] ds = new Double[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Number number = iterator.next();
            ds[i] = number == null ? null : Double.valueOf(number.doubleValue());
            ++i;
        }
        return ds;
    }

    public static double[] doubles(float[] floats) {
        if (floats == null) {
            return null;
        }
        double[] ds = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            ds[i] = floats[i];
        }
        return ds;
    }

    public static Float[] floats(Number ... numbers) {
        if (numbers == null) {
            return null;
        }
        Float[] fs = new Float[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            Number number = numbers[i];
            fs[i] = number == null ? null : Float.valueOf(number.floatValue());
        }
        return fs;
    }

    public static Float[] floats(Collection<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        if (numbers.size() == 0) {
            return new Float[0];
        }
        Float[] fs = new Float[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Number number = iterator.next();
            fs[i] = number == null ? null : Float.valueOf(number.floatValue());
            ++i;
        }
        return fs;
    }

    public static float[] floats(double[] doubles) {
        if (doubles == null) {
            return null;
        }
        float[] fs = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            fs[i] = (float)doubles[i];
        }
        return fs;
    }
}

