/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.except.UnexpectedParameterException;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

public class Ranges {
    public static List<Tuple2<Long, Long>> divideRange(long beginIndex, long endIndex, int divideCount, float skewRatio) {
        if (divideCount < 2) {
            throw new UnexpectedParameterException("parameter `divideCount` must \u2265 2!");
        }
        long dataCount = endIndex - beginIndex;
        if (dataCount < (long)divideCount) {
            throw new UnexpectedParameterException("(`endIndex` - `beginIndex`) must be \u2265 `divideCount`!");
        }
        if (skewRatio <= -1.0f || skewRatio >= 1.0f) {
            throw new UnexpectedParameterException("parameter `skewRatio` must be in (-1, 1)!");
        }
        double ratioSum = IntStream.range(0, divideCount).boxed().mapToDouble(i -> Math.pow(1.0f + skewRatio, i.intValue())).sum();
        ratioSum = new BigDecimal(ratioSum).setScale(4, RoundingMode.DOWN).doubleValue();
        ArrayList<Tuple2<Long, Long>> rangeList = new ArrayList<Tuple2<Long, Long>>();
        float floatFirstSize = new BigDecimal((double)dataCount / ratioSum).setScale(4, RoundingMode.DOWN).floatValue();
        long firstSize = new BigDecimal(floatFirstSize).setScale(0, RoundingMode.HALF_UP).longValue();
        rangeList.add(Tuple.of((Object)beginIndex, (Object)(firstSize + beginIndex)).alias(new String[]{"beginInclusive", "endExclusive"}));
        for (int i2 = 1; i2 < divideCount; ++i2) {
            Tuple2 preRange = (Tuple2)rangeList.get(i2 - 1);
            long lineSize = new BigDecimal((double)floatFirstSize * Math.pow(1.0f + skewRatio, i2)).setScale(0, RoundingMode.HALF_UP).longValue();
            rangeList.add((Tuple2<Long, Long>)Tuple.of((Object)((Long)preRange._2), (Object)(i2 < divideCount - 1 ? (Long)preRange._2 + lineSize : endIndex)).alias(new String[]{"beginInclusive", "endExclusive"}));
        }
        return rangeList;
    }
}

