/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.zip;

import com.iofairy.falcon.zip.ArchiveType;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ArchiveFormat {
    A(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".a", "Unix Archiver"),
    AR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".ar", "Unix Archiver"),
    CPIO(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".cpio", "cpio"),
    SHAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".shar", "Shell archive"),
    LBR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".LBR", ".LBR"),
    MAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".mar", "Mozilla ARchive"),
    SBX(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".sbx", "SeqBox"),
    TAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".tar", "Tape archive"),
    BROTLI(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".br", "Brotli"),
    BZIP2(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".bz2", "bzip2"),
    GZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".gz", "gzip"),
    LZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lz", "lzip"),
    LZ4(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lz4", "LZ4"),
    LZMA(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lzma", "lzma"),
    LZOP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lzo", "lzop"),
    RZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".rz", "rzip"),
    SNAPPY(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".sz", "Snappy"),
    XZ(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".xz", "xz"),
    Z_PACK(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".z", "pack"),
    Z_COMPRESS(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".Z", "compress"),
    ZSTD(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".zst", "Zstandard"),
    SEVEN_ZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".7z", "7z"),
    S7Z(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".s7z", "7zX"),
    ACE(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".ace", "ACE"),
    ARJ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".arj", "ARJ"),
    RAR(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".rar", "RAR"),
    TAR_GZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.gz", "tar with gzip"),
    TAR_Z(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.Z", "tar with compress"),
    TAR_BZ2(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.bz2", "tar with bzip2"),
    TBZ2(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tbz2", "tar with bzip2"),
    TAR_LZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.lz", "tar with lzip"),
    TLZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tlz", "tar with lzip"),
    TAR_XZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.xz", "tar with xz"),
    TXZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".txz", "tar with xz"),
    TAR_ZST(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.zst", "tar with zstd"),
    ZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".zip", "ZIP"),
    ZZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".zz", "Zzip"),
    DEB(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".deb", "Debian package (deb)"),
    PKG(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".pkg", "Macintosh Installer"),
    MPKG(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".mpkg", "Macintosh Installer"),
    RPM(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".rpm", "RPM Package Manager (RPM)"),
    TGZ(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".tgz", "Slackware Package"),
    MSI(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".msi", "Windows Installer (also MSI)"),
    JAR(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".jar", "Java Archive (JAR)"),
    WAR(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".war", "Web Application archive (Java-based web app)"),
    IPA(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".ipa", "iOS and iPadOS application package"),
    APK(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apk", "Android application package"),
    XAPK(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".xapk", "Android application package"),
    APKS(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apks", "Android application package"),
    APKM(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apkm", "Android application package"),
    CRX(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".crx", "Google Chrome extension package"),
    DMG(EnumSet.of(ArchiveType.DISK_IMAGE, ArchiveType.MULTI_FUNCTION), ".dmg", "Apple Disk Image"),
    ISO(EnumSet.of(ArchiveType.DISK_IMAGE, ArchiveType.ARCHIVING_ONLY), ".iso", "ISO-9660 image");

    public final EnumSet<ArchiveType> archiveTypes;
    public final String extName;
    public final String description;
    static final Map<String, ArchiveFormat> SA_MAP;

    private ArchiveFormat(EnumSet<ArchiveType> archiveTypes, String extName, String description) {
        this.archiveTypes = archiveTypes;
        this.extName = extName;
        this.description = description;
    }

    public static ArchiveFormat of(String extName) {
        if (extName == null) {
            return null;
        }
        if (!extName.startsWith(".")) {
            extName = "." + extName;
        }
        return SA_MAP.get(extName.equals(".z") || extName.equals(".Z") ? extName : extName.toLowerCase());
    }

    static {
        SA_MAP = new HashMap<String, ArchiveFormat>();
        for (ArchiveFormat value : ArchiveFormat.values()) {
            String ext = value.extName;
            if (ext.equals(".z") || ext.equals(".Z")) {
                SA_MAP.put(value.extName, value);
                continue;
            }
            SA_MAP.put(ext.toLowerCase(), value);
        }
    }
}

