/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.fs;

import com.iofairy.falcon.fs.FileInFolder;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;

public class FileKit {
    public static File[] listFiles(File file) {
        return FileKit.listFiles(file, 0, null);
    }

    public static File[] listFiles(File file, FileFilter filter) {
        return FileKit.listFiles(file, 0, filter);
    }

    public static File[] listFiles(File file, int recursiveLevel) {
        return FileKit.listFiles(file, recursiveLevel, null);
    }

    public static File[] listFiles(File file, int recursiveLevel, FileFilter filter) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File[] fileArray = file.listFiles(filter);
        if (fileArray == null) {
            return null;
        }
        ArrayList<File> files = new ArrayList<File>();
        for (File f : fileArray) {
            FileKit.listFiles(f, files, recursiveLevel, filter);
        }
        return files.toArray(new File[0]);
    }

    private static void listFiles(File file, List<File> files, int recursiveLevel, FileFilter filter) {
        files.add(file);
        if (file.isDirectory() && recursiveLevel != 0) {
            File[] fileArray = file.listFiles(filter);
            if (fileArray == null) {
                return;
            }
            for (File f : fileArray) {
                FileKit.listFiles(f, files, recursiveLevel - 1, filter);
            }
        }
    }

    public static List<FileInFolder> listFileInFolders(String filePath) {
        if (filePath == null) {
            return new ArrayList<FileInFolder>();
        }
        return FileKit.listFileInFolders(new File(filePath), false);
    }

    public static List<FileInFolder> listFileInFolders(File file) {
        return FileKit.listFileInFolders(file, false);
    }

    public static List<FileInFolder> listFileInFolders(String filePath, boolean isExcludeFilesNoPermissions) {
        if (filePath == null) {
            return new ArrayList<FileInFolder>();
        }
        return FileKit.listFileInFolders(new File(filePath), isExcludeFilesNoPermissions);
    }

    public static List<FileInFolder> listFileInFolders(File file, boolean isExcludeFilesNoPermissions) {
        ArrayList<FileInFolder> fileInFolders = new ArrayList<FileInFolder>();
        if (file != null && file.exists()) {
            String absolutePath = file.getAbsolutePath();
            String fileName = file.getName();
            if (file.isFile()) {
                FileInFolder fileInFolder = new FileInFolder(file, absolutePath, "", fileName, true, false);
                fileInFolders.add(fileInFolder);
            } else {
                boolean isBasePathRoot = file.getParent() == null;
                FileInFolder fileInFolder = new FileInFolder(file, absolutePath, "", fileName, true, isBasePathRoot);
                fileInFolders.add(fileInFolder);
                File[] files = file.listFiles();
                if (files == null) {
                    if (!isExcludeFilesNoPermissions) {
                        throw new SecurityException("\"" + absolutePath + "\" the file does not exist, or has no permission to access!");
                    }
                } else {
                    for (File listFile : files) {
                        FileKit.listFileInFolders(fileInFolders, listFile, absolutePath, isBasePathRoot, "", isBasePathRoot ? "" : fileName + "/", isExcludeFilesNoPermissions);
                    }
                }
            }
        }
        return fileInFolders;
    }

    private static void listFileInFolders(List<FileInFolder> fileInFolders, File file, String basePath, boolean isBasePathRoot, String prefix, String prefixWithBaseName, boolean isExcludeFilesNoPermissions) {
        String fileName = file.getName();
        FileInFolder fileInFolder = new FileInFolder(file, basePath, prefix + fileName, prefixWithBaseName + fileName, false, isBasePathRoot);
        fileInFolders.add(fileInFolder);
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            String absolutePath = file.getAbsolutePath();
            if (files == null) {
                if (!isExcludeFilesNoPermissions) {
                    throw new SecurityException("\"" + absolutePath + "\" the file does not exist, or has no permission to access!");
                }
            } else {
                for (File listFile : files) {
                    FileKit.listFileInFolders(fileInFolders, listFile, basePath, isBasePathRoot, prefix + fileName + "/", prefixWithBaseName + fileName + "/", isExcludeFilesNoPermissions);
                }
            }
        }
    }
}

