/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.id;

import com.iofairy.falcon.time.DateTime;
import com.iofairy.os.OS;
import com.iofairy.top.S;
import com.iofairy.validator.Preconditions;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.UUID;
import java.util.regex.Pattern;

@Deprecated
public class TimedID {
    private static final int MIN_ID_LENGTH = 25;
    private static final int MAX_ID_LENGTH = 50;
    private static final int DEFAULT_ID_LENGTH = 25;
    private static final int DEFAULT_WORKER_NUM = 0;
    private static final int MIN_WORKERID_LENGTH = 1;
    private static final int MAX_WORKERID_LENGTH = 6;
    private static final int DEFAULT_WORKERID_LENGTH = 2;
    private static final boolean DEFAULT_UPPER_CASE = true;
    private static final boolean DEFAULT_WITH_UNDERLINE = false;
    private static final int MIN_YEAR_LENGTH = 2;
    private static final int MAX_YEAR_LENGTH = 5;
    private static final int DEFAULT_YEAR_LENGTH = 3;
    private static final boolean DEFAULT_WITH_TIMESTAMP = false;
    private static final Instant DEFAULT_START_INSTANT = Instant.EPOCH;
    private static final int MIN_EPOCH_MILLIS_LENGTH = 12;
    private static TimedID DEFAULT_ID;
    public static final TimedID TIMED_ID;
    public static final TimedID TIMED_ID26;
    public static final TimedID TIMED_ID30;
    public static final TimedID TIMED_ID32;
    public static final TimedID TIMED_ID_UNDERLINE;
    public static final TimedID TS_ID;
    public static final TimedID TS_ID26;
    public static final TimedID TS_ID30;
    public static final TimedID TS_ID32;
    public static final TimedID TS_ID_UNDERLINE;
    private static final Pattern PATTERN;
    public final int workerNum;
    public final int workerIdLength;
    public final String workerId;
    public final int idLength;
    public final boolean upperCase;
    public final boolean withUnderline;
    public final int yearLength;
    public final boolean withTimestamp;
    public final Instant startInstant;
    private final DateTimeFormatter formatter;
    private final String underlineWithWorkerId;

    TimedID(Builder builder) {
        this(builder.workerNum, builder.workerIdLength, builder.idLength, builder.upperCase, builder.withUnderline, builder.yearLength, builder.withTimestamp, builder.startInstant);
    }

    TimedID(int workerNum, int workerIdLength, int idLength, boolean upperCase, boolean withUnderline, int yearLength, boolean withTimestamp, Instant startInstant) {
        this.workerNum = workerNum;
        this.workerIdLength = workerIdLength < 1 ? 1 : Math.min(workerIdLength, 6);
        this.idLength = idLength < 25 ? 25 : Math.min(idLength, 50);
        this.upperCase = upperCase;
        this.withUnderline = withUnderline;
        this.workerId = TimedID.numberToLetters(this.workerNum, this.workerIdLength);
        this.yearLength = yearLength < 2 ? 2 : Math.min(yearLength, 5);
        this.withTimestamp = withTimestamp;
        this.startInstant = startInstant;
        this.underlineWithWorkerId = (this.withUnderline ? "_" : "") + this.workerId;
        this.formatter = new DateTimeFormatterBuilder().appendValueReduced((TemporalField)ChronoField.YEAR, this.yearLength, this.yearLength, 0).appendPattern("MMddHHmmssSSS").toFormatter();
    }

    public static Builder newBuilder() {
        return Builder.newBuilder();
    }

    public static String getId() {
        TimedID.setDefaultId(TIMED_ID);
        return DEFAULT_ID.randomId();
    }

    public static String newId() {
        return TIMED_ID.randomId();
    }

    public static String shortId() {
        return TIMED_ID26.randomId();
    }

    public static String mediumId() {
        return TIMED_ID30.randomId();
    }

    public static String longId() {
        return TIMED_ID32.randomId();
    }

    public static String linedId() {
        return TIMED_ID_UNDERLINE.randomId();
    }

    public static String nid() {
        return TS_ID.randomId();
    }

    public static String sid() {
        return TS_ID26.randomId();
    }

    public static String mid() {
        return TS_ID30.randomId();
    }

    public static String lid() {
        return TS_ID32.randomId();
    }

    public static String _id() {
        return TS_ID_UNDERLINE.randomId();
    }

    public String randomId() {
        String timestamp = S.padLeftChars((Number)(Instant.now().toEpochMilli() - this.startInstant.toEpochMilli()), (char)'0', (int)12);
        String dateTime = this.withTimestamp ? timestamp : this.formatter.format(LocalDateTime.now());
        String base36 = TimedID.uuidToBase36();
        String id = dateTime + this.underlineWithWorkerId + base36;
        id = id.substring(0, Math.min(this.idLength, id.length()));
        return this.upperCase ? id.toUpperCase() : id.toLowerCase();
    }

    public static TimedID getDefaultId() {
        return DEFAULT_ID;
    }

    public static void setDefaultId(TimedID defaultId) {
        if (DEFAULT_ID == null) {
            DEFAULT_ID = defaultId;
        }
    }

    private static String uuidToBase36() {
        int radix;
        String hexUuid = UUID.randomUUID().toString();
        BigInteger bigInteger = new BigInteger(hexUuid = PATTERN.matcher(hexUuid).replaceAll(""), 16);
        String base36 = bigInteger.toString(radix = 36);
        if (base36.length() < 25) {
            base36 = S.padRightChars((CharSequence)base36, (char)'0', (int)25);
        }
        return base36;
    }

    public static String numberToLetters(int number, int letterLength) {
        Preconditions.checkOutOfBounds((number < 0 ? 1 : 0) != 0, (Number)number, (String)(OS.IS_ZH_LANG ? "\u53c2\u6570`number`\u5e94\u4e3a\u975e\u8d1f\u6570\uff01" : "Parameter `number` must be non-negative! "), (Object[])new Object[0]);
        Preconditions.checkOutOfBounds((letterLength < 1 || letterLength > 6 ? 1 : 0) != 0, (Number)number, (String)(OS.IS_ZH_LANG ? "\u53c2\u6570`letterLength`\u53d6\u503c\u8303\u56f4\u4e3a\uff1a[1, 6]\uff01" : "Parameter `letterLength` must be in [1, 6]! "), (Object[])new Object[0]);
        int maxNumber = (int)Math.pow(26.0, letterLength) - 1;
        Preconditions.checkArgument((number > maxNumber ? 1 : 0) != 0, (String)"\u53c2\u6570`number`\u8d85\u51fa\u8303\u56f4\uff0c\u5f53\u524d\u4f4d\u6570[${letterLength}]\u4e0b\uff0c\u6700\u5927\u5141\u8bb8\u503c[${maxNumber}]\uff0c\u65e0\u6cd5\u6620\u5c04\u5230\u6307\u5b9a\u4f4d\u6570\u7684\u5b57\u6bcd\uff01", (Object[])new Object[]{letterLength, maxNumber});
        char[] letters = new char[letterLength];
        for (int i = letterLength - 1; i >= 0; --i) {
            letters[i] = (char)(65 + number % 26);
            number /= 26;
        }
        return String.valueOf(letters);
    }

    public String toString() {
        return "TimedID{workerNum=" + this.workerNum + ", workerIdLength=" + this.workerIdLength + ", workerId='" + this.workerId + '\'' + ", idLength=" + this.idLength + ", upperCase=" + this.upperCase + ", withUnderline=" + this.withUnderline + ", yearLength=" + this.yearLength + ", withTimestamp=" + this.withTimestamp + ", startInstant=" + this.startInstant + ", startEpochMillis=" + this.startInstant.toEpochMilli() + '}';
    }

    static /* synthetic */ Instant access$000() {
        return DEFAULT_START_INSTANT;
    }

    static {
        TIMED_ID = TimedID.newBuilder().withYearLength(2).build();
        TIMED_ID26 = TimedID.newBuilder().withIdLength(26).build();
        TIMED_ID30 = TimedID.newBuilder().withIdLength(30).build();
        TIMED_ID32 = TimedID.newBuilder().withIdLength(32).withYearLength(4).build();
        TIMED_ID_UNDERLINE = TimedID.newBuilder().withUnderline(true).withIdLength(30).withWorkerIdLength(1).build();
        TS_ID = TimedID.newBuilder().withTimestamp(true).build();
        TS_ID26 = TimedID.newBuilder().withTimestamp(true).withIdLength(26).build();
        TS_ID30 = TimedID.newBuilder().withTimestamp(true).withIdLength(30).build();
        TS_ID32 = TimedID.newBuilder().withTimestamp(true).withIdLength(32).build();
        TS_ID_UNDERLINE = TimedID.newBuilder().withTimestamp(true).withUnderline(true).withIdLength(30).withWorkerIdLength(1).build();
        PATTERN = Pattern.compile("-");
    }

    public static class Builder {
        private int workerNum = 0;
        private int workerIdLength = 2;
        private int idLength = 25;
        private boolean upperCase = true;
        private boolean withUnderline = false;
        private int yearLength = 3;
        private boolean withTimestamp = false;
        private Instant startInstant = TimedID.access$000();

        Builder() {
        }

        Builder(int idLength, boolean withUnderline, boolean withTimestamp) {
            this.idLength = idLength;
            this.withUnderline = withUnderline;
            this.withTimestamp = withTimestamp;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public static Builder newBuilder(int idLength, boolean withUnderline, boolean withTimestamp) {
            return new Builder(idLength, withUnderline, withTimestamp);
        }

        public Builder withWorkerNum(int workerNum) {
            this.workerNum = workerNum;
            return this;
        }

        public Builder withWorkerIdLength(int workerIdLength) {
            this.workerIdLength = workerIdLength;
            return this;
        }

        public Builder withIdLength(int idLength) {
            this.idLength = idLength;
            return this;
        }

        public Builder withUpperCase(boolean upperCase) {
            this.upperCase = upperCase;
            return this;
        }

        public Builder withUnderline(boolean withUnderline) {
            this.withUnderline = withUnderline;
            return this;
        }

        public Builder withYearLength(int yearLength) {
            this.yearLength = yearLength;
            return this;
        }

        public Builder withTimestamp(boolean withTimestamp) {
            this.withTimestamp = withTimestamp;
            return this;
        }

        public Builder withStartInstant(Instant startInstant) {
            if (startInstant == null) {
                return this;
            }
            Preconditions.checkArgument((startInstant.toEpochMilli() < 0L ? 1 : 0) != 0, (String)"The parameter `startInstant` must be after `1970-01-01T00:00:00.000Z`! ", (Object[])new Object[0]);
            Instant nowInstant = Instant.now();
            Preconditions.checkArgument((boolean)startInstant.isAfter(nowInstant), (String)"The parameter `startInstant` must be before current date time[${\u2026}]! ", (Object[])new Object[]{nowInstant});
            this.startInstant = startInstant;
            return this;
        }

        public Builder withStartInstant(String dateText) {
            if (dateText == null) {
                return this;
            }
            Instant startInstant = DateTime.parseDate(dateText).getInstant();
            return this.withStartInstant(startInstant);
        }

        public TimedID build() {
            return new TimedID(this);
        }
    }
}

