/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.io;

import com.iofairy.falcon.io.MultiByteArrayInputStream;
import com.iofairy.falcon.io.MultiByteArrayOutputStream;
import com.iofairy.tcf.Close;
import com.iofairy.validator.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IOs {
    public static final int EOF = -1;
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static MultiByteArrayInputStream toMultiBAIS(InputStream inputStream) throws IOException {
        Preconditions.checkNullNPE((Object)inputStream, (String[])Preconditions.args((String[])new String[]{"inputStream"}));
        try (MultiByteArrayOutputStream multiBaos = new MultiByteArrayOutputStream();){
            IOs.copy(inputStream, multiBaos);
            MultiByteArrayInputStream multiByteArrayInputStream = new MultiByteArrayInputStream(multiBaos.toByteArrays());
            return multiByteArrayInputStream;
        }
    }

    public static MultiByteArrayOutputStream toMultiBAOS(InputStream inputStream) throws IOException {
        Preconditions.checkNullNPE((Object)inputStream, (String[])Preconditions.args((String[])new String[]{"inputStream"}));
        MultiByteArrayOutputStream multiBaos = null;
        try {
            multiBaos = new MultiByteArrayOutputStream();
            IOs.copy(inputStream, multiBaos);
            return multiBaos;
        }
        catch (Exception e) {
            Close.close((AutoCloseable)multiBaos);
            throw new IOException(e);
        }
    }

    public static long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return IOs.copy(inputStream, outputStream, new byte[8192]);
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, long copyLength) throws IOException {
        int n;
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{inputStream, outputStream}), (String[])Preconditions.args((String[])new String[]{"inputStream", "outputStream"}));
        if (copyLength <= 0L) {
            return 0L;
        }
        byte[] buffer = new byte[(int)Math.min(8192L, copyLength)];
        long count = 0L;
        while ((n = inputStream.read(buffer)) != -1 && copyLength > 0L) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
            if ((copyLength -= (long)n) < 0L) {
                copyLength = 0L;
            }
            buffer = new byte[(int)Math.min(8192L, copyLength)];
        }
        return count;
    }

    public static long copy(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{inputStream, outputStream, buffer}), (String[])Preconditions.args((String[])new String[]{"inputStream", "outputStream", "buffer"}));
        long count = 0L;
        while ((n = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static byte[][] readBytes(InputStream is) throws IOException {
        return IOs.readBytes(is, null, true);
    }

    public static byte[][] readBytes(InputStream is, Long readLength) throws IOException {
        return IOs.readBytes(is, readLength, true);
    }

    public static byte[][] readBytes(InputStream is, boolean isClose) throws IOException {
        return IOs.readBytes(is, null, isClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[][] readBytes(InputStream is, Long readLength, boolean isClose) throws IOException {
        Preconditions.checkNullNPE((Object)is, (String[])Preconditions.args((String[])new String[]{"is"}));
        MultiByteArrayOutputStream baos = null;
        try {
            baos = new MultiByteArrayOutputStream();
            if (readLength == null) {
                IOs.copy(is, (OutputStream)baos, new byte[8192]);
            } else {
                IOs.copy(is, (OutputStream)baos, readLength);
            }
            byte[][] byArray = baos.toByteArrays();
            return byArray;
        }
        finally {
            if (isClose) {
                Close.close((AutoCloseable)is);
            }
            Close.close((AutoCloseable)baos);
        }
    }
}

