/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.iterable;

import com.iofairy.falcon.map.MapKit;
import com.iofairy.lambda.P2;
import com.iofairy.top.G;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import com.iofairy.validator.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CollectionKit {
    public static <T> List<T[]> divide(T[] arr, int perBatchSize) {
        ArrayList<T[]> las = new ArrayList<T[]>();
        if (!G.isEmpty(arr)) {
            if (perBatchSize <= 0) {
                las.add(arr);
                return las;
            }
            int size = arr.length;
            for (int fromIndex = 0; fromIndex < size; fromIndex += perBatchSize) {
                int toIndex = Math.min(fromIndex + perBatchSize, size);
                las.add(Arrays.copyOfRange(arr, fromIndex, toIndex));
            }
        }
        return las;
    }

    public static <T> List<List<T>> divide(List<T> list, int perBatchSize) {
        ArrayList<List<T>> lls = new ArrayList<List<T>>();
        if (!G.isEmpty(list)) {
            if (perBatchSize <= 0) {
                lls.add(list);
                return lls;
            }
            int size = list.size();
            for (int fromIndex = 0; fromIndex < size; fromIndex += perBatchSize) {
                int toIndex = Math.min(fromIndex + perBatchSize, size);
                lls.add(list.subList(fromIndex, toIndex));
            }
        }
        return lls;
    }

    public static <T> List<Set<T>> divide(Set<T> set, int perBatchSize) {
        ArrayList lss = new ArrayList();
        if (!G.isEmpty(set)) {
            if (perBatchSize <= 0) {
                lss.add(set);
                return lss;
            }
            ArrayList<T> ts = new ArrayList<T>(set);
            List<List<List>> ll = CollectionKit.divide(ts, perBatchSize);
            ll.forEach(e -> lss.add(new HashSet(e)));
        }
        return lss;
    }

    public static <K, V> List<Map<K, V>> divide(Map<K, V> map, int perBatchSize) {
        ArrayList lms = new ArrayList();
        if (!G.isEmpty(map)) {
            if (perBatchSize <= 0) {
                lms.add(map);
                return lms;
            }
            Set<K> ks = map.keySet();
            List<Set<K>> lss = CollectionKit.divide(ks, perBatchSize);
            lss.forEach(s -> lms.add(s.stream().collect(Collectors.toMap(e -> e, map::get))));
        }
        return lms;
    }

    public static <E> List<List<E>> balance(int partitions, Collection<? extends Collection<E>> collections) {
        if (partitions <= 0 || G.isEmpty(collections)) {
            return null;
        }
        List sortedLists = collections.stream().filter(coll -> !G.isEmpty((Object)coll)).map(ArrayList::new).sorted(Comparator.comparingInt(list -> -list.size())).collect(Collectors.toList());
        if (G.isEmpty(sortedLists)) {
            return null;
        }
        int min = Math.min(partitions, sortedLists.size());
        HashMap<Integer, List> map = new HashMap<Integer, List>();
        for (int i = 0; i < min; ++i) {
            map.put(i, (List)sortedLists.remove(0));
        }
        List<Map.Entry<Integer, List<E>>> entries = MapKit.sortBy(map, kv -> ((List)kv.getValue()).size());
        for (List list2 : sortedLists) {
            ((List)entries.get(0).getValue()).addAll(list2);
            CollectionKit.fastSortForBalance(entries);
        }
        return entries.stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @SafeVarargs
    public static <E> List<List<E>> balance(int partitions, Collection<E> ... listArray) {
        if (partitions <= 0 || G.isEmpty(listArray)) {
            return null;
        }
        return CollectionKit.balance(partitions, Arrays.asList(listArray));
    }

    @SafeVarargs
    public static <E> List<List<E>> balance(int partitions, E[] ... arrays) {
        if (partitions <= 0 || G.isEmpty(arrays)) {
            return null;
        }
        List lists = Arrays.stream(arrays).filter(Objects::nonNull).map(Arrays::asList).collect(Collectors.toList());
        return CollectionKit.balance(partitions, lists);
    }

    private static <E> void fastSortForBalance(List<Map.Entry<Integer, List<E>>> sortedEntries) {
        if (G.isEmpty(sortedEntries) || sortedEntries.size() <= 1) {
            return;
        }
        int entriesSize = sortedEntries.size();
        Map.Entry<Integer, List<E>> firstEntry = sortedEntries.get(0);
        List<E> firstValue = firstEntry.getValue();
        int firstValueSize = firstValue.size();
        int preGtIndex = 0;
        int i = 1;
        while (i < entriesSize && firstValueSize > sortedEntries.get(i).getValue().size()) {
            preGtIndex = i++;
        }
        if (preGtIndex != 0) {
            sortedEntries.add(preGtIndex + 1, firstEntry);
            sortedEntries.remove(0);
        }
    }

    public static <T> T findNth(Collection<T> ts, Predicate<? super T> filter, int nth) {
        if (G.isEmpty(ts) || Math.abs(nth) > ts.size()) {
            return null;
        }
        int objNth = 0;
        T t = null;
        if (filter == null) {
            nth = nth < 0 ? ts.size() + nth : nth;
            for (T t1 : ts) {
                if (objNth == nth) {
                    t = t1;
                    break;
                }
                ++objNth;
            }
        } else {
            ArrayList<T> tList = new ArrayList<T>();
            for (T t1 : ts) {
                if (!filter.test(t1)) continue;
                if (nth < 0) {
                    tList.add(t1);
                    continue;
                }
                if (objNth == nth) {
                    t = t1;
                    break;
                }
                ++objNth;
            }
            if (!G.isEmpty(tList) && tList.size() + nth >= 0) {
                t = (T)tList.get(tList.size() + nth);
            }
        }
        return t;
    }

    public static <T> Tuple2<T, Integer> findNth(List<T> ts, Predicate<? super T> filter, int nth) {
        if (G.isEmpty(ts) || Math.abs(nth) > ts.size()) {
            return null;
        }
        int objNth = 0;
        Tuple2 tuple = null;
        if (filter == null) {
            int n = nth = nth < 0 ? ts.size() + nth : nth;
            if (nth >= 0 && ts.size() > nth) {
                tuple = Tuple.of(ts.get(nth), (Object)nth);
            }
        } else {
            ArrayList<Tuple2> tList = new ArrayList<Tuple2>();
            for (int i = 0; i < ts.size(); ++i) {
                T t = ts.get(i);
                if (!filter.test(t)) continue;
                if (nth < 0) {
                    tList.add(Tuple.of(t, (Object)i));
                    continue;
                }
                if (objNth == nth) {
                    tuple = Tuple.of(t, (Object)i);
                    break;
                }
                ++objNth;
            }
            if (!G.isEmpty(tList) && tList.size() + nth >= 0) {
                tuple = (Tuple2)tList.get(tList.size() + nth);
            }
        }
        return tuple;
    }

    public static <T> Tuple2<T, Integer> findNth(T[] ts, Predicate<? super T> filter, int nth) {
        if (G.isEmpty(ts) || Math.abs(nth) > ts.length) {
            return null;
        }
        return CollectionKit.findNth(Arrays.asList(ts), filter, nth);
    }

    public static <T> T findRandom(Collection<T> ts, Predicate<? super T> filter) {
        if (G.isEmpty(ts)) {
            return null;
        }
        T t = null;
        Random random = new Random();
        if (filter == null) {
            int randomIndex = random.nextInt(ts.size());
            int objNth = 0;
            for (T t1 : ts) {
                if (objNth == randomIndex) {
                    t = t1;
                    break;
                }
                ++objNth;
            }
        } else {
            ArrayList<T> tList = new ArrayList<T>();
            for (T t1 : ts) {
                if (!filter.test(t1)) continue;
                tList.add(t1);
            }
            if (!G.isEmpty(tList)) {
                int randomIndex = random.nextInt(tList.size());
                t = (T)tList.get(randomIndex);
            }
        }
        return t;
    }

    public static <T> Tuple2<T, Integer> findRandom(List<T> ts, Predicate<? super T> filter) {
        if (G.isEmpty(ts)) {
            return null;
        }
        Tuple2 tuple = null;
        Random random = new Random();
        if (filter == null) {
            int randomIndex = random.nextInt(ts.size());
            tuple = Tuple.of(ts.get(randomIndex), (Object)randomIndex);
        } else {
            ArrayList<Tuple2> tList = new ArrayList<Tuple2>();
            for (int i = 0; i < ts.size(); ++i) {
                T t = ts.get(i);
                if (!filter.test(t)) continue;
                tList.add(Tuple.of(t, (Object)i));
            }
            if (!G.isEmpty(tList)) {
                int randomIndex = random.nextInt(tList.size());
                tuple = (Tuple2)tList.get(randomIndex);
            }
        }
        return tuple;
    }

    public static <T> Tuple2<T, Integer> findRandom(T[] ts, Predicate<? super T> filter) {
        if (G.isEmpty(ts)) {
            return null;
        }
        return CollectionKit.findRandom(Arrays.asList(ts), filter);
    }

    public static <A, B> List<A> difference(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition) {
        Preconditions.checkNullNPE(equalsCondition, (String[])Preconditions.args((String[])new String[]{"equalsCondition"}));
        if (as == null) {
            return new ArrayList();
        }
        if (G.isEmpty(as) || G.isEmpty(bs)) {
            return new ArrayList<A>(as);
        }
        ArrayList<A> results = new ArrayList<A>();
        for (A a : as) {
            B found = CollectionKit.search(bs, a, (p1, p2) -> equalsCondition.$(p2, p1));
            if (found != null) continue;
            results.add(a);
        }
        return results;
    }

    public static <A, B> List<A> intersect(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition) {
        return CollectionKit.intersect(as, bs, equalsCondition, true);
    }

    public static <A, B> List<A> intersect(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition, boolean followFirstOrder) {
        Preconditions.checkNullNPE(equalsCondition, (String[])Preconditions.args((String[])new String[]{"equalsCondition"}));
        if (as == null) {
            return new ArrayList();
        }
        if (G.isEmpty(as) || G.isEmpty(bs)) {
            return new ArrayList<A>(as);
        }
        ArrayList<Object> results = new ArrayList();
        if (followFirstOrder) {
            ArrayList<A> tmpAs = new ArrayList<A>(as);
            Iterator it = tmpAs.iterator();
            while (it.hasNext()) {
                Object a = it.next();
                B found = CollectionKit.search(bs, a, (p1, p2) -> equalsCondition.$(p2, p1));
                if (found != null) continue;
                it.remove();
            }
            results = tmpAs;
        } else {
            for (B b : bs) {
                A found = CollectionKit.search(as, b, equalsCondition);
                if (found == null) continue;
                results.add(found);
            }
        }
        return results;
    }

    public static <A, B> Tuple2<List<A>, List<B>> intersectAndMinusA(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition) {
        return CollectionKit.intersectAndMinusA(as, bs, equalsCondition, true);
    }

    public static <A, B> Tuple2<List<A>, List<B>> intersectAndMinusA(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition, boolean followFirstOrder) {
        Preconditions.checkNullNPE(equalsCondition, (String[])Preconditions.args((String[])new String[]{"equalsCondition"}));
        if (bs == null) {
            return Tuple.of(new ArrayList(), new ArrayList());
        }
        if (G.isEmpty(as) || G.isEmpty(bs)) {
            return Tuple.of(new ArrayList(), new ArrayList<B>(bs));
        }
        ArrayList<Object> results = new ArrayList();
        if (followFirstOrder) {
            ArrayList<A> tmpAs = new ArrayList<A>(as);
            ArrayList<B> bsNotInAs = new ArrayList<B>(bs);
            Iterator it = tmpAs.iterator();
            while (it.hasNext()) {
                Object a = it.next();
                Object found = CollectionKit.search(bs, a, (p1, p2) -> equalsCondition.$(p2, p1));
                if (found == null) {
                    it.remove();
                    continue;
                }
                bsNotInAs.removeIf(e -> Objects.equals(e, found));
            }
            results = tmpAs;
            return Tuple.of(results, bsNotInAs);
        }
        ArrayList<B> bsNotInAs = new ArrayList<B>();
        for (B b : bs) {
            A found = CollectionKit.search(as, b, equalsCondition);
            if (found == null) {
                bsNotInAs.add(b);
                continue;
            }
            results.add(found);
        }
        return Tuple.of(results, bsNotInAs);
    }

    public static <A, B> Tuple2<List<A>, List<A>> intersectAndMinusB(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition) {
        return CollectionKit.intersectAndMinusB(as, bs, equalsCondition, true);
    }

    public static <A, B> Tuple2<List<A>, List<A>> intersectAndMinusB(Collection<A> as, Collection<B> bs, P2<? super A, ? super B> equalsCondition, boolean followFirstOrder) {
        Preconditions.checkNullNPE(equalsCondition, (String[])Preconditions.args((String[])new String[]{"equalsCondition"}));
        if (as == null) {
            return Tuple.of(new ArrayList(), new ArrayList());
        }
        if (G.isEmpty(as) || G.isEmpty(bs)) {
            return Tuple.of(new ArrayList(), new ArrayList<A>(as));
        }
        ArrayList<Object> results = new ArrayList();
        if (followFirstOrder) {
            ArrayList<A> tmpAs = new ArrayList<A>(as);
            ArrayList asNotInBs = new ArrayList();
            Iterator it = tmpAs.iterator();
            while (it.hasNext()) {
                Object a = it.next();
                B found = CollectionKit.search(bs, a, (p1, p2) -> equalsCondition.$(p2, p1));
                if (found != null) continue;
                it.remove();
                asNotInBs.add(a);
            }
            results = tmpAs;
            return Tuple.of(results, asNotInBs);
        }
        ArrayList<A> asNotInBs = new ArrayList<A>(as);
        for (B b : bs) {
            Object found = CollectionKit.search(as, b, equalsCondition);
            if (found == null) continue;
            results.add(found);
            asNotInBs.removeIf(e -> Objects.equals(e, found));
        }
        return Tuple.of(results, asNotInBs);
    }

    public static <A, B> A search(Collection<A> as, B b, P2<? super A, ? super B> equalsCondition) {
        Preconditions.checkNullNPE(equalsCondition, (String[])Preconditions.args((String[])new String[]{"equalsCondition"}));
        if (G.isEmpty(as)) {
            return null;
        }
        for (A a : as) {
            if (!equalsCondition.$(a, b)) continue;
            return a;
        }
        return null;
    }

    public static <A, B> A search(A[] as, B b, P2<? super A, ? super B> equalsCondition) {
        if (G.isEmpty(as)) {
            return null;
        }
        return CollectionKit.search(Arrays.asList(as), b, equalsCondition);
    }
}

