/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.map;

import com.iofairy.top.G;
import com.iofairy.top.O;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;

public class MapKit {
    @SafeVarargs
    public static <K, V> Tuple2<List<K>, List<V>> mapToList(Map<K, V> map, K ... removeKeys) {
        if (map == null) {
            return Tuple.of(null, null);
        }
        if (!G.isEmpty(removeKeys)) {
            for (K removeKey : removeKeys) {
                map.remove(removeKey);
            }
        }
        ArrayList keys = new ArrayList();
        ArrayList values = new ArrayList();
        map.forEach((k, v) -> {
            keys.add(k);
            values.add(v);
        });
        return Tuple.of(keys, values);
    }

    @SafeVarargs
    public static <K, V> List<K> keyToList(Map<K, V> map, K ... removeKeys) {
        return (List)MapKit.mapToList(map, removeKeys)._1;
    }

    @SafeVarargs
    public static <K, V> List<V> valueToList(Map<K, V> map, K ... removeKeys) {
        return (List)MapKit.mapToList(map, removeKeys)._2;
    }

    @SafeVarargs
    public static <K, V> Tuple2<K[], V[]> mapToArray(Map<K, V> map, Class<K> kClass, Class<V> vClass, K ... removeKeys) {
        Tuple2<List<K>, List<V>> tuple2 = MapKit.mapToList(map, removeKeys);
        Object[] ks = tuple2._1 == null ? null : ((List)tuple2._1).toArray(O.arrayO(kClass));
        Object[] vs = tuple2._2 == null ? null : ((List)tuple2._2).toArray(O.arrayO(vClass));
        return Tuple.of((Object)ks, vs);
    }

    @SafeVarargs
    public static <K, V> K[] keyToArray(Map<K, V> map, Class<K> kClass, K ... removeKeys) {
        List<K> ks = MapKit.keyToList(map, removeKeys);
        return ks == null ? null : ks.toArray(O.arrayO(kClass));
    }

    @SafeVarargs
    public static <K, V> V[] valueToArray(Map<K, V> map, Class<V> vClass, K ... removeKeys) {
        List<V> vs = MapKit.valueToList(map, removeKeys);
        return vs == null ? null : vs.toArray(O.arrayO(vClass));
    }

    public static <K, V> List<Map.Entry<K, V>> sortBy(Map<K, V> map, Comparator<? super Map.Entry<K, V>> comparator) {
        return map.entrySet().stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <K, V, U extends Comparable<? super U>> List<Map.Entry<K, V>> sortBy(Map<K, V> map, Function<? super Map.Entry<K, V>, ? extends U> keyExtractor) {
        return MapKit.sortBy(map, Comparator.comparing(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByInt(Map<K, V> map, ToIntFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(map, Comparator.comparingInt(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByLong(Map<K, V> map, ToLongFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(map, Comparator.comparingLong(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByDouble(Map<K, V> map, ToDoubleFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(map, Comparator.comparingDouble(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortBy(List<Map.Entry<K, V>> entries, Comparator<? super Map.Entry<K, V>> comparator) {
        return entries.stream().sorted(comparator).collect(Collectors.toList());
    }

    public static <K, V, U extends Comparable<? super U>> List<Map.Entry<K, V>> sortBy(List<Map.Entry<K, V>> entries, Function<? super Map.Entry<K, V>, ? extends U> keyExtractor) {
        return MapKit.sortBy(entries, Comparator.comparing(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByInt(List<Map.Entry<K, V>> entries, ToIntFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(entries, Comparator.comparingInt(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByLong(List<Map.Entry<K, V>> entries, ToLongFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(entries, Comparator.comparingLong(keyExtractor));
    }

    public static <K, V> List<Map.Entry<K, V>> sortByDouble(List<Map.Entry<K, V>> entries, ToDoubleFunction<? super Map.Entry<K, V>> keyExtractor) {
        return MapKit.sortBy(entries, Comparator.comparingDouble(keyExtractor));
    }

    public static Tuple2<Map<String, Integer>, Map<Integer, String>> mapFromArray(CharSequence ... strings) {
        return MapKit.mapFromList(true, G.isEmpty((Object)strings) ? null : Arrays.asList(strings));
    }

    public static Tuple2<Map<String, Integer>, Map<Integer, String>> mapFromArray(boolean isCaseSensitive, CharSequence ... strings) {
        return MapKit.mapFromList(isCaseSensitive, G.isEmpty((Object)strings) ? null : Arrays.asList(strings));
    }

    public static Tuple2<Map<String, Integer>, Map<Integer, String>> mapFromList(List<? extends CharSequence> strings) {
        return MapKit.mapFromList(true, strings);
    }

    public static Tuple2<Map<String, Integer>, Map<Integer, String>> mapFromList(boolean isCaseSensitive, List<? extends CharSequence> strings) {
        HashMap<String, Integer> stringIndexMap = new HashMap<String, Integer>();
        HashMap<Integer, String> indexStringMap = new HashMap<Integer, String>();
        if (G.isEmpty(strings)) {
            return Tuple.of(stringIndexMap, indexStringMap);
        }
        for (int i = 0; i < strings.size(); ++i) {
            CharSequence charSequence = strings.get(i);
            String str = null;
            if (charSequence != null) {
                str = charSequence.toString();
                str = isCaseSensitive ? str : str.toLowerCase();
            }
            stringIndexMap.put(str, i);
            indexStringMap.put(i, str);
        }
        return Tuple.of(stringIndexMap, indexStringMap);
    }
}

