/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.misc;

import com.iofairy.except.CircularReferencesException;
import com.iofairy.except.ConditionsNotMetException;
import com.iofairy.except.GeneralException;
import com.iofairy.except.IllegalQueryResultException;
import com.iofairy.except.OutOfBoundsException;
import com.iofairy.except.RequestFailureException;
import com.iofairy.except.UnexpectedResultException;
import com.iofairy.except.ai.AICallException;
import com.iofairy.except.ai.AIException;
import com.iofairy.except.ai.AIInferenceException;
import com.iofairy.except.ai.AIRequestException;
import com.iofairy.except.ai.AITrainingException;
import com.iofairy.falcon.misc.ErrorMsgType;
import com.iofairy.si.SI;
import com.iofairy.top.G;
import com.iofairy.top.O;
import com.iofairy.top.S;
import java.io.FileNotFoundException;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

@Deprecated
public final class Preconditions {
    private static final String[] NULL_STR_ARRAY = null;

    private Preconditions() {
    }

    public static Object[] args(Object ... objs) {
        return O.args((Object[])objs);
    }

    public static CharSequence[] args(CharSequence ... cs) {
        return (CharSequence[])O.args((Object[])cs);
    }

    public static String[] args(String ... ss) {
        return (String[])O.args((Object[])ss);
    }

    public static void checkBlank(CharSequence cs) {
        if (S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.BLANK, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkBlank(CharSequence cs, String msgTemplate, Object ... objs) {
        if (S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkBlank(CharSequence cs, String[] paramNames) {
        if (S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.BLANK, paramNames), new Object[0]);
        }
    }

    public static void checkEmpty(Object o) {
        if (G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.EMPTY, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkEmpty(Object o, String msgTemplate, Object ... objs) {
        if (G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkEmpty(Object o, String[] paramNames) {
        if (G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.EMPTY, paramNames), new Object[0]);
        }
    }

    public static void checkNull(Object o) {
        if (o == null) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NULL, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkNull(Object o, String msgTemplate, Object ... objs) {
        if (o == null) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkNull(Object o, String[] paramNames) {
        if (o == null) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NULL, paramNames), new Object[0]);
        }
    }

    public static void checkNotBlank(CharSequence cs) {
        if (!S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_BLANK, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkNotBlank(CharSequence cs, String msgTemplate, Object ... objs) {
        if (!S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkNotBlank(CharSequence cs, String[] paramNames) {
        if (!S.isBlank((CharSequence)cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_BLANK, paramNames), new Object[0]);
        }
    }

    public static void checkNotEmpty(Object o) {
        if (!G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_EMPTY, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkNotEmpty(Object o, String msgTemplate, Object ... objs) {
        if (!G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkNotEmpty(Object o, String[] paramNames) {
        if (!G.isEmpty((Object)o)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_EMPTY, paramNames), new Object[0]);
        }
    }

    public static void checkNotNull(Object o) {
        if (o != null) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_NULL, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkNotNull(Object o, String msgTemplate, Object ... objs) {
        if (o != null) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkNotNull(Object o, String[] paramNames) {
        if (o != null) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.NOT_NULL, paramNames), new Object[0]);
        }
    }

    public static void checkHasBlank(CharSequence[] cs) {
        if (S.hasBlank((CharSequence[])cs)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_BLANK, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_BLANK, cs, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasBlank(CharSequence[] cs, String msgTemplate, Object ... objs) {
        if (S.hasBlank((CharSequence[])cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasBlank(CharSequence[] cs, String[] paramNames) {
        if (S.hasBlank((CharSequence[])cs)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_BLANK, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_BLANK, cs, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasEmpty(Object[] os) {
        if (G.hasEmpty((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_EMPTY, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_EMPTY, os, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasEmpty(Object[] os, String msgTemplate, Object ... objs) {
        if (G.hasEmpty((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasEmpty(Object[] os, String[] paramNames) {
        if (G.hasEmpty((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_EMPTY, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_EMPTY, os, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasNull(Object[] os) {
        if (G.hasNull((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasNull(Object[] os, String msgTemplate, Object ... objs) {
        if (G.hasNull((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasNull(Object[] os, String[] paramNames) {
        if (G.hasNull((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasBlank(Collection<? extends CharSequence> cs) {
        if (S.hasBlank(cs)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_BLANK, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_BLANK, cs, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasBlank(Collection<? extends CharSequence> cs, String msgTemplate, Object ... objs) {
        if (S.hasBlank(cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasBlank(Collection<? extends CharSequence> cs, String[] paramNames) {
        if (S.hasBlank(cs)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_BLANK, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_BLANK, cs, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasEmpty(Collection<?> os) {
        if (G.hasEmpty(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_EMPTY, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_EMPTY, os, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasEmpty(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.hasEmpty(os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasEmpty(Collection<?> os, String[] paramNames) {
        if (G.hasEmpty(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_EMPTY, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_EMPTY, os, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasNull(Collection<?> os) {
        if (G.hasNull(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, NULL_STR_ARRAY);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkHasNull(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.hasNull(os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkHasNull(Collection<?> os, String[] paramNames) {
        if (G.hasNull(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, paramNames);
            Preconditions.throwConditionsNotMetException400(errorMsg, new Object[0]);
        }
    }

    public static void checkAllBlank(CharSequence[] cs) {
        if (S.allBlank((CharSequence[])cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_BLANK, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllBlank(CharSequence[] cs, String msgTemplate, Object ... objs) {
        if (S.allBlank((CharSequence[])cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllBlank(CharSequence[] cs, String[] paramNames) {
        if (S.allBlank((CharSequence[])cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_BLANK, paramNames), new Object[0]);
        }
    }

    public static void checkAllEmpty(Object[] os) {
        if (G.allEmpty((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_EMPTY, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllEmpty(Object[] os, String msgTemplate, Object ... objs) {
        if (G.allEmpty((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllEmpty(Object[] os, String[] paramNames) {
        if (G.allEmpty((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_EMPTY, paramNames), new Object[0]);
        }
    }

    public static void checkAllNull(Object[] os) {
        if (G.allNull((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllNull(Object[] os, String msgTemplate, Object ... objs) {
        if (G.allNull((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllNull(Object[] os, String[] paramNames) {
        if (G.allNull((Object[])os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, paramNames), new Object[0]);
        }
    }

    public static void checkAllBlank(Collection<? extends CharSequence> cs) {
        if (S.allBlank(cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_BLANK, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllBlank(Collection<? extends CharSequence> cs, String msgTemplate, Object ... objs) {
        if (S.allBlank(cs)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllBlank(Collection<? extends CharSequence> cs, String[] paramNames) {
        if (S.allBlank(cs)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_BLANK, paramNames), new Object[0]);
        }
    }

    public static void checkAllEmpty(Collection<?> os) {
        if (G.allEmpty(os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_EMPTY, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllEmpty(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.allEmpty(os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllEmpty(Collection<?> os, String[] paramNames) {
        if (G.allEmpty(os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_EMPTY, paramNames), new Object[0]);
        }
    }

    public static void checkAllNull(Collection<?> os) {
        if (G.allNull(os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, NULL_STR_ARRAY), new Object[0]);
        }
    }

    public static void checkAllNull(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.allNull(os)) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkAllNull(Collection<?> os, String[] paramNames) {
        if (G.allNull(os)) {
            Preconditions.throwConditionsNotMetException400(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, paramNames), new Object[0]);
        }
    }

    public static void checkCondition(boolean expression) {
        if (expression) {
            Preconditions.throwConditionsNotMetException400("The condition is not met! ", new Object[0]);
        }
    }

    public static void checkCondition(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            Preconditions.throwConditionsNotMetException400(msgTemplate, objs);
        }
    }

    public static void checkCondition(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new ConditionsNotMetException(msgTemplate, objs).setCode(code);
        }
    }

    private static void throwConditionsNotMetException400(String msgTemplate, Object ... objs) {
        throw new ConditionsNotMetException(msgTemplate, objs).setCode("400");
    }

    public static void checkTemporal(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new UnsupportedTemporalTypeException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkArgument(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new IllegalArgumentException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkOutOfBounds(boolean expression, Number number, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new OutOfBoundsException(number, SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkFileNotFound(boolean expression, String msgTemplate, Object ... objs) throws FileNotFoundException {
        if (expression) {
            throw new FileNotFoundException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkGeneralException(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new GeneralException(msgTemplate, objs);
        }
    }

    public static void checkGeneralException(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new GeneralException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkQueryResult(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new IllegalQueryResultException(msgTemplate, objs);
        }
    }

    public static void checkQueryResult(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new IllegalQueryResultException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkCircularReferences(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new CircularReferencesException(msgTemplate, objs);
        }
    }

    public static void checkCircularReferences(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new CircularReferencesException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkRequest(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new RequestFailureException(msgTemplate, objs);
        }
    }

    public static void checkRequest(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new RequestFailureException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkResult(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new UnexpectedResultException(msgTemplate, objs);
        }
    }

    public static void checkResult(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new UnexpectedResultException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkAIError(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIException(msgTemplate, objs);
        }
    }

    public static void checkAIError(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkAICall(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AICallException(msgTemplate, objs);
        }
    }

    public static void checkAICall(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AICallException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkAIRequest(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIRequestException(msgTemplate, objs);
        }
    }

    public static void checkAIRequest(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIRequestException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkAITraining(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AITrainingException(msgTemplate, objs);
        }
    }

    public static void checkAITraining(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AITrainingException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkAIInference(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIInferenceException(msgTemplate, objs);
        }
    }

    public static void checkAIInference(String code, boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new AIInferenceException(msgTemplate, objs).setCode(code);
        }
    }

    public static void checkRuntime(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new RuntimeException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkState(boolean expression) {
        if (expression) {
            throw new IllegalStateException();
        }
    }

    public static void checkState(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new IllegalStateException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkConditionNPE(boolean expression, String msgTemplate, Object ... objs) {
        if (expression) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkNullNPE(Object o) {
        if (o == null) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.NULL, NULL_STR_ARRAY));
        }
    }

    public static void checkNullNPE(Object o, String msgTemplate, Object ... objs) {
        if (o == null) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkNullNPE(Object o, String[] paramNames) {
        if (o == null) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.NULL, paramNames));
        }
    }

    public static void checkHasNullNPE(Object[] os) {
        if (G.hasNull((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, NULL_STR_ARRAY);
            throw new NullPointerException(errorMsg);
        }
    }

    public static void checkHasNullNPE(Object[] os, String msgTemplate, Object ... objs) {
        if (G.hasNull((Object[])os)) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkHasNullNPE(Object[] os, String[] paramNames) {
        if (G.hasNull((Object[])os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, paramNames);
            throw new NullPointerException(errorMsg);
        }
    }

    public static void checkHasNullNPE(Collection<?> os) {
        if (G.hasNull(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, NULL_STR_ARRAY) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, NULL_STR_ARRAY);
            throw new NullPointerException(errorMsg);
        }
    }

    public static void checkHasNullNPE(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.hasNull(os)) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkHasNullNPE(Collection<?> os, String[] paramNames) {
        if (G.hasNull(os)) {
            String errorMsg = Preconditions.getErrorMsg(ErrorMsgType.HAS_NULL, paramNames) + Preconditions.getErrorParamsString(ErrorMsgType.HAS_NULL, os, paramNames);
            throw new NullPointerException(errorMsg);
        }
    }

    public static void checkAllNullNPE(Object[] os) {
        if (G.allNull((Object[])os)) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, NULL_STR_ARRAY));
        }
    }

    public static void checkAllNullNPE(Object[] os, String msgTemplate, Object ... objs) {
        if (G.allNull((Object[])os)) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkAllNullNPE(Object[] os, String[] paramNames) {
        if (G.allNull((Object[])os)) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, paramNames));
        }
    }

    public static void checkAllNullNPE(Collection<?> os) {
        if (G.allNull(os)) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, NULL_STR_ARRAY));
        }
    }

    public static void checkAllNullNPE(Collection<?> os, String msgTemplate, Object ... objs) {
        if (G.allNull(os)) {
            throw new NullPointerException(SI.$((CharSequence)msgTemplate, (Object[])objs));
        }
    }

    public static void checkAllNullNPE(Collection<?> os, String[] paramNames) {
        if (G.allNull(os)) {
            throw new NullPointerException(Preconditions.getErrorMsg(ErrorMsgType.ALL_NULL, paramNames));
        }
    }

    public static String getErrorMsg(ErrorMsgType type, String ... paramNames) {
        if (type == null) {
            type = ErrorMsgType.NULL;
        }
        int length = G.isEmpty((Object)paramNames) ? 0 : paramNames.length;
        boolean paramNameEmpty = length == 0 || length == 1 && S.isBlank((CharSequence)paramNames[0]);
        int SPACE = 32;
        String paramNamesStr = paramNameEmpty ? "" : (length == 1 ? "`" + paramNames[0] + "`" : Arrays.asList(paramNames).toString()) + ' ';
        String mustBe = type.mustBe;
        String errorReason = type.errorReason;
        String errorMsg = (paramNameEmpty ? "This parameter " : (length == 1 ? "The parameter " : "All parameters ")) + paramNamesStr + "must be " + mustBe + "! ";
        String length1Msg = "The parameter " + paramNamesStr + "must be " + mustBe + "! ";
        switch (type) {
            case NULL: 
            case NOT_NULL: 
            case EMPTY: 
            case NOT_EMPTY: 
            case BLANK: 
            case NOT_BLANK: {
                break;
            }
            case HAS_BLANK: 
            case HAS_EMPTY: 
            case HAS_NULL: {
                errorMsg = paramNameEmpty ? "None of the parameters " + paramNamesStr + "can be " + errorReason + "! " : (length == 1 ? length1Msg : "None of these parameters " + paramNamesStr + "can be " + errorReason + "! ");
                break;
            }
            case ALL_BLANK: 
            case ALL_EMPTY: 
            case ALL_NULL: {
                errorMsg = paramNameEmpty ? "At least one parameter " + paramNamesStr + "can't be " + errorReason + "! " : (length == 1 ? length1Msg : "At least one of these parameters " + paramNamesStr + "can't be " + errorReason + "! ");
            }
        }
        return errorMsg;
    }

    public static List<Object> listErrorParams(ErrorMsgType type, Collection<?> os, String ... paramNames) {
        if (type == null) {
            type = ErrorMsgType.HAS_NULL;
        }
        ArrayList<Object> params = new ArrayList<Object>();
        if (G.isEmpty(os)) {
            return params;
        }
        int i = 0;
        if (G.isEmpty((Object)paramNames) || os.size() != paramNames.length) {
            for (Object o : os) {
                switch (type) {
                    case HAS_NULL: {
                        if (o != null) break;
                        params.add(i);
                        break;
                    }
                    case HAS_EMPTY: {
                        if (!G.isEmpty(o)) break;
                        params.add(i);
                        break;
                    }
                    case HAS_BLANK: {
                        CharSequence s = null;
                        try {
                            s = (CharSequence)o;
                        }
                        catch (Exception e) {
                            throw new ClassCastException("The `ErrorMsgType.HAS_BLANK` can only be used to validate a `Collection<? extends CharSequence>`. ");
                        }
                        if (!S.isBlank((CharSequence)s)) break;
                        params.add(i);
                    }
                }
                ++i;
            }
        } else {
            for (Object o : os) {
                String paramName = paramNames[i];
                switch (type) {
                    case HAS_NULL: {
                        if (o != null) break;
                        params.add(paramName);
                        break;
                    }
                    case HAS_EMPTY: {
                        if (!G.isEmpty(o)) break;
                        params.add(paramName);
                        break;
                    }
                    case HAS_BLANK: {
                        CharSequence s = null;
                        try {
                            s = (CharSequence)o;
                        }
                        catch (Exception e) {
                            throw new ClassCastException("The `ErrorMsgType.HAS_BLANK` can only be used to validate a `Collection<? extends CharSequence>`. ");
                        }
                        if (!S.isBlank((CharSequence)s)) break;
                        params.add(paramName);
                    }
                }
                ++i;
            }
        }
        return params;
    }

    public static String getErrorParamsString(ErrorMsgType type, Collection<?> os, String ... paramNames) {
        if (os == null) {
            return "";
        }
        List<Object> objs = Preconditions.listErrorParams(type, os, paramNames);
        if (G.isEmpty(objs)) {
            return "";
        }
        Object o = objs.get(0);
        if (o instanceof Integer) {
            if (objs.size() == 1) {
                return SI.$((CharSequence)"But parameter with index ${?} is ${?}! ", (Object[])new Object[]{objs, type.errorReason});
            }
            return SI.$((CharSequence)"But parameters with index ${?} are ${?}! ", (Object[])new Object[]{objs, type.errorReason});
        }
        if (objs.size() == 1) {
            return SI.$((CharSequence)"But parameter ${?} is ${?}! ", (Object[])new Object[]{objs, type.errorReason});
        }
        return SI.$((CharSequence)"But parameters ${?} are ${?}! ", (Object[])new Object[]{objs, type.errorReason});
    }

    public static String getErrorParamsString(ErrorMsgType type, Object[] os, String ... paramNames) {
        if (os == null) {
            return "";
        }
        return Preconditions.getErrorParamsString(type, Arrays.asList(os), paramNames);
    }
}

