/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.nio;

import com.iofairy.top.G;
import com.iofairy.validator.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MemoryHugeBytesChannel
implements SeekableByteChannel {
    private static final int BUFFER_INITIALIZED_SIZE = 8192;
    private static final int PER_BUFFER_MAX_SIZE = 0x7FFFFBFF;
    private final List<byte[]> datas = new ArrayList<byte[]>();
    private boolean isOpen = true;
    private long position = 0L;
    private long size = 0L;
    private long capacity = 0L;

    public MemoryHugeBytesChannel(byte[] ... datas) {
        if (!G.isEmpty((Object)datas)) {
            for (byte[] buf : datas) {
                if (G.isEmpty((Object)buf)) continue;
                this.datas.add(buf);
                this.size += (long)buf.length;
            }
        }
        this.capacity = this.size;
    }

    public MemoryHugeBytesChannel() {
        this.addData(MemoryHugeBytesChannel.initializeBytes());
    }

    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        Indexes indexes;
        this.ensureOpen();
        int bytesNeedRead = dst.remaining();
        long availableLength = this.size - this.position;
        if (availableLength <= 0L) {
            return -1;
        }
        if ((long)bytesNeedRead > availableLength) {
            bytesNeedRead = (int)availableLength;
        }
        if ((indexes = this.getIndexesByPosition(this.datas, this.position, this.size)) == null) {
            return -1;
        }
        int indexOfList = indexes.indexOfList;
        int offset = indexes.indexOfArrayInList;
        byte[] currentData = this.datas.get(indexOfList);
        int currentRemainLength = currentData.length - offset;
        dst.put(currentData, offset, Math.min(bytesNeedRead, currentRemainLength));
        for (int newBytesNeedRead = bytesNeedRead - currentRemainLength; newBytesNeedRead > 0; newBytesNeedRead -= currentData.length) {
            currentData = this.datas.get(++indexOfList);
            dst.put(currentData, 0, Math.min(newBytesNeedRead, currentData.length));
        }
        this.position += (long)bytesNeedRead;
        return bytesNeedRead;
    }

    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        int bytesNeedWrite;
        this.ensureOpen();
        if (G.isEmpty(this.datas)) {
            this.addData(MemoryHugeBytesChannel.initializeBytes());
        }
        if ((bytesNeedWrite = src.remaining()) == 0) {
            return 0;
        }
        long availableLength = this.capacity - this.position;
        if ((long)bytesNeedWrite > availableLength) {
            this.reCapacity(bytesNeedWrite);
        }
        Indexes indexes = this.getIndexesByPosition(this.datas, this.position, this.capacity);
        int indexOfList = indexes.indexOfList;
        int indexOfArray = indexes.indexOfArrayInList;
        byte[] bytes = this.datas.get(indexOfList);
        int currentLength = bytes.length - indexOfArray;
        src.get(bytes, indexOfArray, Math.min(currentLength, bytesNeedWrite));
        int newBytesNeedWrite = bytesNeedWrite - currentLength;
        while (newBytesNeedWrite > 0) {
            if (G.isEmpty((Object)(bytes = this.datas.get(++indexOfList)))) continue;
            src.get(bytes, 0, Math.min(bytes.length, newBytesNeedWrite));
            newBytesNeedWrite -= bytes.length;
        }
        this.position += (long)bytesNeedWrite;
        if (this.size < this.position) {
            this.size = this.position;
        }
        return bytesNeedWrite;
    }

    private void reCapacity(int bytesNeedWrite) {
        byte[] lastBytes = this.removeData(this.datas.size() - 1);
        while (this.capacity + (long)lastBytes.length - this.position < (long)bytesNeedWrite) {
            if (lastBytes.length == 0) {
                lastBytes = MemoryHugeBytesChannel.initializeBytes();
                continue;
            }
            int length = lastBytes.length << 1;
            if (length > 0x7FFFFBFF || length < 0) {
                this.addData(lastBytes);
                lastBytes = MemoryHugeBytesChannel.initializeBytes();
                continue;
            }
            lastBytes = Arrays.copyOf(lastBytes, length);
        }
        this.addData(lastBytes);
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public synchronized SeekableByteChannel position(long newPosition) throws IOException {
        this.ensureOpen();
        Preconditions.checkArgument((newPosition < 0L ? 1 : 0) != 0, (String)"`newPosition` cannot be negative.", (Object[])new Object[0]);
        this.position = newPosition;
        return this;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public synchronized SeekableByteChannel truncate(long newSize) throws IOException {
        this.ensureOpen();
        Preconditions.checkArgument((newSize < 0L ? 1 : 0) != 0, (String)"`newSize` cannot be negative.", (Object[])new Object[0]);
        if (newSize >= this.size) {
            if (this.position > newSize) {
                this.position = (int)newSize;
            }
            return this;
        }
        if (newSize == 0L) {
            this.clearDatas();
            this.addData(MemoryHugeBytesChannel.initializeBytes());
            this.size = 0L;
            this.position = 0L;
            return this;
        }
        this.datas.removeIf(b -> b == null || ((byte[])b).length == 0);
        long preSumSize = 0L;
        int index = 0;
        int remainLength = 0;
        int i = 0;
        while (i < this.datas.size()) {
            long currentLength = preSumSize + (long)this.datas.get(i).length;
            index = i++;
            if (currentLength == newSize) break;
            if (currentLength > newSize) {
                remainLength = (int)(newSize - preSumSize);
                break;
            }
            preSumSize = currentLength;
        }
        int finalIndex = index;
        this.datas.removeIf(b -> this.datas.indexOf(b) > finalIndex);
        if (remainLength > 0) {
            byte[] data = this.datas.remove(finalIndex);
            this.datas.add(Arrays.copyOf(data, remainLength));
        }
        this.capacity = newSize;
        this.size = newSize;
        this.position = newSize;
        return this;
    }

    private void clearDatas() {
        this.datas.clear();
        this.capacity = 0L;
    }

    private byte[] removeData(int index) {
        byte[] bytes = this.datas.remove(index);
        this.capacity -= (long)bytes.length;
        return bytes;
    }

    private void addData(byte[] bytes) {
        this.datas.add(bytes);
        this.capacity += (long)bytes.length;
    }

    public byte[][] toByteArrays() {
        return MemoryHugeBytesChannel.toByteArrays(this.datas, this.size);
    }

    private static byte[][] toByteArrays(List<byte[]> datas, long size) {
        if (G.isEmpty(datas) || size <= 0L) {
            return new byte[0][];
        }
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        long preSumSize = 0L;
        for (byte[] data : datas) {
            if (data == null) continue;
            long currentLength = (long)data.length + preSumSize;
            if (currentLength < size) {
                bytes.add(data);
                preSumSize += (long)data.length;
                continue;
            }
            if (currentLength == size) {
                bytes.add(data);
                break;
            }
            bytes.add(Arrays.copyOf(data, (int)(size - preSumSize)));
            break;
        }
        byte[][] bs = new byte[bytes.size()][];
        for (int i = 0; i < bytes.size(); ++i) {
            bs[i] = (byte[])bytes.get(i);
        }
        return bs;
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    @Override
    public void close() throws IOException {
        this.isOpen = false;
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }

    private static byte[] initializeBytes() {
        return new byte[8192];
    }

    private Indexes getIndexesByPosition(List<byte[]> datas, long globalPosition, long size) {
        if (G.isEmpty(datas) || globalPosition >= size) {
            return null;
        }
        int indexOfList = 0;
        long preSumSize = 0L;
        for (byte[] data : datas) {
            if (preSumSize + (long)data.length > globalPosition) break;
            ++indexOfList;
            preSumSize += (long)data.length;
        }
        int indexOfArrayInList = (int)(globalPosition - preSumSize);
        return Indexes.of(indexOfList, indexOfArrayInList);
    }

    static class Indexes {
        int indexOfList;
        int indexOfArrayInList;

        public Indexes(int indexOfList, int indexOfArrayInList) {
            this.indexOfList = indexOfList;
            this.indexOfArrayInList = indexOfArrayInList;
        }

        public static Indexes of(int indexOfList, int indexOfArrayInList) {
            return new Indexes(indexOfList, indexOfArrayInList);
        }

        public String toString() {
            return "{indexOfList: " + this.indexOfList + ", indexOfArrayInList: " + this.indexOfArrayInList + '}';
        }
    }
}

