/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.node;

import com.iofairy.annos.Beta;
import com.iofairy.falcon.node.Hierarchy;
import com.iofairy.falcon.node.TenantTree;
import com.iofairy.falcon.stream.CollectorKit;
import com.iofairy.top.G;
import com.iofairy.validator.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Beta
public class HierarchyBuilder<T extends Hierarchy<T, E>, E> {
    private final List<T> nodes;

    private HierarchyBuilder(List<T> nodes) {
        this.nodes = G.isEmpty(nodes) ? new ArrayList() : nodes;
    }

    public static <T extends Hierarchy<T, E>, E> HierarchyBuilder<T, E> of(List<T> nodes) {
        return new HierarchyBuilder<T, E>(nodes);
    }

    public static <T extends Hierarchy<T, E>, E> HierarchyBuilder<T, E> on(List<T> nodes) {
        return new HierarchyBuilder<T, E>(nodes);
    }

    public List<T> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public List<T> buildTree(List<E> topParents, boolean fillDepth, boolean fillAncestors, boolean fillOrder, Comparator<? super T> c) {
        if (G.isEmpty(this.nodes)) {
            return new ArrayList();
        }
        Preconditions.checkArgument((boolean)G.isEmpty(topParents), (String)"\u53c2\u6570`topParents`\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        return this.createTree(this.nodes, topParents, fillDepth, fillAncestors, fillOrder, c);
    }

    public List<T> buildTree(List<E> topParents, boolean fillDepth, boolean fillOrder, Comparator<? super T> c) {
        return this.buildTree(topParents, fillDepth, false, fillOrder, c);
    }

    public List<T> buildTree(List<E> topParents, boolean fillDepth) {
        return this.buildTree(topParents, fillDepth, false, false, null);
    }

    public List<T> buildTree(List<E> topParents) {
        return this.buildTree(topParents, false, false, false, null);
    }

    public List<TenantTree<T>> buildTenantTree(List<E> topParents, boolean fillDepth, boolean fillAncestors, boolean fillOrder, Comparator<? super T> c) {
        if (G.isEmpty(this.nodes)) {
            return new ArrayList<TenantTree<T>>();
        }
        Preconditions.checkArgument((boolean)G.isEmpty(topParents), (String)"\u53c2\u6570`topParents`\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Map<String, List<Hierarchy>> tenantMap = this.nodes.parallelStream().collect(CollectorKit.groupingByAllowNullKey(h -> h.tenantId));
        ArrayList<TenantTree<T>> tenantList = new ArrayList<TenantTree<T>>();
        tenantMap.forEach((k, vs) -> {
            List<T> parentList = this.createTree((List<T>)vs, topParents, fillDepth, fillAncestors, fillOrder, c);
            tenantList.add(new TenantTree<T>((String)k, parentList));
        });
        return tenantList;
    }

    public List<TenantTree<T>> buildTenantTree(List<E> topParents, boolean fillDepth, boolean fillOrder, Comparator<? super T> c) {
        return this.buildTenantTree(topParents, fillDepth, false, fillOrder, c);
    }

    public List<TenantTree<T>> buildTenantTree(List<E> topParents, boolean fillDepth) {
        return this.buildTenantTree(topParents, fillDepth, false, false, null);
    }

    public List<TenantTree<T>> buildTenantTree(List<E> topParents) {
        return this.buildTenantTree(topParents, false, false, false, null);
    }

    private List<T> createTree(List<T> nodeList, List<E> topParents, boolean fillDepth, boolean fillAncestors, boolean fillOrder, Comparator<? super T> c) {
        Map<Object, List<Hierarchy>> parentMap = nodeList.parallelStream().collect(CollectorKit.groupingByAllowNullKey(h -> h.parentId));
        parentMap.forEach((k, vs) -> {
            if (c != null) {
                vs.sort(c);
            }
            if (fillOrder) {
                for (int i = 0; i < vs.size(); ++i) {
                    ((Hierarchy)vs.get((int)i)).order = i;
                }
            }
        });
        nodeList.forEach(node -> {
            node.children = (List)parentMap.get(node.nodeId);
        });
        List parentList = nodeList.stream().filter(node -> topParents.contains(node.parentId)).collect(Collectors.toList());
        if (c != null) {
            parentList.sort(c);
        }
        if (fillOrder) {
            for (int i = 0; i < parentList.size(); ++i) {
                ((Hierarchy)parentList.get((int)i)).order = i;
            }
        }
        if (fillDepth) {
            this.fillDepth(parentList, 0);
        }
        if (fillAncestors) {
            this.fillAncestors(parentList, new ArrayList());
        }
        return parentList;
    }

    private void fillAncestors(List<T> list, List<E> ancestorsList) {
        for (Hierarchy t : list) {
            ArrayList ancestors = new ArrayList(ancestorsList);
            ancestors.add(t.parentId);
            t.setAncestors(ancestors);
            if (G.isEmpty(t.children)) continue;
            this.fillAncestors(t.children, t.ancestors);
        }
    }

    private void fillDepth(List<T> list, int depth) {
        for (Hierarchy t : list) {
            t.depth = depth;
            if (G.isEmpty(t.children)) continue;
            this.fillDepth(t.children, depth + 1);
        }
    }
}

