/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.reflect;

import com.iofairy.os.JavaVersion;
import com.iofairy.os.OS;
import com.iofairy.top.G;
import com.iofairy.top.S;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ClassExt {
    public final String name;
    public final String simpleName;
    public final String simpleNameWithEnclosing;
    public final String typeName;
    public final String canonicalName;
    public final Package pkg;
    public final String importClause;
    public final String importStaticClause;
    public final List<Class<?>> enclosingClasses;
    public final int modifiers;
    public final boolean isClass;
    public final boolean isMemberClass;
    public final boolean isLocalClass;
    public final boolean isAnonymousClass;
    public final boolean isSynthetic;
    public final boolean isHidden;
    public final boolean isRecord;
    public final boolean isSealed;

    private ClassExt(String name, String simpleName, String simpleNameWithEnclosing, String typeName, String canonicalName, Package pkg, String importClause, String importStaticClause, List<Class<?>> enclosingClasses, int modifiers, boolean isClass, boolean isMemberClass, boolean isLocalClass, boolean isAnonymousClass, boolean isSynthetic, boolean isHidden, boolean isRecord, boolean isSealed) {
        this.name = name;
        this.simpleName = simpleName;
        this.simpleNameWithEnclosing = simpleNameWithEnclosing;
        this.typeName = typeName;
        this.canonicalName = canonicalName;
        this.pkg = pkg;
        this.importClause = importClause;
        this.importStaticClause = importStaticClause;
        this.enclosingClasses = enclosingClasses;
        this.modifiers = modifiers;
        this.isClass = isClass;
        this.isMemberClass = isMemberClass;
        this.isLocalClass = isLocalClass;
        this.isAnonymousClass = isAnonymousClass;
        this.isSynthetic = isSynthetic;
        this.isHidden = isHidden;
        this.isRecord = isRecord;
        this.isSealed = isSealed;
    }

    public static ClassExt of(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String simpleName = clazz.getSimpleName();
        Class<?> enclosingClass = clazz;
        ArrayList enclosingClasses = new ArrayList();
        while ((enclosingClass = enclosingClass.getEnclosingClass()) != null) {
            enclosingClasses.add(enclosingClass);
        }
        Collections.reverse(enclosingClasses);
        String simpleNameWithEnclosing = G.isEmpty(enclosingClasses) ? simpleName : enclosingClasses.stream().map(Class::getSimpleName).collect(Collectors.joining(".")) + "." + simpleName;
        String canonicalName = clazz.getCanonicalName();
        String importClause = S.isEmpty((CharSequence)canonicalName) ? "" : "import " + canonicalName + ";";
        String importStaticClause = S.isEmpty((CharSequence)canonicalName) ? "" : "import static " + canonicalName + ".*;";
        boolean isClass = !clazz.isEnum() && !clazz.isInterface() && !clazz.isArray() && !clazz.isAnnotation() && !clazz.isPrimitive();
        boolean isHidden = false;
        boolean isRecord = false;
        boolean isSealed = false;
        if (OS.J_VERSION != null && OS.J_VERSION.gte(JavaVersion.JAVA_15)) {
            Class<?> clazzClass = clazz.getClass();
            isHidden = ClassExt.callMethod(clazz, clazzClass, "isHidden");
            if (OS.J_VERSION.gte(JavaVersion.JAVA_16)) {
                isRecord = ClassExt.callMethod(clazz, clazzClass, "isRecord");
                boolean bl = isClass = isClass && !isRecord;
            }
            if (OS.J_VERSION.gte(JavaVersion.JAVA_17)) {
                isSealed = ClassExt.callMethod(clazz, clazzClass, "isSealed");
            }
        }
        return new ClassExt(clazz.getName(), simpleName, simpleNameWithEnclosing, clazz.getTypeName(), canonicalName, clazz.getPackage(), importClause, importStaticClause, enclosingClasses, clazz.getModifiers(), isClass, clazz.isMemberClass(), clazz.isLocalClass(), clazz.isAnonymousClass(), clazz.isSynthetic(), isHidden, isRecord, isSealed);
    }

    private static boolean callMethod(Class<?> clazz, Class<? extends Class> clazzClass, String methodName) {
        boolean isTrue = false;
        try {
            Method method = clazzClass.getMethod(methodName, new Class[0]);
            isTrue = (Boolean)method.invoke(clazz, new Object[0]);
        }
        catch (Exception e) {
            String string = G.stackTrace((Throwable)e);
        }
        return isTrue;
    }

    public String toString() {
        return "ClassExt{name='" + this.name + '\'' + ", simpleName='" + this.simpleName + '\'' + ", simpleNameWithEnclosing='" + this.simpleNameWithEnclosing + '\'' + ", typeName='" + this.typeName + '\'' + ", canonicalName='" + this.canonicalName + '\'' + ", pkg=" + this.pkg + ", importClause='" + this.importClause + '\'' + ", importStaticClause='" + this.importStaticClause + '\'' + ", enclosingClasses=" + this.enclosingClasses + ", modifiers=" + this.modifiers + ", isClass=" + this.isClass + ", isMemberClass=" + this.isMemberClass + ", isLocalClass=" + this.isLocalClass + ", isAnonymousClass=" + this.isAnonymousClass + ", isSynthetic=" + this.isSynthetic + ", isHidden=" + this.isHidden + ", isRecord=" + this.isRecord + ", isSealed=" + this.isSealed + '}';
    }
}

