/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.string;

import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;

public class Strings {
    public static String toString(byte[][] byteArrays, Charset charset) {
        StringBuilder sb = new StringBuilder();
        for (byte[] bytes : byteArrays) {
            sb.append(new String(bytes, charset));
        }
        return sb.toString();
    }

    public static String toString(byte[][] byteArrays) {
        return Strings.toString(byteArrays, StandardCharsets.UTF_8);
    }

    public static String convertTime(long millis) {
        if (millis < 0L) {
            return "-" + Strings.convertTime(Math.abs(millis));
        }
        if (millis < 1000L) {
            return millis + "\u6beb\u79d2";
        }
        DecimalFormat df = new DecimalFormat("0.0");
        df.setRoundingMode(RoundingMode.HALF_UP);
        if (millis < 60000L) {
            return df.format((double)millis / 1000.0) + "\u79d2";
        }
        if (millis < 3600000L) {
            return df.format((double)millis / 60000.0) + "\u5206";
        }
        if (millis < 86400000L) {
            return df.format((double)millis / 3600000.0) + "\u65f6";
        }
        return df.format((double)millis / 8.64E7) + "\u5929";
    }

    @Deprecated
    public static String repeat(String str, int repeatTimes) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0 || repeatTimes <= 0) {
            return "";
        }
        if (repeatTimes == 1) {
            return str;
        }
        if (repeatTimes > 0x7FFFFFF7) {
            throw new IllegalArgumentException("Parameter `repeatTimes` must be <= (Integer.MAX_VALUE - 8), otherwise, the memory will overflow! ");
        }
        return new String(new char[repeatTimes]).replace("\u0000", str);
    }
}

