/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.time.ChronoInterval;
import com.iofairy.falcon.time.DateTimePattern;
import com.iofairy.falcon.time.DateTimeRound;
import com.iofairy.falcon.time.DateTimeShift;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.falcon.time.RoundingDT;
import com.iofairy.falcon.time.TZ;
import com.iofairy.falcon.time.WeekInfo;
import com.iofairy.os.JavaVersion;
import com.iofairy.os.OS;
import com.iofairy.range.IntervalType;
import com.iofairy.range.Range;
import com.iofairy.si.SI;
import com.iofairy.top.G;
import com.iofairy.top.S;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import com.iofairy.validator.Preconditions;
import java.io.Serializable;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAdjuster;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalField;
import java.time.temporal.TemporalUnit;
import java.time.temporal.WeekFields;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;

@Deprecated
public class DateTime<T>
implements Temporal,
Comparable<DateTime<?>>,
Serializable {
    private static final long serialVersionUID = 6206615563566L;
    private final T dateTime;
    private final LocalDateTime localDateTime;
    private final ZoneOffset offset;
    private final ZoneId zone;
    private final Instant instant;
    private final ZonedDateTime zonedDateTime;
    private final OffsetDateTime offsetDateTime;
    private static final List<Class<?>> SUPPORTED_DATETIME = Arrays.asList(Date.class, Calendar.class, LocalDateTime.class, ZonedDateTime.class, OffsetDateTime.class, Instant.class);
    private static final String SUPPORTED_DATETIME_STRING = SUPPORTED_DATETIME.stream().map(c -> c == Date.class ? c.getName() : c.getSimpleName()).collect(Collectors.joining(", "));
    private static final List<String> EXCLUDED_CLASS_NAMES = Arrays.asList("java.sql.Date", "java.sql.Time");
    private static final String DT_PARSE_ERROR_MSG_TPL = "Text '${text}' could not be parsed, you can specify the DateTime `formatter` manually by calling ${method}. ";

    public DateTime(T dateTime) {
        this(dateTime, true);
    }

    private DateTime(T dateTime, boolean checkValue) {
        if (checkValue) {
            Preconditions.checkNullNPE(dateTime, (String[])Preconditions.args((String[])new String[]{"dateTime"}));
            Preconditions.checkTemporal((boolean)(dateTime instanceof LocalDate), (String)"The `dateTime` is of type `LocalDate`, please call the `DateTime.of(LocalDate)` function! ", (Object[])new Object[0]);
            Preconditions.checkTemporal((boolean)SUPPORTED_DATETIME.stream().noneMatch(c -> c.isAssignableFrom(dateTime.getClass())), (String)"Only [${\u2026}] is supported for `dateTime` parameter! ", (Object[])new Object[]{SUPPORTED_DATETIME_STRING});
            Preconditions.checkTemporal((boolean)EXCLUDED_CLASS_NAMES.contains(dateTime.getClass().getName()), (String)"${\u2026} are unsupported here, you can convert it to the `java.util.Date` first! ", (Object[])new Object[]{EXCLUDED_CLASS_NAMES});
        }
        this.dateTime = this.getDateTime(dateTime);
        Tuple2<Instant, ZonedDateTime> zdtAndInstant = this.toZDTAndInstant();
        this.instant = (Instant)zdtAndInstant._1;
        this.zonedDateTime = (ZonedDateTime)zdtAndInstant._2;
        this.offset = this.zonedDateTime.getOffset();
        this.zone = this.zonedDateTime.getZone();
        if (this.dateTime instanceof OffsetDateTime) {
            this.offsetDateTime = (OffsetDateTime)this.dateTime;
            this.localDateTime = this.offsetDateTime.toLocalDateTime();
        } else {
            this.offsetDateTime = this.zonedDateTime.toOffsetDateTime();
            this.localDateTime = this.dateTime instanceof LocalDateTime ? (LocalDateTime)this.dateTime : this.zonedDateTime.toLocalDateTime();
        }
    }

    public static <T> DateTime<T> of(T dateTime) {
        return new DateTime<T>(dateTime, true);
    }

    public static DateTime<LocalDateTime> of(LocalDate localDate) {
        Preconditions.checkNullNPE((Object)localDate, (String[])Preconditions.args((String[])new String[]{"localDate"}));
        return DateTime.from(localDate.atStartOfDay());
    }

    public static DateTime<Date> of(long epochMillis) {
        return DateTime.from(new Date(epochMillis));
    }

    public static DateTime<Date> ofEpochSecond(long epochSeconds) {
        return DateTime.of(epochSeconds * 1000L);
    }

    public static DateTime<Date> of(String dateStr) {
        return DateTime.parseDate(dateStr);
    }

    public static DateTime<ZonedDateTime> of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nanoOfSecond, ZoneId zone) {
        return DateTime.from(ZonedDateTime.of(year, month, dayOfMonth, hour, minute, second, nanoOfSecond, zone == null ? TZ.DEFAULT_ZONE : zone));
    }

    public static DateTime<ZonedDateTime> of(int year, int month, int dayOfMonth, int hour, int minute, int second, ZoneId zone) {
        return DateTime.of(year, month, dayOfMonth, hour, minute, second, 0, zone);
    }

    public static DateTime<ZonedDateTime> of(int year, int month, int dayOfMonth, int hour, int minute, ZoneId zone) {
        return DateTime.of(year, month, dayOfMonth, hour, minute, 0, 0, zone);
    }

    public static DateTime<ZonedDateTime> of(int year, int month, int dayOfMonth, ZoneId zone) {
        return DateTime.of(year, month, dayOfMonth, 0, 0, 0, 0, zone);
    }

    static <T> DateTime<T> from(T dateTime) {
        return new DateTime<T>(dateTime, false);
    }

    private T getDateTime(T dt) {
        if (dt instanceof Date) {
            return (T)DateTimes.clone((Date)dt);
        }
        if (dt instanceof Calendar) {
            return (T)DateTimes.clone((Calendar)dt);
        }
        return dt;
    }

    public T get() {
        return this.getDateTime(this.dateTime);
    }

    public static DateTime<LocalDateTime> now() {
        return DateTime.from(LocalDateTime.now());
    }

    public static DateTime<Date> nowDate() {
        return DateTime.from(new Date());
    }

    public static DateTime<ZonedDateTime> nowZDT() {
        return DateTime.from(ZonedDateTime.now());
    }

    public static DateTime<ZonedDateTime> nowZDT(ZoneId zoneId) {
        ZonedDateTime now = ZonedDateTime.now();
        if (zoneId != null) {
            now = now.withZoneSameInstant(zoneId);
        }
        return DateTime.from(now);
    }

    public static DateTime<Instant> nowInstant() {
        return DateTime.from(Instant.now());
    }

    public LocalDateTime getLocalDateTime() {
        return this.localDateTime;
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public ZoneId getZone() {
        return this.zone;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public OffsetDateTime getOffsetDateTime() {
        return this.offsetDateTime;
    }

    private Tuple2<Instant, ZonedDateTime> toZDTAndInstant() {
        if (this.dateTime instanceof Calendar) {
            Calendar calendar = (Calendar)this.dateTime;
            Instant ins = calendar.toInstant();
            ZonedDateTime zdt = ins.atZone(calendar.getTimeZone().toZoneId());
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof Date) {
            Instant ins = ((Date)this.dateTime).toInstant();
            ZonedDateTime zdt = ins.atZone(TZ.DEFAULT_ZONE);
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof Instant) {
            Instant ins = (Instant)this.dateTime;
            ZonedDateTime zdt = ZonedDateTime.ofInstant(ins, TZ.DEFAULT_ZONE);
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof LocalDateTime) {
            ZonedDateTime zdt = ((LocalDateTime)this.dateTime).atZone(TZ.DEFAULT_ZONE);
            Instant ins = zdt.toInstant();
            return Tuple.of((Object)ins, (Object)zdt);
        }
        if (this.dateTime instanceof OffsetDateTime) {
            Instant ins = ((OffsetDateTime)this.dateTime).toInstant();
            ZonedDateTime zdt = ((OffsetDateTime)this.dateTime).toZonedDateTime();
            return Tuple.of((Object)ins, (Object)zdt);
        }
        ZonedDateTime zdt = (ZonedDateTime)this.dateTime;
        Instant ins = zdt.toInstant();
        return Tuple.of((Object)ins, (Object)zdt);
    }

    public ZonedDateTime toUTCZonedDT() {
        return this.toZonedDT(TZ.UTC);
    }

    public ZonedDateTime toDefaultZonedDT() {
        return this.toZonedDT(TZ.DEFAULT_ZONE);
    }

    public ZonedDateTime toZonedDT(ZoneId zoneId) {
        if (zoneId == null || this.zone.equals(zoneId)) {
            return this.zonedDateTime;
        }
        return this.zonedDateTime.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime withZoneSameInstant(ZoneId zoneId) {
        return this.zonedDateTime.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime withZoneSameLocal(ZoneId zoneId) {
        return this.zonedDateTime.withZoneSameLocal(zoneId);
    }

    public OffsetDateTime toUTCOffsetDT() {
        return this.toOffsetDT(ZoneOffset.UTC);
    }

    public OffsetDateTime toDefaultOffsetDT() {
        return this.toOffsetDT(DateTimes.defaultOffset());
    }

    public OffsetDateTime toOffsetDT(ZoneOffset zoneOffset) {
        if (zoneOffset == null || this.offset.equals(zoneOffset)) {
            return this.offsetDateTime;
        }
        return this.offsetDateTime.withOffsetSameInstant(zoneOffset);
    }

    public Calendar toUTCCalendar() {
        return this.toCalendar(TZ.UTC);
    }

    public Calendar toDefaultCalendar() {
        return this.toCalendar(TZ.DEFAULT_ZONE);
    }

    public Calendar toCalendar(ZoneId zoneId) {
        if (zoneId == null || this.zone.equals(zoneId)) {
            return this.dateTime instanceof Calendar ? (Calendar)this.get() : DateTimes.toCalendar(this.zonedDateTime);
        }
        if (this.dateTime instanceof Calendar) {
            Calendar calendar = (Calendar)this.get();
            calendar.setTimeZone(TimeZone.getTimeZone(zoneId));
            return calendar;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(zoneId));
        if (this.dateTime instanceof Date) {
            Date date = (Date)this.get();
            calendar.setTime(date);
            return calendar;
        }
        if (this.dateTime instanceof Instant) {
            calendar.setTimeInMillis(this.instant.toEpochMilli());
            return calendar;
        }
        return DateTimes.toCalendar(this.toZonedDT(zoneId));
    }

    Calendar toCalendar(Calendar calendar, ZonedDateTime zonedDateTime) {
        calendar.setTimeZone(TimeZone.getTimeZone(zonedDateTime.getZone()));
        calendar.setTimeInMillis(zonedDateTime.toInstant().toEpochMilli());
        return calendar;
    }

    public LocalDateTime toLocalDateTime() {
        return this.localDateTime;
    }

    public LocalDate toLocalDate() {
        return this.localDateTime.toLocalDate();
    }

    public Date toDate() {
        if (this.dateTime instanceof Date) {
            return (Date)this.get();
        }
        if (this.dateTime instanceof Calendar) {
            return ((Calendar)this.get()).getTime();
        }
        return Date.from(this.instant);
    }

    public Instant toInstant() {
        return this.instant;
    }

    @Override
    public DateTime<T> plus(long amount, TemporalUnit unit) {
        if (amount == 0L) {
            return this;
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = this.zonedDateTime.plus(amount, unit);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        return DateTime.from(((Temporal)this.dateTime).plus(amount, unit));
    }

    @Override
    public DateTime<T> plus(TemporalAmount amountToAdd) {
        if (amountToAdd instanceof ChronoInterval) {
            return ((ChronoInterval)amountToAdd).plusTo(this);
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = (ZonedDateTime)amountToAdd.addTo(this.zonedDateTime);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(amountToAdd.addTo((Temporal)this.dateTime));
    }

    public DateTime<T> plusYears(long years) {
        return this.plus(years, ChronoUnit.YEARS);
    }

    public DateTime<T> plusMonths(long months) {
        return this.plus(months, ChronoUnit.MONTHS);
    }

    public DateTime<T> plusWeeks(long weeks) {
        return this.plus(weeks, ChronoUnit.WEEKS);
    }

    public DateTime<T> plusDays(long days) {
        return this.plus(days, ChronoUnit.DAYS);
    }

    public DateTime<T> plusHours(long hours) {
        return this.plus(hours, ChronoUnit.HOURS);
    }

    public DateTime<T> plusMinutes(long minutes) {
        return this.plus(minutes, ChronoUnit.MINUTES);
    }

    public DateTime<T> plusSeconds(long seconds) {
        return this.plus(seconds, ChronoUnit.SECONDS);
    }

    public DateTime<T> plusMillis(long millis) {
        return this.plus(millis, ChronoUnit.MILLIS);
    }

    public DateTime<T> plusMicros(long micros) {
        return this.plus(micros, ChronoUnit.MICROS);
    }

    public DateTime<T> plusNanos(long nanos) {
        return this.plus(nanos, ChronoUnit.NANOS);
    }

    @Override
    public DateTime<T> minus(long amount, TemporalUnit unit) {
        if (amount == 0L) {
            return this;
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = this.zonedDateTime.minus(amount, unit);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        return DateTime.from(((Temporal)this.dateTime).minus(amount, unit));
    }

    @Override
    public DateTime<T> minus(TemporalAmount amountToSubtract) {
        if (amountToSubtract instanceof ChronoInterval) {
            return ((ChronoInterval)amountToSubtract).minusFrom(this);
        }
        if (this.dateTime instanceof Instant) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(zdt.toInstant());
        }
        if (this.dateTime instanceof Date) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(Date.from(zdt.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            ZonedDateTime zdt = (ZonedDateTime)amountToSubtract.subtractFrom(this.zonedDateTime);
            return DateTime.from(this.toCalendar((Calendar)this.get(), zdt));
        }
        return DateTime.from(amountToSubtract.subtractFrom((Temporal)this.dateTime));
    }

    public DateTime<T> minusYears(long years) {
        return this.minus(years, ChronoUnit.YEARS);
    }

    public DateTime<T> minusMonths(long months) {
        return this.minus(months, ChronoUnit.MONTHS);
    }

    public DateTime<T> minusWeeks(long weeks) {
        return this.minus(weeks, ChronoUnit.WEEKS);
    }

    public DateTime<T> minusDays(long days) {
        return this.minus(days, ChronoUnit.DAYS);
    }

    public DateTime<T> minusHours(long hours) {
        return this.minus(hours, ChronoUnit.HOURS);
    }

    public DateTime<T> minusMinutes(long minutes) {
        return this.minus(minutes, ChronoUnit.MINUTES);
    }

    public DateTime<T> minusSeconds(long seconds) {
        return this.minus(seconds, ChronoUnit.SECONDS);
    }

    public DateTime<T> minusMillis(long millis) {
        return this.minus(millis, ChronoUnit.MILLIS);
    }

    public DateTime<T> minusMicros(long micros) {
        return this.minus(micros, ChronoUnit.MICROS);
    }

    public DateTime<T> minusNanos(long nanos) {
        return this.minus(nanos, ChronoUnit.NANOS);
    }

    @Override
    public DateTime<T> with(TemporalAdjuster adjuster) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            return DateTime.from(((Temporal)this.dateTime).with(adjuster));
        }
        ZonedDateTime zdt = this.zonedDateTime.with(adjuster);
        return this.getDateTimeFromZonedDT(zdt);
    }

    @Override
    public DateTime<T> with(TemporalField field, long newValue) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            return DateTime.from(((Temporal)this.dateTime).with(field, newValue));
        }
        ZonedDateTime zdt = this.zonedDateTime.with(field, newValue);
        return this.getDateTimeFromZonedDT(zdt);
    }

    public DateTime<T> withLocalDateTime(LocalDateTime localDateTime) {
        if (this.dateTime instanceof LocalDateTime) {
            return DateTime.from(localDateTime);
        }
        if (this.dateTime instanceof OffsetDateTime) {
            return DateTime.from(OffsetDateTime.of(localDateTime, this.offset));
        }
        ZonedDateTime zdt = ZonedDateTime.of(localDateTime, this.zone);
        if (this.dateTime instanceof ZonedDateTime) {
            return DateTime.from(zdt);
        }
        return this.getDateTimeFromZonedDT(zdt);
    }

    public DateTime<T> withLocalDate(LocalDate localDate) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            Temporal newTemporal = ((Temporal)this.dateTime).with(ChronoField.YEAR, localDate.getYear()).with(ChronoField.MONTH_OF_YEAR, localDate.getMonthValue()).with(ChronoField.DAY_OF_MONTH, localDate.getDayOfMonth());
            return DateTime.from(newTemporal);
        }
        ZonedDateTime zdt = this.zonedDateTime.withYear(localDate.getYear()).withMonth(localDate.getMonthValue()).withDayOfMonth(localDate.getDayOfMonth());
        return this.getDateTimeFromZonedDT(zdt);
    }

    public DateTime<T> withLocalTime(LocalTime localTime) {
        if (this.dateTime instanceof LocalDateTime || this.dateTime instanceof OffsetDateTime || this.dateTime instanceof ZonedDateTime) {
            Temporal newTemporal = ((Temporal)this.dateTime).with(ChronoField.HOUR_OF_DAY, localTime.getHour()).with(ChronoField.MINUTE_OF_HOUR, localTime.getMinute()).with(ChronoField.SECOND_OF_MINUTE, localTime.getSecond()).with(ChronoField.NANO_OF_SECOND, localTime.getNano());
            return DateTime.from(newTemporal);
        }
        ZonedDateTime zdt = this.zonedDateTime.withHour(localTime.getHour()).withMinute(localTime.getMinute()).withSecond(localTime.getSecond()).withNano(localTime.getNano());
        return this.getDateTimeFromZonedDT(zdt);
    }

    private DateTime<T> getDateTimeFromZonedDT(ZonedDateTime zonedDT) {
        if (this.dateTime instanceof Date) {
            return DateTime.from(Date.from(zonedDT.toInstant()));
        }
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(this.toCalendar((Calendar)this.get(), zonedDT));
        }
        return DateTime.from(zonedDT.toInstant());
    }

    public DateTime<T> withYear(int year) {
        return this.with(ChronoField.YEAR, year);
    }

    public DateTime<T> withMonth(int month) {
        return this.with(ChronoField.MONTH_OF_YEAR, month);
    }

    public DateTime<T> withDayOfYear(int dayOfYear) {
        return this.with(ChronoField.DAY_OF_YEAR, dayOfYear);
    }

    public DateTime<T> withDayOfMonth(int dayOfMonth) {
        return this.with(ChronoField.DAY_OF_MONTH, dayOfMonth);
    }

    public DateTime<T> withHour(int hour) {
        return this.with(ChronoField.HOUR_OF_DAY, hour);
    }

    public DateTime<T> withMinute(int minute) {
        return this.with(ChronoField.MINUTE_OF_HOUR, minute);
    }

    public DateTime<T> withSecond(int second) {
        return this.with(ChronoField.SECOND_OF_MINUTE, second);
    }

    public DateTime<T> withNano(int nanoOfSecond) {
        return this.with(ChronoField.NANO_OF_SECOND, nanoOfSecond);
    }

    @Override
    public int get(TemporalField field) {
        return this.zonedDateTime.get(field);
    }

    public int getYear() {
        return this.localDateTime.getYear();
    }

    public int getMonthValue() {
        return this.localDateTime.getMonthValue();
    }

    public Month getMonth() {
        return this.localDateTime.getMonth();
    }

    public int getDayOfYear() {
        return this.localDateTime.getDayOfYear();
    }

    public int getDayOfMonth() {
        return this.localDateTime.getDayOfMonth();
    }

    public DayOfWeek getDayOfWeek() {
        return this.localDateTime.getDayOfWeek();
    }

    public int getHour() {
        return this.localDateTime.getHour();
    }

    public int getMinute() {
        return this.localDateTime.getMinute();
    }

    public int getSecond() {
        return this.localDateTime.getSecond();
    }

    public int getMillis() {
        return this.localDateTime.get(ChronoField.MILLI_OF_SECOND);
    }

    public int getMicros() {
        return this.localDateTime.get(ChronoField.MICRO_OF_SECOND);
    }

    public int getNano() {
        return this.localDateTime.getNano();
    }

    public DateTime<T> round(ChronoUnit chronoUnit, RoundingDT roundingDT) {
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(DateTimeRound.round((Calendar)this.get(), chronoUnit, roundingDT));
        }
        if (this.dateTime instanceof Date) {
            return DateTime.from(DateTimeRound.round((Date)this.get(), chronoUnit, roundingDT));
        }
        return DateTime.from(DateTimeRound.round((Temporal)this.dateTime, this.localDateTime, this.zone, chronoUnit, roundingDT));
    }

    public DateTime<T> roundTime(ChronoUnit chronoUnit, int amountUnit, RoundingDT roundingDT) {
        if (this.dateTime instanceof Calendar) {
            return DateTime.from(DateTimeRound.roundTime((Calendar)this.get(), chronoUnit, amountUnit, roundingDT));
        }
        if (this.dateTime instanceof Date) {
            return DateTime.from(DateTimeRound.roundTime((Date)this.get(), chronoUnit, amountUnit, roundingDT));
        }
        return DateTime.from(DateTimeRound.roundTime((Temporal)this.dateTime, this.localDateTime, this.zone, chronoUnit, amountUnit, roundingDT));
    }

    public List<T> datesByShift(int shiftTimes, int amountUnit, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        if (chronoUnit == ChronoUnit.WEEKS) {
            chronoUnit = ChronoUnit.DAYS;
            amountUnit *= 7;
        }
        if (this.dateTime instanceof Date) {
            return DateTimeShift.datesByShift((Date)this.get(), this.zonedDateTime, shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
        }
        if (this.dateTime instanceof Calendar) {
            return DateTimeShift.datesByShift((Calendar)this.get(), shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
        }
        return DateTimeShift.datesByShift((Temporal)this.dateTime, shiftTimes, amountUnit, chronoUnit, includeCurrentTime);
    }

    public List<T> datesByShift(int shiftTimes, ChronoUnit chronoUnit, boolean includeCurrentTime) {
        return this.datesByShift(shiftTimes, 1, chronoUnit, includeCurrentTime);
    }

    public List<T> datesByShift(int shiftTimes, ChronoUnit chronoUnit) {
        return this.datesByShift(shiftTimes, 1, chronoUnit, true);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, int amountUnit, ChronoUnit chronoUnit, IntervalType intervalType) {
        Preconditions.checkNullNPE(toDateTime, (String[])Preconditions.args((String[])new String[]{"toDateTime"}));
        if (chronoUnit == ChronoUnit.WEEKS) {
            chronoUnit = ChronoUnit.DAYS;
            amountUnit *= 7;
        }
        if (this.dateTime instanceof Date) {
            return DateTimeShift.datesFromRange((Date)this.get(), toDateTime.toDate(), this.zonedDateTime, toDateTime.zonedDateTime, amountUnit, chronoUnit, intervalType);
        }
        if (this.dateTime instanceof Calendar) {
            return DateTimeShift.datesFromRange((Calendar)this.get(), toDateTime.toCalendar(null), amountUnit, chronoUnit, intervalType);
        }
        if (this.dateTime instanceof OffsetDateTime && toDateTime.dateTime instanceof OffsetDateTime) {
            return DateTimeShift.datesFromRange((Temporal)this.dateTime, (Temporal)toDateTime.dateTime, amountUnit, chronoUnit, intervalType);
        }
        return DateTimeShift.datesFromRange((Temporal)this.dateTime, toDateTime.zonedDateTime, amountUnit, chronoUnit, intervalType);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, ChronoUnit chronoUnit, IntervalType intervalType) {
        return this.datesFromRange(toDateTime, 1, chronoUnit, intervalType);
    }

    public List<T> datesFromRange(DateTime<?> toDateTime, ChronoUnit chronoUnit) {
        return this.datesFromRange(toDateTime, 1, chronoUnit, IntervalType.CLOSED);
    }

    public DateTime<T> fill0(ChronoUnit chronoUnit) {
        return this.round(chronoUnit, RoundingDT.FLOOR);
    }

    public DateTime<T> fill9(ChronoUnit chronoUnit) {
        return ((DateTime)this.round(chronoUnit, RoundingDT.FLOOR).plus(1L, chronoUnit)).minusNanos(1L);
    }

    public DateTime<T> withMin(ChronoUnit chronoUnit) {
        return this.fill0(chronoUnit);
    }

    public DateTime<T> withMax(ChronoUnit chronoUnit) {
        return this.fill9(chronoUnit);
    }

    public int daysOfMonth() {
        return DateTimes.daysOfMonth(this.localDateTime.getYear(), this.localDateTime.getMonthValue());
    }

    public String format(String dtPattern) {
        if (S.isBlank((CharSequence)dtPattern)) {
            dtPattern = "yyyy-MM-dd HH:mm:ss.SSS";
        }
        return this.format(DateTimeFormatter.ofPattern(dtPattern));
    }

    public String format(DateTimeFormatter formatter) {
        return this.zonedDateTime.format(formatter);
    }

    public String formatYMDHMS() {
        return this.format("yyyy-MM-dd HH:mm:ss");
    }

    public static DateTime<LocalDateTime> parse(CharSequence text) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        String dateText = DateTimes.formatZhMillis(text.toString());
        String dateFormat = DateTimePattern.forDTF(dateText);
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "DateTime.parse(CharSequence, String)"}), text, 0);
        }
        return DateTime.parse((CharSequence)dateText, dateFormat);
    }

    public static DateTime<LocalDateTime> parse(CharSequence text, String dtPattern) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parse(text);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        return DateTime.parse(text, DateTimePattern.getDTF(dtPattern));
    }

    public static DateTime<LocalDateTime> parse(CharSequence text, DateTimeFormatter formatter) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        return DateTime.from(LocalDateTime.parse(text, formatter));
    }

    public static DateTime<Date> parseDate(CharSequence text) {
        return DateTime.of(DateTime.parseZDT(text).toDate());
    }

    public static DateTime<Date> parseDate(CharSequence text, ZoneId zoneId) {
        return DateTime.of(DateTime.parseZDT(text, zoneId).toDate());
    }

    public static DateTime<Date> parseDate(CharSequence text, String dtPattern) {
        return DateTime.of(DateTime.parseZDT(text, dtPattern).toDate());
    }

    public static DateTime<Date> parseDate(CharSequence text, String dtPattern, ZoneId zoneId) {
        return DateTime.of(DateTime.parseZDT(text, dtPattern, zoneId).toDate());
    }

    public static DateTime<Date> parseDate(CharSequence text, DateTimeFormatter formatter) {
        return DateTime.of(DateTime.parseZDT(text, formatter).toDate());
    }

    public static DateTime<Date> parseDate(CharSequence text, DateTimeFormatter formatter, ZoneId zoneId) {
        Preconditions.checkNullNPE((Object)formatter, (String[])Preconditions.args((String[])new String[]{"formatter"}));
        if (zoneId != null) {
            formatter = formatter.withZone(zoneId);
        }
        return DateTime.of(DateTime.parseZDT(text, formatter).toDate());
    }

    public static DateTime<ZonedDateTime> parseZDT(CharSequence text) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        String dateText = DateTimes.formatZhMillis(text.toString());
        String dateFormat = DateTimePattern.forDTF(dateText);
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "`parseDate(CharSequence, String)` or `parseZDT(CharSequence, String)`"}), text, 0);
        }
        return DateTime.parseZDT((CharSequence)dateText, dateFormat);
    }

    public static DateTime<ZonedDateTime> parseZDT(CharSequence text, ZoneId zoneId) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        String dateText = DateTimes.formatZhMillis(text.toString());
        String dateFormat = DateTimePattern.forDTF(dateText);
        if (S.isEmpty((CharSequence)dateFormat)) {
            throw new DateTimeParseException(SI.$((CharSequence)DT_PARSE_ERROR_MSG_TPL, (Object[])new Object[]{text, "`parseDate(CharSequence, String, ZoneId)` or `parseZDT(CharSequence, String, ZoneId)`"}), text, 0);
        }
        return DateTime.parseZDT(dateText, dateFormat, zoneId);
    }

    public static DateTime<ZonedDateTime> parseZDT(CharSequence text, String dtPattern) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parseZDT(text);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        return DateTime.parseZDT(text, DateTimePattern.getDTF(dtPattern));
    }

    public static DateTime<ZonedDateTime> parseZDT(CharSequence text, String dtPattern, ZoneId zoneId) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        if (S.isEmpty((CharSequence)dtPattern)) {
            return DateTime.parseZDT(text, zoneId);
        }
        Tuple2<CharSequence, String> text_pattern = DateTime.compatibleFormatter(text, dtPattern);
        text = (CharSequence)text_pattern._1;
        dtPattern = (String)text_pattern._2;
        DateTimeFormatter dtf = DateTimePattern.getDTF(dtPattern);
        if (zoneId != null) {
            dtf = dtf.withZone(zoneId);
        }
        return DateTime.parseZDT(text, dtf);
    }

    public static DateTime<ZonedDateTime> parseZDT(CharSequence text, DateTimeFormatter formatter) {
        Preconditions.checkNullNPE((Object)text, (String[])Preconditions.args((String[])new String[]{"text"}));
        Preconditions.checkNullNPE((Object)formatter, (String[])Preconditions.args((String[])new String[]{"formatter"}));
        ZonedDateTime parse = null;
        try {
            parse = ZonedDateTime.parse(text, formatter);
        }
        catch (Exception e) {
            if (e.getCause() != null && e.getCause().getCause() != null) {
                String message = e.getCause().getCause().getMessage();
                if (message.startsWith("Unable to obtain ZoneId from TemporalAccessor")) {
                    parse = ZonedDateTime.parse(text, formatter.withZone(TZ.DEFAULT_ZONE));
                }
            }
            throw e;
        }
        return DateTime.from(parse);
    }

    private static Tuple2<CharSequence, String> compatibleFormatter(CharSequence text, String dtPattern) {
        if (OS.J_VERSION == null || OS.J_VERSION.lte(JavaVersion.JAVA_8)) {
            String textStr = text.toString();
            if (text.length() == 17 && dtPattern.equals("yyyyMMddHHmmssSSS")) {
                text = textStr.substring(0, 8) + "T" + textStr.substring(8);
                dtPattern = "yyyyMMdd'T'HHmmssSSS";
            } else if (text.length() == 18 && dtPattern.equals("yyyyyMMddHHmmssSSS")) {
                text = textStr.substring(0, 9) + "T" + textStr.substring(9);
                dtPattern = "yyyyyMMdd'T'HHmmssSSS";
            }
        }
        return Tuple.of((Object)text, (Object)dtPattern);
    }

    @Override
    public long until(Temporal endExclusive, TemporalUnit unit) {
        Temporal end;
        Preconditions.checkNullNPE((Object)endExclusive, (String[])Preconditions.args((String[])new String[]{"endExclusive"}));
        boolean isDateTime = endExclusive instanceof DateTime;
        T start = this.dateTime;
        Temporal temporal = end = isDateTime ? ((DateTime)endExclusive).get() : endExclusive;
        if (start instanceof ZonedDateTime && end instanceof ZonedDateTime || start instanceof OffsetDateTime && end instanceof OffsetDateTime || start instanceof LocalDateTime && end instanceof LocalDateTime || start instanceof ZonedDateTime && end instanceof OffsetDateTime) {
            return ((Temporal)start).until(end, unit);
        }
        if (isDateTime) {
            endExclusive = ((DateTime)endExclusive).getZonedDateTime();
        } else if (endExclusive instanceof Instant) {
            endExclusive = ZonedDateTime.ofInstant((Instant)endExclusive, TZ.DEFAULT_ZONE);
        } else if (endExclusive instanceof LocalDateTime) {
            endExclusive = ((LocalDateTime)endExclusive).atZone(TZ.DEFAULT_ZONE);
        }
        return this.zonedDateTime.until(endExclusive, unit);
    }

    @Override
    public boolean isSupported(TemporalUnit unit) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.isSupported(unit);
        }
        return ((Temporal)this.dateTime).isSupported(unit);
    }

    @Override
    public boolean isSupported(TemporalField field) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.isSupported(field);
        }
        return ((Temporal)this.dateTime).isSupported(field);
    }

    @Override
    public long getLong(TemporalField field) {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar || this.dateTime instanceof Instant) {
            return this.zonedDateTime.getLong(field);
        }
        return ((Temporal)this.dateTime).getLong(field);
    }

    public String nameOfMonth() {
        return this.nameOfMonth(TextStyle.FULL, Locale.getDefault());
    }

    public String nameOfMonth(TextStyle textStyle, Locale locale) {
        return this.getMonth().getDisplayName(textStyle, locale);
    }

    public DateTime<T> dtInThisWeek(DayOfWeek dayOfWeek) {
        Preconditions.checkNullNPE((Object)dayOfWeek, (String[])Preconditions.args((String[])new String[]{"dayOfWeek"}));
        return this.dtInThisWeek(DayOfWeek.MONDAY, dayOfWeek);
    }

    public DateTime<T> dtInThisWeek(DayOfWeek firstDayOfWeek, DayOfWeek dayOfWeek) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{firstDayOfWeek, dayOfWeek}), (String[])Preconditions.args((String[])new String[]{"firstDayOfWeek", "dayOfWeek"}));
        Tuple2<Integer, Integer> days1 = DateTimes.daysBetween(firstDayOfWeek, this.localDateTime.getDayOfWeek());
        Tuple2<Integer, Integer> days2 = DateTimes.daysBetween(firstDayOfWeek, dayOfWeek);
        return this.plusDays((Integer)days2._2 - (Integer)days1._2);
    }

    public DateTime<T> firstInThisWeek() {
        return this.firstInThisWeek(DayOfWeek.MONDAY);
    }

    public DateTime<T> firstInThisWeek(DayOfWeek firstDayOfWeek) {
        Preconditions.checkNullNPE((Object)firstDayOfWeek, (String[])Preconditions.args((String[])new String[]{"firstDayOfWeek"}));
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.previousOrSame(firstDayOfWeek);
        return this.with(temporalAdjuster);
    }

    public DateTime<T> lastInThisWeek() {
        return this.lastInThisWeek(DayOfWeek.MONDAY);
    }

    public DateTime<T> lastInThisWeek(DayOfWeek firstDayOfWeek) {
        Preconditions.checkNullNPE((Object)firstDayOfWeek, (String[])Preconditions.args((String[])new String[]{"firstDayOfWeek"}));
        DayOfWeek lastDayOfWeek = DateTimes.getLastDayOfWeek(firstDayOfWeek);
        TemporalAdjuster temporalAdjuster = TemporalAdjusters.nextOrSame(lastDayOfWeek);
        return this.with(temporalAdjuster);
    }

    public WeekInfo getWeekInfo() {
        return WeekInfo.of(this.localDateTime.toLocalDate()).baseYearMonth();
    }

    public WeekInfo getWeekInfo(WeekFields weekFields) {
        return WeekInfo.of(weekFields, this.localDateTime.toLocalDate()).baseYearMonth();
    }

    public String nameOfDayOfWeek() {
        return this.nameOfDayOfWeek(null, null);
    }

    public String nameOfDayOfWeek(Locale locale) {
        return this.nameOfDayOfWeek(null, locale);
    }

    public String nameOfDayOfWeek(TextStyle textStyle) {
        return this.nameOfDayOfWeek(textStyle, null);
    }

    public String nameOfDayOfWeek(TextStyle textStyle, Locale locale) {
        return DateTimes.nameOfDayOfWeek(this.getDayOfWeek(), textStyle, locale);
    }

    public List<DateTime<T>> allDaysInThisWeek() {
        return this.allDaysInThisWeek(DayOfWeek.MONDAY);
    }

    public List<DateTime<T>> allDaysInThisWeek(DayOfWeek firstDayOfWeek) {
        Preconditions.checkNullNPE((Object)firstDayOfWeek, (String[])Preconditions.args((String[])new String[]{"firstDayOfWeek"}));
        DateTime<T> firstDateTime = this.firstInThisWeek(firstDayOfWeek);
        List<T> ts = firstDateTime.datesByShift(6, ChronoUnit.DAYS);
        return ts.stream().map(DateTime::from).collect(Collectors.toList());
    }

    public boolean isBefore(DateTime<?> otherDT) {
        return this.compareTo(otherDT) < 0;
    }

    public boolean isAfter(DateTime<?> otherDT) {
        return this.compareTo(otherDT) > 0;
    }

    public boolean isBeforeOrEquals(DateTime<?> otherDT) {
        return this.compareTo(otherDT) <= 0;
    }

    public boolean isAfterOrEquals(DateTime<?> otherDT) {
        return this.compareTo(otherDT) >= 0;
    }

    public boolean in(DateTime<?> startDT, DateTime<?> endDT, IntervalType intervalType) {
        if (intervalType == null) {
            intervalType = IntervalType.CLOSED;
        }
        return this.in(Range.of(startDT, endDT, (IntervalType)intervalType));
    }

    public boolean in(Range<DateTime<?>> dtRange) {
        return dtRange.contains((Comparable)this);
    }

    public long toEpochSecond() {
        return this.instant.getEpochSecond();
    }

    public long toEpochMilli() {
        return this.instant.toEpochMilli();
    }

    public Class<? extends T> getDTClass() {
        Class<?> dtClass = this.dateTime.getClass();
        return dtClass;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof DateTime) {
            DateTime otherDT = (DateTime)obj;
            int i = this.compareTo(otherDT);
            return i == 0;
        }
        return false;
    }

    @Override
    public int compareTo(DateTime<?> otherDT) {
        Preconditions.checkNullNPE(otherDT, (String[])Preconditions.args((String[])new String[]{"otherDT"}));
        Instant otherInstant = otherDT.toInstant();
        if (this.instant.equals(otherInstant)) {
            return 0;
        }
        return this.instant.isBefore(otherInstant) ? -1 : 1;
    }

    public String dtDetail() {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar) {
            return G.dtDetail((Temporal)this.zonedDateTime);
        }
        return G.dtDetail((Temporal)((Temporal)this.dateTime));
    }

    public String toString() {
        if (this.dateTime instanceof Date || this.dateTime instanceof Calendar) {
            return G.dtSimple((Temporal)this.zonedDateTime);
        }
        return G.dtSimple((Temporal)((Temporal)this.dateTime));
    }

    public int hashCode() {
        return Objects.hashCode(this.zonedDateTime);
    }
}

