/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.SignedInterval;
import com.iofairy.falcon.time.TZ;
import com.iofairy.os.OS;
import com.iofairy.validator.Preconditions;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;

@Deprecated
public class Interval
extends SignedInterval {
    private static final long serialVersionUID = 700005886057265L;
    public static final Interval ZERO = new Interval(0L, 0L, 0L);

    public Interval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        super(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        boolean hasParamsLessThan0 = this.centuries < 0L || this.years < 0L || this.months < 0L || this.days < 0L || this.hours < 0L || this.minutes < 0L || this.seconds < 0L || this.millis < 0L || this.micros < 0L || this.nanos < 0L;
        Preconditions.checkArgument((boolean)hasParamsLessThan0, (String)(OS.IS_ZH_LANG ? "Interval\u6784\u9020\u51fd\u6570\u7684\u6240\u6709\u53c2\u6570\u90fd\u5fc5\u987b \u2265 0! " : "Interval Constructor all parameters must not be negative number! "), (Object[])new Object[0]);
    }

    public Interval(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        this(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes, long seconds) {
        this(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public Interval(long years, long months, long days, long hours, long minutes) {
        this(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public Interval(long months, long days, long hours, long minutes) {
        this(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public Interval(long days, long hours, long minutes) {
        this(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis, long micros, long nanos) {
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    public static Interval of(long centuries, long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes, long seconds, long millis) {
        return new Interval(0L, years, months, days, hours, minutes, seconds, millis, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes, long seconds) {
        return new Interval(0L, years, months, days, hours, minutes, seconds, 0L, 0L, 0L);
    }

    public static Interval of(long years, long months, long days, long hours, long minutes) {
        return new Interval(0L, years, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long months, long days, long hours, long minutes) {
        return new Interval(0L, 0L, months, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long days, long hours, long minutes) {
        return new Interval(0L, 0L, 0L, days, hours, minutes, 0L, 0L, 0L, 0L);
    }

    public static Interval of(long amount, TemporalUnit unit) {
        return ZERO.plus(amount, unit);
    }

    public static Interval ofCenturies(long centuries) {
        return ZERO.plus(centuries, ChronoUnit.CENTURIES);
    }

    public static Interval ofYears(long years) {
        return ZERO.plus(years, ChronoUnit.YEARS);
    }

    public static Interval ofMonths(long months) {
        return ZERO.plus(months, ChronoUnit.MONTHS);
    }

    public static Interval ofDays(long days) {
        return ZERO.plus(days, ChronoUnit.DAYS);
    }

    public static Interval ofHours(long hours) {
        return ZERO.plus(hours, ChronoUnit.HOURS);
    }

    public static Interval ofMinutes(long minutes) {
        return ZERO.plus(minutes, ChronoUnit.MINUTES);
    }

    public static Interval ofSeconds(long seconds) {
        return ZERO.plus(seconds, ChronoUnit.SECONDS);
    }

    public static Interval ofMillis(long millis) {
        return ZERO.plus(millis, ChronoUnit.MILLIS);
    }

    public static Interval ofMicros(long micros) {
        return ZERO.plus(micros, ChronoUnit.MICROS);
    }

    public static Interval ofNanos(long nanos) {
        return ZERO.plus(nanos, ChronoUnit.NANOS);
    }

    public Interval plus(Interval interval) {
        long centuries = this.centuries + interval.centuries;
        long years = this.years + interval.years;
        long months = this.months + interval.months;
        long days = this.days + interval.days;
        long hours = this.hours + interval.hours;
        long minutes = this.minutes + interval.minutes;
        long seconds = this.seconds + interval.seconds;
        long millis = this.millis + interval.millis;
        long micros = this.micros + interval.micros;
        long nanos = this.nanos + interval.nanos;
        return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    @Override
    public Interval plus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            long maxValueLimit = 100000000000000000L;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries += amount;
                    break;
                }
                case YEARS: {
                    years += amount;
                    break;
                }
                case MONTHS: {
                    months += amount;
                    break;
                }
                case DAYS: {
                    days += amount;
                    break;
                }
                case HOURS: {
                    hours += amount;
                    break;
                }
                case MINUTES: {
                    minutes += amount;
                    break;
                }
                case SECONDS: {
                    seconds += amount;
                    break;
                }
                case MILLIS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000L;
                        long remainingMillis = amount % 3600000L;
                        hours += numberOfHours;
                        millis += remainingMillis;
                        break;
                    }
                    millis += amount;
                    break;
                }
                case MICROS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000000L;
                        long remainingMicros = amount % 3600000000L;
                        hours += numberOfHours;
                        micros += remainingMicros;
                        break;
                    }
                    micros += amount;
                    break;
                }
                case NANOS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000000000L;
                        long remainingNanos = amount % 3600000000000L;
                        hours += numberOfHours;
                        nanos += remainingNanos;
                        break;
                    }
                    nanos += amount;
                }
            }
            return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public Interval minus(Interval interval) {
        long years = this.centuries * 100L + this.years - (interval.centuries * 100L + interval.years);
        long months = this.months - interval.months;
        long days = this.days - interval.days;
        long hours = this.hours - interval.hours;
        long minutes = this.minutes - interval.minutes;
        long seconds = this.seconds - interval.seconds;
        long millis = this.millis - interval.millis;
        long micros = this.micros - interval.micros;
        long nanos = this.nanos - interval.nanos;
        return new Interval(this.centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
    }

    @Override
    public Interval minus(long amount, TemporalUnit unit) {
        if (unit instanceof ChronoUnit) {
            long centuries = this.centuries;
            long years = this.years;
            long months = this.months;
            long days = this.days;
            long hours = this.hours;
            long minutes = this.minutes;
            long seconds = this.seconds;
            long millis = this.millis;
            long micros = this.micros;
            long nanos = this.nanos;
            long maxValueLimit = 100000000000000000L;
            ChronoUnit chronoUnit = (ChronoUnit)unit;
            switch (chronoUnit) {
                case CENTURIES: {
                    centuries -= amount;
                    break;
                }
                case YEARS: {
                    years -= amount;
                    break;
                }
                case MONTHS: {
                    months -= amount;
                    break;
                }
                case DAYS: {
                    days -= amount;
                    break;
                }
                case HOURS: {
                    hours -= amount;
                    break;
                }
                case MINUTES: {
                    minutes -= amount;
                    break;
                }
                case SECONDS: {
                    seconds -= amount;
                    break;
                }
                case MILLIS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000L;
                        long remainingMillis = amount % 3600000L;
                        hours -= numberOfHours;
                        millis -= remainingMillis;
                        break;
                    }
                    millis -= amount;
                    break;
                }
                case MICROS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000000L;
                        long remainingMicros = amount % 3600000000L;
                        hours -= numberOfHours;
                        micros -= remainingMicros;
                        break;
                    }
                    micros -= amount;
                    break;
                }
                case NANOS: {
                    if (Math.abs(amount) > maxValueLimit) {
                        long numberOfHours = amount / 3600000000000L;
                        long remainingNanos = amount % 3600000000000L;
                        hours -= numberOfHours;
                        nanos -= remainingNanos;
                        break;
                    }
                    nanos -= amount;
                }
            }
            return new Interval(centuries, years, months, days, hours, minutes, seconds, millis, micros, nanos);
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    public static Interval between(Temporal startTemporal, Temporal endTemporal) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{startTemporal, endTemporal}), (String[])Preconditions.args((String[])new String[]{"startTemporal", "endTemporal"}));
        Preconditions.checkTemporal((!Interval.isSupported(startTemporal) || !Interval.isSupported(endTemporal) ? 1 : 0) != 0, (String)"Only [${\u2026}] is supported for `startTemporal` and `endTemporal` parameters!", (Object[])new Object[]{SUPPORTED_TEMPORAL_STRING});
        DateTime<Temporal> startDT = startTemporal instanceof DateTime ? (DateTime<Temporal>)startTemporal : DateTime.from(startTemporal);
        DateTime<Temporal> endDT = endTemporal instanceof DateTime ? (DateTime<Temporal>)endTemporal : DateTime.from(endTemporal);
        boolean isBefore = startDT.isBefore(endDT);
        Temporal tmpStartTemporal = isBefore ? startTemporal : endTemporal;
        Temporal tmpEndTemporal = isBefore ? endTemporal : startTemporal;
        SignedInterval signedInterval = SignedInterval.between(tmpStartTemporal, tmpEndTemporal);
        Interval interval = new Interval(signedInterval.centuries, signedInterval.years, signedInterval.months, signedInterval.days, signedInterval.hours, signedInterval.minutes, signedInterval.seconds, signedInterval.millis, signedInterval.micros, signedInterval.nanos);
        interval.startTime = tmpStartTemporal;
        interval.endTime = tmpEndTemporal;
        interval.totalYears = signedInterval.totalYears;
        interval.totalMonths = signedInterval.totalMonths;
        interval.totalWeeks = signedInterval.totalWeeks;
        interval.totalDays = signedInterval.totalDays;
        interval.totalHours = signedInterval.totalHours;
        interval.totalMinutes = signedInterval.totalMinutes;
        interval.totalSeconds = signedInterval.totalSeconds;
        interval.totalMillis = signedInterval.totalMillis;
        interval.totalMicros = signedInterval.totalMicros;
        interval.totalNanos = signedInterval.totalNanos;
        return interval;
    }

    public static Interval between(Date startDate, Date endDate) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{startDate, endDate}), (String[])Preconditions.args((String[])new String[]{"startDate", "endDate"}));
        return Interval.between(DateTime.from(startDate).getZonedDateTime(), DateTime.from(endDate).getZonedDateTime());
    }

    public static Interval between(Calendar startCalendar, Calendar endCalendar) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{startCalendar, endCalendar}), (String[])Preconditions.args((String[])new String[]{"startCalendar", "endCalendar"}));
        return Interval.between(DateTime.from(startCalendar).getZonedDateTime(), DateTime.from(endCalendar).getZonedDateTime());
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        Preconditions.checkNullNPE((Object)temporal, (String[])Preconditions.args((String[])new String[]{"temporal"}));
        Preconditions.checkTemporal((!Interval.isSupported(temporal) ? 1 : 0) != 0, (String)"Only [${\u2026}] is supported for `temporal` parameter!", (Object[])new Object[]{SUPPORTED_TEMPORAL_STRING});
        boolean isInstant = temporal instanceof Instant;
        temporal = isInstant ? ZonedDateTime.ofInstant((Instant)temporal, TZ.DEFAULT_ZONE) : temporal;
        temporal = this.minus(temporal, this.nanos, ChronoUnit.NANOS);
        temporal = this.minus(temporal, this.micros, ChronoUnit.MICROS);
        temporal = this.minus(temporal, this.millis, ChronoUnit.MILLIS);
        temporal = this.minus(temporal, this.seconds, ChronoUnit.SECONDS);
        temporal = this.minus(temporal, this.minutes, ChronoUnit.MINUTES);
        temporal = this.minus(temporal, this.hours, ChronoUnit.HOURS);
        temporal = this.minus(temporal, this.days, ChronoUnit.DAYS);
        temporal = this.minus(temporal, this.months, ChronoUnit.MONTHS);
        temporal = this.minus(temporal, this.centuries * 100L + this.years, ChronoUnit.YEARS);
        return isInstant ? ((ZonedDateTime)temporal).toInstant() : temporal;
    }

    @Override
    public Interval calculateApprox() {
        return (Interval)super.calculateApprox();
    }
}

