/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.annos.Beta;
import com.iofairy.os.OS;
import com.iofairy.si.SI;
import com.iofairy.top.G;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import com.iofairy.validator.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

@Deprecated
@Beta
public class Stopwatch {
    private long startTick;
    private long lastMarkTick;
    private long stopTick;
    private long elapsedNanos;
    private boolean isRunning;
    private int markIndex = 0;
    private final Map<String, Integer> MARK_INDEX_MAP = new LinkedHashMap<String, Integer>();
    private final Map<Integer, String> INDEX_MARK_MAP = new LinkedHashMap<Integer, String>();
    private final Map<Object, Long> MARK_TICK_MAP = new HashMap<Object, Long>();
    private final String START_MARK = "START";
    private final String STOP_MARK = "STOP";
    private final Pattern MARK_PATTERN = Pattern.compile("MARK\\d+");
    private static final String NANOS_UNIT = OS.IS_ZH_LANG ? "\u7eb3\u79d2" : "ns";
    private static final String MICROS_UNIT = OS.IS_ZH_LANG ? "\u5fae\u79d2" : "\u03bcs";
    private static final String MILLIS_UNIT = OS.IS_ZH_LANG ? "\u6beb\u79d2" : "ms";
    private static final String SECONDS_UNIT = OS.IS_ZH_LANG ? "\u79d2" : "s";
    private static final String MINUTES_UNIT = OS.IS_ZH_LANG ? "\u5206" : "min";
    private static final String HOURS_UNIT = OS.IS_ZH_LANG ? "\u65f6" : "h";
    private static final String DAYS_UNIT = OS.IS_ZH_LANG ? "\u5929" : "d";
    private static final Map<TimeUnit, String> UNIT_STRING_MAP = new HashMap<TimeUnit, String>(){
        {
            this.put(TimeUnit.NANOSECONDS, NANOS_UNIT);
            this.put(TimeUnit.MICROSECONDS, MICROS_UNIT);
            this.put(TimeUnit.MILLISECONDS, MILLIS_UNIT);
            this.put(TimeUnit.SECONDS, SECONDS_UNIT);
            this.put(TimeUnit.MINUTES, MINUTES_UNIT);
            this.put(TimeUnit.HOURS, HOURS_UNIT);
            this.put(TimeUnit.DAYS, DAYS_UNIT);
        }
    };

    Stopwatch() {
    }

    public static Stopwatch run() {
        return Stopwatch.create().start();
    }

    public static Stopwatch create() {
        return new Stopwatch();
    }

    public Stopwatch start() {
        Preconditions.checkState((boolean)this.isRunning, (String)"This stopwatch is already running! ", (Object[])new Object[0]);
        this.isRunning = true;
        this.elapsedNanos = 0L;
        this.startTick = System.nanoTime();
        this.nanoTimeMark(0, this.startTick, "START");
        return this;
    }

    public Stopwatch stop() {
        Preconditions.checkState((!this.isRunning ? 1 : 0) != 0, (String)"This stopwatch is already stopped! ", (Object[])new Object[0]);
        this.isRunning = false;
        this.stopTick = System.nanoTime();
        this.elapsedNanos = this.stopTick - this.startTick;
        this.nanoTimeMark(++this.markIndex, this.stopTick, "STOP");
        return this;
    }

    public Stopwatch mark(String name) {
        Preconditions.checkState((!this.isRunning ? 1 : 0) != 0, (String)"This stopwatch is already stopped! ", (Object[])new Object[0]);
        Preconditions.checkNullNPE((Object)name, (String[])Preconditions.args((String[])new String[]{"name"}));
        Preconditions.checkArgument((name.equalsIgnoreCase("START") || name.equalsIgnoreCase("STOP") || this.MARK_PATTERN.matcher(name.toUpperCase()).matches() ? 1 : 0) != 0, (String)"The words 'START' and 'STOP' and ('MARK1', 'MARK2', 'MARK3', 'MARKn' ...) are reserved and can't be used. ", (Object[])new Object[0]);
        Preconditions.checkArgument((boolean)this.MARK_TICK_MAP.containsKey(name), (String)"The mark point [${\u2026}] already exists. ", (Object[])new Object[]{name});
        this.nanoTimeMark(++this.markIndex, System.nanoTime(), name);
        return this;
    }

    public Stopwatch mark() {
        Preconditions.checkState((!this.isRunning ? 1 : 0) != 0, (String)"This stopwatch is already stopped! ", (Object[])new Object[0]);
        this.nanoTimeMark(++this.markIndex, System.nanoTime(), "MARK" + this.markIndex);
        return this;
    }

    private void nanoTimeMark(int markIndex, long tick, String name) {
        this.lastMarkTick = tick;
        this.MARK_TICK_MAP.put(markIndex, tick);
        this.MARK_TICK_MAP.put(name, tick);
        this.MARK_INDEX_MAP.put(name, markIndex);
        this.INDEX_MARK_MAP.put(markIndex, name);
    }

    public Stopwatch reset() {
        this.clearMarks(true);
        this.isRunning = false;
        this.stopTick = 0L;
        this.markIndex = 0;
        this.start();
        return this;
    }

    private long elapsedNanos() {
        return this.isRunning ? System.nanoTime() - this.startTick : this.elapsedNanos;
    }

    public long elapsed(TimeUnit unit) {
        return unit.convert(this.elapsedNanos(), TimeUnit.NANOSECONDS);
    }

    public double elapsedExact(TimeUnit unit) {
        return Stopwatch.getElapsedDouble(unit, this.elapsedNanos());
    }

    public Duration elapsed() {
        return Duration.ofNanos(this.elapsedNanos());
    }

    private long elapsedLastNanos() {
        return this.isRunning ? System.nanoTime() - this.lastMarkTick : this.stopTick - this.lastMarkTick;
    }

    public long elapsedLast(TimeUnit unit) {
        return unit.convert(this.elapsedLastNanos(), TimeUnit.NANOSECONDS);
    }

    public double elapsedLastExact(TimeUnit unit) {
        return Stopwatch.getElapsedDouble(unit, this.elapsedLastNanos());
    }

    public Duration elapsedLast() {
        return Duration.ofNanos(this.elapsedLastNanos());
    }

    public String elapsedLastString() {
        return Stopwatch.elapsedString(this.elapsedLastNanos());
    }

    @Deprecated
    public String elapsedlastString() {
        return Stopwatch.elapsedString(this.elapsedLastNanos());
    }

    public long elapsedLastAndMark(TimeUnit unit) {
        long elapsed = this.elapsedLast(unit);
        this.mark();
        return elapsed;
    }

    public double elapsedLastExactAndMark(TimeUnit unit) {
        double elapsedLastExact = this.elapsedLastExact(unit);
        this.mark();
        return elapsedLastExact;
    }

    public Duration elapsedLastAndMark() {
        Duration elapsedLast = this.elapsedLast();
        this.mark();
        return elapsedLast;
    }

    public String elapsedLastStringAndMark() {
        String elapsedString = this.elapsedLastString();
        this.mark();
        return elapsedString;
    }

    public Elapsed elapsed(Object from, Object to) {
        String toMark;
        int toIndex;
        String fromMark;
        int fromIndex;
        Tuple2<Object, Object> fromTo = this.adjustFromTo(from, to);
        from = fromTo._1;
        to = fromTo._2;
        long elapsedNanos = this.MARK_TICK_MAP.get(to) - this.MARK_TICK_MAP.get(from);
        if (from instanceof Integer) {
            fromIndex = (Integer)from;
            fromMark = this.INDEX_MARK_MAP.get(from);
        } else {
            fromIndex = this.MARK_INDEX_MAP.get(from);
            fromMark = (String)from;
        }
        if (to instanceof Integer) {
            toIndex = (Integer)to;
            toMark = this.INDEX_MARK_MAP.get(to);
        } else {
            toIndex = this.MARK_INDEX_MAP.get(to);
            toMark = (String)to;
        }
        return new Elapsed(fromIndex, toIndex, fromMark, toMark, elapsedNanos);
    }

    public Tuple2<Object, Object> adjustFromTo(Object from, Object to) {
        Preconditions.checkArgument((!(from instanceof Integer) && !(from instanceof String) || !(to instanceof Integer) && !(to instanceof String) ? 1 : 0) != 0, (String)"The types of parameters `from` and `to` must be either [String] or [Integer]! ", (Object[])new Object[0]);
        Preconditions.checkArgument((!this.MARK_TICK_MAP.containsKey(from) ? 1 : 0) != 0, (String)"Not found for this mark point [${\u2026}]. ", (Object[])new Object[]{from});
        Preconditions.checkArgument((!this.MARK_TICK_MAP.containsKey(to) ? 1 : 0) != 0, (String)"Not found for this mark point [${\u2026}]. ", (Object[])new Object[]{to});
        return this.MARK_TICK_MAP.get(to) - this.MARK_TICK_MAP.get(from) >= 0L ? Tuple.of((Object)from, (Object)to) : Tuple.of((Object)to, (Object)from);
    }

    public Map<Integer, String> getMarks() {
        return Collections.unmodifiableMap(this.INDEX_MARK_MAP);
    }

    public void clearMarks() {
        this.clearMarks(false);
    }

    private void clearMarks(boolean isReset) {
        this.markIndex = 0;
        this.MARK_INDEX_MAP.clear();
        this.INDEX_MARK_MAP.clear();
        this.MARK_TICK_MAP.clear();
        if (!isReset) {
            if (this.isRunning) {
                this.nanoTimeMark(0, this.startTick, "START");
            } else if (this.stopTick != 0L) {
                this.nanoTimeMark(0, this.startTick, "START");
                this.nanoTimeMark(1, this.stopTick, "STOP");
            }
        }
    }

    public String toString() {
        return Stopwatch.elapsedString(this.elapsedNanos());
    }

    public static String elapsedString(long nanos) {
        TimeUnit unit = Stopwatch.chooseUnit(nanos);
        double value = (double)nanos / (double)unit.toNanos(1L);
        return G.toString((Number)value, (int)3) + '(' + UNIT_STRING_MAP.get((Object)unit) + ')';
    }

    static double getElapsedDouble(TimeUnit unit, long nanos) {
        return BigDecimal.valueOf((double)nanos / (double)unit.toNanos(1L)).setScale(4, RoundingMode.HALF_UP).doubleValue();
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.NANOSECONDS.toDays(nanos) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.NANOSECONDS.toHours(nanos) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.NANOSECONDS.toMinutes(nanos) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.NANOSECONDS.toSeconds(nanos) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMillis(nanos) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.NANOSECONDS.toMicros(nanos) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getStartTick() {
        return this.startTick;
    }

    public long getLastMarkTick() {
        return this.lastMarkTick;
    }

    public long getStopTick() {
        return this.stopTick;
    }

    public long getElapsedNanos() {
        return this.elapsedNanos;
    }

    public int getMarkIndex() {
        return this.markIndex;
    }

    public static class Elapsed {
        public final int fromIndex;
        public final int toIndex;
        public final String from;
        public final String to;
        public final long elapsedNanos;

        Elapsed(int fromIndex, int toIndex, String from, String to, long elapsedNanos) {
            this.fromIndex = fromIndex;
            this.toIndex = toIndex;
            this.from = from;
            this.to = to;
            this.elapsedNanos = elapsedNanos;
        }

        public long elapsed(TimeUnit unit) {
            return unit.convert(this.elapsedNanos, TimeUnit.NANOSECONDS);
        }

        public double elapsedExact(TimeUnit unit) {
            return Stopwatch.getElapsedDouble(unit, this.elapsedNanos);
        }

        public Duration elapsed() {
            return Duration.ofNanos(this.elapsedNanos);
        }

        public String toString() {
            return Stopwatch.elapsedString(this.elapsedNanos);
        }

        public String toFullString() {
            return SI.$((CharSequence)"${elapsed} (index: ${fromIndex} -> ${toIndex}, mark: ${from} -> ${to})", (Object[])new Object[]{Stopwatch.elapsedString(this.elapsedNanos), this.fromIndex, this.toIndex, this.from, this.to});
        }
    }
}

