/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.time;

import com.iofairy.falcon.time.DTC;
import com.iofairy.falcon.time.DateTime;
import com.iofairy.falcon.time.DateTimes;
import com.iofairy.os.OS;
import com.iofairy.top.S;
import com.iofairy.validator.Preconditions;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.TextStyle;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.ValueRange;
import java.time.temporal.WeekFields;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;

@Deprecated
public class WeekInfo {
    static final Pattern Y = Pattern.compile("Y(?!'(?<='Y'))");
    static final Pattern M = Pattern.compile("M(?!'(?<='M'))");
    static final Pattern W = Pattern.compile("W(?!'(?<='W'))");
    static final Pattern w = Pattern.compile("w(?!'(?<='w'))");
    static final Pattern QYQ = Pattern.compile("'Y'");
    static final Pattern QMQ = Pattern.compile("'M'");
    static final Pattern QWQ = Pattern.compile("'W'");
    static final Pattern qwq = Pattern.compile("'w'");
    static final Pattern WW = Pattern.compile("WW");
    static final Pattern ww = Pattern.compile("ww");
    int minYear;
    int maxYear;
    int minMonth;
    int maxMonth;
    int daysInMinYear;
    int daysInMaxYear;
    int daysInMinMonth;
    int daysInMaxMonth;
    Boolean isCrossMonth;
    Boolean isCrossYear;
    WeekFields weekFields;
    LocalDate localDate;
    LocalDate startDayOfWeek;
    LocalDate endDayOfWeek;
    DayOfWeek dayOfWeek;
    int dayIndexOfWeek;
    int weekYear;
    int weekOfYear;
    int weekMonth;
    int weekOfMonth;
    int weekBasedYear;
    int weekOfWeekBasedYear;
    int weekBasedMonth;
    int weekOfWeekBasedMonth;

    public WeekInfo(LocalDate localDate) {
        this(DTC.MONDAY_MIN7, localDate);
    }

    public WeekInfo(WeekFields weekFields, LocalDate localDate) {
        Preconditions.checkNullNPE((Object)localDate, (String[])Preconditions.args((String[])new String[]{"localDate"}));
        this.dayOfWeek = localDate.getDayOfWeek();
        this.weekFields = weekFields;
        this.localDate = localDate;
        if (weekFields == null) {
            int days;
            int dayOfMonth = localDate.getDayOfMonth();
            int remainder = dayOfMonth % 7;
            this.startDayOfWeek = localDate.minusDays((remainder + 6) % 7);
            this.endDayOfWeek = this.startDayOfWeek.plusDays(6L);
            if (this.startDayOfWeek.getMonthValue() != this.endDayOfWeek.getMonthValue()) {
                this.endDayOfWeek = this.startDayOfWeek.withDayOfMonth(this.startDayOfWeek.lengthOfMonth());
            }
            this.dayIndexOfWeek = remainder == 0 ? 7 : remainder;
            this.maxYear = this.minYear = localDate.getYear();
            this.maxMonth = this.minMonth = this.localDate.getMonthValue();
            this.isCrossYear = false;
            this.isCrossMonth = false;
            this.daysInMinYear = days = this.endDayOfWeek.getDayOfMonth() - this.startDayOfWeek.getDayOfMonth() + 1;
            this.daysInMaxYear = days;
            this.daysInMinMonth = days;
            this.daysInMaxMonth = days;
        } else {
            this.startDayOfWeek = localDate.with(TemporalAdjusters.previousOrSame(weekFields.getFirstDayOfWeek()));
            this.endDayOfWeek = this.startDayOfWeek.plusDays(6L);
            this.dayIndexOfWeek = localDate.get(weekFields.dayOfWeek());
            this.minYear = this.startDayOfWeek.getYear();
            this.maxYear = this.endDayOfWeek.getYear();
            this.minMonth = this.startDayOfWeek.getMonthValue();
            this.maxMonth = this.endDayOfWeek.getMonthValue();
            this.isCrossYear = this.minYear != this.maxYear;
            this.isCrossMonth = this.minMonth != this.maxMonth;
            if (this.isCrossMonth.booleanValue()) {
                int minMonthDays;
                int maxMonthDays = this.endDayOfWeek.getDayOfMonth();
                this.daysInMinMonth = minMonthDays = 7 - maxMonthDays;
                this.daysInMaxMonth = maxMonthDays;
                if (this.isCrossYear.booleanValue()) {
                    this.daysInMinYear = minMonthDays;
                    this.daysInMaxYear = maxMonthDays;
                } else {
                    this.daysInMinYear = 7;
                    this.daysInMaxYear = 7;
                }
            } else {
                this.daysInMinYear = 7;
                this.daysInMaxYear = 7;
                this.daysInMinMonth = 7;
                this.daysInMaxMonth = 7;
            }
        }
    }

    public static WeekInfo of(DateTime<?> dateTime) {
        return new WeekInfo(dateTime.getLocalDateTime().toLocalDate());
    }

    public static WeekInfo of(LocalDate localDate) {
        return new WeekInfo(localDate);
    }

    public static WeekInfo of(Date date) {
        return WeekInfo.of(DateTime.of(date));
    }

    public static WeekInfo of(WeekFields weekFields, DateTime<?> dateTime) {
        return new WeekInfo(weekFields, dateTime.getLocalDateTime().toLocalDate());
    }

    public static WeekInfo of(WeekFields weekFields, LocalDate localDate) {
        return new WeekInfo(weekFields, localDate);
    }

    public static WeekInfo of(WeekFields weekFields, Date date) {
        return WeekInfo.of(weekFields, DateTime.of(date));
    }

    public WeekInfo baseMonth() {
        this.weekMonth = this.localDate.getMonthValue();
        this.weekYear = this.localDate.getYear();
        if (this.weekFields == null) {
            int dayOfMonth = this.localDate.getDayOfMonth();
            int week = dayOfMonth / 7;
            int remainder = dayOfMonth % 7;
            if (remainder != 0) {
                ++week;
            }
            this.weekOfMonth = week;
            this.weekBasedMonth = this.weekMonth;
            this.weekOfWeekBasedMonth = this.weekOfMonth;
            this.weekBasedYear = this.weekYear;
        } else {
            this.weekOfMonth = this.localDate.get(this.weekFields.weekOfMonth());
            if (this.weekOfMonth == 1 || this.weekOfMonth == 2 || this.weekOfMonth == 3) {
                this.weekBasedMonth = this.weekMonth;
                this.weekOfWeekBasedMonth = this.weekOfMonth;
                this.weekBasedYear = this.weekYear;
            } else if (this.weekOfMonth == 0) {
                LocalDate ld = this.localDate.minusMonths(1L);
                this.weekBasedMonth = ld.getMonthValue();
                this.weekBasedYear = ld.getYear();
                ld = ld.withDayOfMonth(ld.lengthOfMonth());
                this.weekOfWeekBasedMonth = ld.get(this.weekFields.weekOfMonth());
            } else {
                LocalDate ld;
                int weekOfThisMonth;
                this.weekBasedMonth = this.weekMonth;
                this.weekOfWeekBasedMonth = this.weekOfMonth;
                this.weekBasedYear = this.weekYear;
                if (this.isCrossMonth.booleanValue() && (weekOfThisMonth = (ld = this.localDate.plusMonths(1L).withDayOfMonth(1)).get(this.weekFields.weekOfMonth())) != 0) {
                    this.weekBasedMonth = ld.getMonthValue();
                    this.weekOfWeekBasedMonth = weekOfThisMonth;
                    this.weekBasedYear = ld.getYear();
                }
            }
        }
        return this;
    }

    public WeekInfo baseYear() {
        if (this.weekFields == null) {
            this.weekYear = this.localDate.getYear();
            this.weekOfYear = 0;
            this.weekBasedYear = this.weekYear;
            this.weekOfWeekBasedYear = 0;
        } else {
            this.weekYear = this.localDate.getYear();
            this.weekOfYear = this.localDate.get(this.weekFields.weekOfYear());
            this.weekBasedYear = this.weekBasedYear == 0 ? this.localDate.get(this.weekFields.weekBasedYear()) : this.weekBasedYear;
            this.weekOfWeekBasedYear = this.localDate.get(this.weekFields.weekOfWeekBasedYear());
        }
        return this;
    }

    public WeekInfo baseYearMonth() {
        this.baseMonth();
        this.baseYear();
        return this;
    }

    public static LocalDate baseMonth(int year, int month, int weekNo) {
        return WeekInfo.baseMonth(DTC.MONDAY_MIN7, YearMonth.of(year, month), weekNo);
    }

    public static LocalDate baseMonth(WeekFields weekFields, int year, int month, int weekNo) {
        return WeekInfo.baseMonth(weekFields, YearMonth.of(year, month), weekNo);
    }

    public static LocalDate baseMonth(YearMonth yearMonth, int weekNo) {
        return WeekInfo.baseMonth(DTC.MONDAY_MIN7, yearMonth, weekNo);
    }

    public static LocalDate baseMonth(WeekFields weekFields, YearMonth yearMonth, int weekNo) {
        Preconditions.checkOutOfBounds((weekNo < 0 || weekNo > 6 ? 1 : 0) != 0, (Number)weekNo, (String)(OS.IS_ZH_LANG ? "\u6307\u5b9a\u6708\u4e2d\u7684\u5468\u5e8f\u53f7\u65f6\uff0c\u53c2\u6570`weekNo`\u7684\u53d6\u503c\u8303\u56f4\u4e3a\uff1a[0, 6]\u3002" : "The `weekNo`'s range is [0, 6] when getting the week of the month. "), (Object[])new Object[0]);
        ValueRange valueRange = WeekInfo.weekRangeInMonth(weekFields, yearMonth);
        int minimum = (int)valueRange.getMinimum();
        int maximum = (int)valueRange.getMaximum();
        if (weekNo < minimum) {
            weekNo = minimum;
        }
        if (weekNo > maximum) {
            weekNo = maximum;
        }
        LocalDate firstDayOfMonth = yearMonth.atDay(1);
        if (weekFields == null) {
            return firstDayOfMonth.plusWeeks(weekNo - 1);
        }
        DayOfWeek firstDayOfWeek = weekFields.getFirstDayOfWeek();
        LocalDate firstDayInThisWeek = firstDayOfMonth.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        return firstDayInThisWeek.plusWeeks(weekNo - minimum);
    }

    public static LocalDate baseYear(int year, int weekNo) {
        return WeekInfo.baseYear(DTC.MONDAY_MIN7, year, weekNo);
    }

    public static LocalDate baseYear(WeekFields weekFields, int year, int weekNo) {
        Preconditions.checkNullNPE((Object)weekFields, (String[])Preconditions.args((String[])new String[]{"weekFields"}));
        Preconditions.checkOutOfBounds((weekNo < 0 || weekNo > 54 ? 1 : 0) != 0, (Number)weekNo, (String)(OS.IS_ZH_LANG ? "\u6307\u5b9a\u5e74\u4e2d\u7684\u5468\u5e8f\u53f7\u65f6\uff0c\u53c2\u6570`weekNo`\u7684\u53d6\u503c\u8303\u56f4\u4e3a\uff1a[0, 54]\u3002" : "The `weekNo`'s range is [0, 54] when getting the week of the year."), (Object[])new Object[0]);
        ValueRange valueRange = WeekInfo.weekRangeInYear(weekFields, year);
        int minimum = (int)valueRange.getMinimum();
        int maximum = (int)valueRange.getMaximum();
        if (weekNo < minimum) {
            weekNo = minimum;
        }
        if (weekNo > maximum) {
            weekNo = maximum;
        }
        DayOfWeek firstDayOfWeek = weekFields.getFirstDayOfWeek();
        LocalDate firstDayOfYear = LocalDate.of(year, 1, 1);
        LocalDate firstDayInThisWeek = firstDayOfYear.with(TemporalAdjusters.previousOrSame(firstDayOfWeek));
        return firstDayInThisWeek.plusWeeks(weekNo - minimum);
    }

    public static ValueRange weekRangeInMonth(WeekFields weekFields, int year, int month) {
        return WeekInfo.weekRangeInMonth(weekFields, YearMonth.of(year, month));
    }

    public static ValueRange weekRangeInMonth(WeekFields weekFields, YearMonth yearMonth) {
        Preconditions.checkNullNPE((Object)yearMonth, (String[])Preconditions.args((String[])new String[]{"yearMonth"}));
        if (weekFields == null) {
            int daysOfMonth = yearMonth.lengthOfMonth();
            int maxWeeks = daysOfMonth / 7;
            if (daysOfMonth % 7 != 0) {
                ++maxWeeks;
            }
            return ValueRange.of(1L, maxWeeks);
        }
        return ValueRange.of(yearMonth.atDay(1).get(weekFields.weekOfMonth()), yearMonth.atEndOfMonth().get(weekFields.weekOfMonth()));
    }

    public static ValueRange weekRangeInYear(WeekFields weekFields, int year) {
        Preconditions.checkNullNPE((Object)weekFields, (String[])Preconditions.args((String[])new String[]{"weekFields"}));
        LocalDate startDate = LocalDate.of(year, 1, 1);
        LocalDate endDate = LocalDate.of(year, 12, 31);
        return ValueRange.of(startDate.get(weekFields.weekOfYear()), endDate.get(weekFields.weekOfYear()));
    }

    public String format() {
        return this.format(null);
    }

    public String format(String pattern) {
        String weekBasedYearStr = String.format("%04d", this.weekBasedYear);
        String weekOfWeekBasedYearStr = String.format("%02d", this.weekOfWeekBasedYear);
        String weekBasedMonthStr = String.format("%02d", this.weekBasedMonth);
        String weekOfWeekBasedMonthStr = String.format("%02d", this.weekOfWeekBasedMonth);
        if (S.isBlank((CharSequence)pattern)) {
            return weekBasedYearStr + "-" + weekBasedMonthStr + "-W" + weekOfWeekBasedMonthStr;
        }
        pattern = WW.matcher(pattern).replaceAll(weekOfWeekBasedMonthStr);
        pattern = ww.matcher(pattern).replaceAll(weekOfWeekBasedYearStr);
        pattern = Y.matcher(pattern).replaceAll(weekBasedYearStr);
        pattern = M.matcher(pattern).replaceAll(weekBasedMonthStr);
        pattern = W.matcher(pattern).replaceAll(this.weekOfWeekBasedMonth + "");
        pattern = w.matcher(pattern).replaceAll(this.weekOfWeekBasedYear + "");
        pattern = QYQ.matcher(pattern).replaceAll("Y");
        pattern = QMQ.matcher(pattern).replaceAll("M");
        pattern = QWQ.matcher(pattern).replaceAll("W");
        pattern = qwq.matcher(pattern).replaceAll("w");
        return pattern;
    }

    public String formatWeek() {
        return this.formatWeek(null);
    }

    public String formatWeek(String pattern) {
        String weekYearStr = String.format("%04d", this.weekYear);
        String weekOfYearStr = String.format("%02d", this.weekOfYear);
        String weekMonthStr = String.format("%02d", this.weekMonth);
        String weekOfMonthStr = String.format("%02d", this.weekOfMonth);
        if (S.isBlank((CharSequence)pattern)) {
            return weekYearStr + "-" + weekMonthStr + "-W" + weekOfMonthStr;
        }
        pattern = WW.matcher(pattern).replaceAll(weekOfMonthStr);
        pattern = ww.matcher(pattern).replaceAll(weekOfYearStr);
        pattern = Y.matcher(pattern).replaceAll(weekYearStr);
        pattern = M.matcher(pattern).replaceAll(weekMonthStr);
        pattern = W.matcher(pattern).replaceAll(this.weekOfMonth + "");
        pattern = w.matcher(pattern).replaceAll(this.weekOfYear + "");
        pattern = QYQ.matcher(pattern).replaceAll("Y");
        pattern = QMQ.matcher(pattern).replaceAll("M");
        pattern = QWQ.matcher(pattern).replaceAll("W");
        pattern = qwq.matcher(pattern).replaceAll("w");
        return pattern;
    }

    public String nameOfDayOfWeek() {
        return this.nameOfDayOfWeek(null, null);
    }

    public String nameOfDayOfWeek(Locale locale) {
        return this.nameOfDayOfWeek(null, locale);
    }

    public String nameOfDayOfWeek(TextStyle textStyle) {
        return this.nameOfDayOfWeek(textStyle, null);
    }

    public String nameOfDayOfWeek(TextStyle textStyle, Locale locale) {
        return DateTimes.nameOfDayOfWeek(this.getDayOfWeek(), textStyle, locale);
    }

    public int getMinYear() {
        return this.minYear;
    }

    public int getMaxYear() {
        return this.maxYear;
    }

    public int getMinMonth() {
        return this.minMonth;
    }

    public int getMaxMonth() {
        return this.maxMonth;
    }

    public int getDaysInMinYear() {
        return this.daysInMinYear;
    }

    public int getDaysInMaxYear() {
        return this.daysInMaxYear;
    }

    public int getDaysInMinMonth() {
        return this.daysInMinMonth;
    }

    public int getDaysInMaxMonth() {
        return this.daysInMaxMonth;
    }

    public Boolean getCrossMonth() {
        return this.isCrossMonth;
    }

    public Boolean getCrossYear() {
        return this.isCrossYear;
    }

    public WeekFields getWeekFields() {
        return this.weekFields;
    }

    public LocalDate getLocalDate() {
        return this.localDate;
    }

    public LocalDate getStartDayOfWeek() {
        return this.startDayOfWeek;
    }

    public LocalDate getEndDayOfWeek() {
        return this.endDayOfWeek;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    public int getDayIndexOfWeek() {
        return this.dayIndexOfWeek;
    }

    public int getWeekYear() {
        return this.weekYear;
    }

    public int getWeekOfYear() {
        return this.weekOfYear;
    }

    public int getWeekMonth() {
        return this.weekMonth;
    }

    public int getWeekOfMonth() {
        return this.weekOfMonth;
    }

    public int getWeekBasedYear() {
        return this.weekBasedYear;
    }

    public int getWeekOfWeekBasedYear() {
        return this.weekOfWeekBasedYear;
    }

    public int getWeekBasedMonth() {
        return this.weekBasedMonth;
    }

    public int getWeekOfWeekBasedMonth() {
        return this.weekOfWeekBasedMonth;
    }

    public String toString() {
        String weekOfYearStr = String.format("%02d", this.weekOfYear);
        String weekMonthStr = String.format("%02d", this.weekMonth);
        String weekOfMonthStr = String.format("%02d", this.weekOfMonth);
        String weekOfWeekBasedYearStr = String.format("%02d", this.weekOfWeekBasedYear);
        String weekBasedMonthStr = String.format("%02d", this.weekBasedMonth);
        String weekOfWeekBasedMonthStr = String.format("%02d", this.weekOfWeekBasedMonth);
        String minMonthStr = String.format("%02d", this.minMonth);
        String maxMonthStr = String.format("%02d", this.maxMonth);
        String isCrossYearStr = this.isCrossYear == null || this.isCrossYear != false ? this.isCrossYear + " " : "false";
        String isCrossMonthStr = this.isCrossMonth == null || this.isCrossMonth != false ? this.isCrossMonth + " " : "false";
        String weekFieldsStr = (this.weekFields == null ? null : this.weekFields.getFirstDayOfWeek()) + ", ";
        weekFieldsStr = weekFieldsStr + S.padLeftChars((CharSequence)((this.weekFields == null ? null : Integer.valueOf(this.weekFields.getMinimalDaysInFirstWeek())) + ""), (char)' ', (int)(11 - weekFieldsStr.length()));
        String displayName = this.dayOfWeek.getDisplayName(TextStyle.FULL, Locale.getDefault());
        String nameOfDayOfWeek = S.padRightChars((CharSequence)displayName, (char)' ', (int)3);
        return "WeekInfo{[dayOfWeek, firstDayOfWeek, minDaysInFirstWeek]=(" + nameOfDayOfWeek + ", " + weekFieldsStr + "), [localDate<dayIndexOfWeek>]=(" + this.localDate + "<" + this.dayIndexOfWeek + ">, " + this.startDayOfWeek + " ~ " + this.endDayOfWeek + "), [minYear<days>, maxYear<days>, isCrossYear]=(" + this.minYear + "<" + this.daysInMinYear + ">, " + this.maxYear + "<" + this.daysInMaxYear + ">, " + isCrossYearStr + "), [minMonth<days>, maxMonth<days>, isCrossMonth]=(" + minMonthStr + "<" + this.daysInMinMonth + ">, " + maxMonthStr + "<" + this.daysInMaxMonth + ">, " + isCrossMonthStr + "), [weekYear, weekBasedYear]=(" + this.weekYear + "-W" + weekOfYearStr + ", " + this.weekBasedYear + "-W" + weekOfWeekBasedYearStr + "), [weekMonth, weekBasedMonth]=(" + weekMonthStr + "-W" + weekOfMonthStr + ", " + weekBasedMonthStr + "-W" + weekOfWeekBasedMonthStr + ")" + '}';
    }
}

