/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.unit;

import com.iofairy.falcon.unit.ByteUnit;
import com.iofairy.falcon.unit.ByteValue;
import java.util.HashMap;
import java.util.Map;

public enum ByteDecimalUnit implements ByteUnit
{
    bit("bit", ByteValue.of(1), -1),
    B("byte", ByteValue.of(1000, 0), 0),
    KB("kilobyte", ByteValue.of(1000, 1), 1),
    MB("megabyte", ByteValue.of(1000, 2), 2),
    GB("gigabyte", ByteValue.of(1000, 3), 3),
    TB("terabyte", ByteValue.of(1000, 4), 4),
    PB("petabyte", ByteValue.of(1000, 5), 5),
    EB("exabyte", ByteValue.of(1000, 6), 6),
    ZB("zettabyte", ByteValue.of(1000, 7), 7),
    YB("yottabyte", ByteValue.of(1000, 8), 8);

    final String name;
    final ByteValue byteValue;
    final int index;
    static final Map<String, ByteDecimalUnit> UNITS_MAP;
    static final Map<Integer, ByteDecimalUnit> UNITS_INDEX_MAP;
    static final Map<Integer, String> INDEX_TYPE_MAP;

    private ByteDecimalUnit(String name, ByteValue byteValue, int index) {
        this.name = name;
        this.byteValue = byteValue;
        this.index = index;
    }

    public static ByteDecimalUnit of(String type) {
        if (type == null) {
            return null;
        }
        return UNITS_MAP.get(type.toUpperCase());
    }

    public static ByteDecimalUnit of(int index) {
        return UNITS_INDEX_MAP.get(index);
    }

    public static String getUnitType(int index) {
        return INDEX_TYPE_MAP.get(index);
    }

    @Override
    public boolean isBinaryUnit() {
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ByteValue getByteValue() {
        return this.byteValue;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    static {
        UNITS_MAP = new HashMap<String, ByteDecimalUnit>();
        UNITS_INDEX_MAP = new HashMap<Integer, ByteDecimalUnit>();
        INDEX_TYPE_MAP = new HashMap<Integer, String>();
        for (ByteDecimalUnit value : ByteDecimalUnit.values()) {
            String valueStr = value.toString();
            UNITS_MAP.put(valueStr.toUpperCase(), value);
            UNITS_INDEX_MAP.put(value.index, value);
            INDEX_TYPE_MAP.put(value.index, valueStr);
        }
    }
}

