/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.unit;

import com.iofairy.falcon.unit.ByteFactor;
import java.math.BigInteger;

public class ByteValue {
    int bits;
    int bytes;
    int exponentForBytes;

    public ByteValue() {
    }

    public ByteValue(int bits) {
        this.bits = bits;
    }

    public ByteValue(int bytes, int exponentForBytes) {
        this.bytes = bytes;
        this.exponentForBytes = exponentForBytes;
    }

    public static ByteValue of() {
        return new ByteValue();
    }

    public static ByteValue of(int bits) {
        return new ByteValue(bits);
    }

    public static ByteValue of(int bytes, int exponentForBytes) {
        return new ByteValue(bytes, exponentForBytes);
    }

    public BigInteger getAllBytes() {
        return BigInteger.valueOf(this.bytes).pow(this.exponentForBytes);
    }

    public BigInteger getAllBits() {
        return this.getAllBytes().multiply(ByteFactor.X8).add(BigInteger.valueOf(this.bits));
    }

    public int getBits() {
        return this.bits;
    }

    public void setBits(int bits) {
        this.bits = bits;
    }

    public int getBytes() {
        return this.bytes;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }

    public int getExponentForBytes() {
        return this.exponentForBytes;
    }

    public void setExponentForBytes(int exponentForBytes) {
        this.exponentForBytes = exponentForBytes;
    }

    public String toString() {
        return "ByteValue{bits=" + this.bits + ", bytes=" + this.bytes + ", exponentForBytes=" + this.exponentForBytes + '}';
    }
}

