/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.unit;

import com.iofairy.annos.Beta;
import com.iofairy.except.UnexpectedParameterException;
import com.iofairy.falcon.unit.ByteBinaryUnit;
import com.iofairy.falcon.unit.ByteDecimalUnit;
import com.iofairy.falcon.unit.ByteFactor;
import com.iofairy.falcon.unit.ByteUnit;
import com.iofairy.top.O;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import com.iofairy.validator.Preconditions;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;

@Beta
public class Bytes
implements Comparable<Bytes>,
Serializable {
    private static final long serialVersionUID = 98765567006076565L;
    public final long bit;
    public final long b;
    public final long kb;
    public final long mb;
    public final long gb;
    public final long tb;
    public final long pb;
    public final long eb;
    public final long zb;
    public final long yb;
    public final boolean isBinaryUnit;
    BigInteger bits;
    BigInteger bs;
    BigInteger kbs;
    BigInteger mbs;
    BigInteger gbs;
    BigInteger tbs;
    BigInteger pbs;
    BigInteger ebs;
    BigInteger zbs;
    BigInteger ybs;
    public static final Bytes ZERO_BINARY = new Bytes(0L, 0L, 0L, 0L, true);
    public static final Bytes ZERO_DECIMAL = new Bytes(0L, 0L, 0L, 0L, false);

    public Bytes(BigInteger totalBits, boolean isBinaryUnit) {
        this.isBinaryUnit = isBinaryUnit;
        BigInteger[] totalBsAndRemainder = totalBits.divideAndRemainder(ByteFactor.X8);
        Tuple2<Long[], BigInteger[]> computeBytes = Bytes.standardizingBytes(isBinaryUnit, totalBsAndRemainder[0]);
        Long[] longs = (Long[])computeBytes._1;
        BigInteger[] bigIntegers = (BigInteger[])computeBytes._2;
        this.bit = totalBsAndRemainder[1].longValue();
        this.b = longs[0];
        this.kb = longs[1];
        this.mb = longs[2];
        this.gb = longs[3];
        this.tb = longs[4];
        this.pb = longs[5];
        this.eb = longs[6];
        this.zb = longs[7];
        this.yb = longs[8];
        this.bits = totalBits;
        this.bs = bigIntegers[0];
        this.kbs = bigIntegers[1];
        this.mbs = bigIntegers[2];
        this.gbs = bigIntegers[3];
        this.tbs = bigIntegers[4];
        this.pbs = bigIntegers[5];
        this.ebs = bigIntegers[6];
        this.zbs = bigIntegers[7];
        this.ybs = bigIntegers[8];
    }

    public Bytes(long yb, long zb, long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        this(Bytes.getTotalBits(yb, zb, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit), isBinaryUnit);
    }

    public Bytes(long zb, long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        this(0L, zb, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public Bytes(long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        this(0L, 0L, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public Bytes(long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        this(0L, 0L, 0L, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public Bytes(long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        this(0L, 0L, 0L, 0L, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public Bytes(long tb, long gb, long mb, long kb, long b, boolean isBinaryUnit) {
        this(0L, 0L, 0L, 0L, tb, gb, mb, kb, b, 0L, isBinaryUnit);
    }

    public Bytes(long gb, long mb, long kb, long b, boolean isBinaryUnit) {
        this(0L, 0L, 0L, 0L, 0L, gb, mb, kb, b, 0L, isBinaryUnit);
    }

    public static Bytes of(BigInteger totalBits, boolean isBinaryUnit) {
        Preconditions.checkNullNPE((Object)totalBits, (String[])Preconditions.args((String[])new String[]{"totalBits"}));
        return new Bytes(totalBits, isBinaryUnit);
    }

    public static Bytes of(long yb, long zb, long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        return new Bytes(yb, zb, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public static Bytes of(long zb, long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        return Bytes.of(0L, zb, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public static Bytes of(long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        return Bytes.of(0L, 0L, eb, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public static Bytes of(long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        return Bytes.of(0L, 0L, 0L, pb, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public static Bytes of(long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        return Bytes.of(0L, 0L, 0L, 0L, tb, gb, mb, kb, b, bit, isBinaryUnit);
    }

    public static Bytes of(long tb, long gb, long mb, long kb, long b, boolean isBinaryUnit) {
        return Bytes.of(0L, 0L, 0L, 0L, tb, gb, mb, kb, b, 0L, isBinaryUnit);
    }

    public static Bytes of(long gb, long mb, long kb, long b, boolean isBinaryUnit) {
        return Bytes.of(0L, 0L, 0L, 0L, 0L, gb, mb, kb, b, 0L, isBinaryUnit);
    }

    public static Bytes ofBits(BigInteger bits, boolean isBinaryUnit) {
        return Bytes.of(bits, isBinaryUnit);
    }

    public static Bytes ofBs(double bs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(bs, isBinaryUnit, 0), isBinaryUnit);
    }

    public static Bytes ofKBs(double kbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(kbs, isBinaryUnit, 1), isBinaryUnit);
    }

    public static Bytes ofMBs(double mbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(mbs, isBinaryUnit, 2), isBinaryUnit);
    }

    public static Bytes ofGBs(double gbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(gbs, isBinaryUnit, 3), isBinaryUnit);
    }

    public static Bytes ofTBs(double tbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(tbs, isBinaryUnit, 4), isBinaryUnit);
    }

    public static Bytes ofPBs(double pbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(pbs, isBinaryUnit, 5), isBinaryUnit);
    }

    public static Bytes ofEBs(double ebs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(ebs, isBinaryUnit, 6), isBinaryUnit);
    }

    public static Bytes ofZBs(double zbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(zbs, isBinaryUnit, 7), isBinaryUnit);
    }

    public static Bytes ofYBs(double ybs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(ybs, isBinaryUnit, 8), isBinaryUnit);
    }

    public static Bytes ofBs(BigDecimal bs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(bs, isBinaryUnit, 0), isBinaryUnit);
    }

    public static Bytes ofKBs(BigDecimal kbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(kbs, isBinaryUnit, 1), isBinaryUnit);
    }

    public static Bytes ofMBs(BigDecimal mbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(mbs, isBinaryUnit, 2), isBinaryUnit);
    }

    public static Bytes ofGBs(BigDecimal gbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(gbs, isBinaryUnit, 3), isBinaryUnit);
    }

    public static Bytes ofTBs(BigDecimal tbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(tbs, isBinaryUnit, 4), isBinaryUnit);
    }

    public static Bytes ofPBs(BigDecimal pbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(pbs, isBinaryUnit, 5), isBinaryUnit);
    }

    public static Bytes ofEBs(BigDecimal ebs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(ebs, isBinaryUnit, 6), isBinaryUnit);
    }

    public static Bytes ofZBs(BigDecimal zbs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(zbs, isBinaryUnit, 7), isBinaryUnit);
    }

    public static Bytes ofYBs(BigDecimal ybs, boolean isBinaryUnit) {
        return Bytes.of(Bytes.toBits(ybs, isBinaryUnit, 8), isBinaryUnit);
    }

    public Bytes plus(Bytes bytes) {
        Preconditions.checkNullNPE((Object)bytes, (String[])Preconditions.args((String[])new String[]{"bytes"}));
        return new Bytes(this.bits.add(bytes.bits), this.isBinaryUnit);
    }

    public Bytes minus(Bytes bytes) {
        Preconditions.checkNullNPE((Object)bytes, (String[])Preconditions.args((String[])new String[]{"bytes"}));
        return new Bytes(this.bits.subtract(bytes.bits), this.isBinaryUnit);
    }

    public Bytes plus(double amount, ByteUnit unit) {
        return this.plus(BigDecimal.valueOf(amount), unit);
    }

    public Bytes minus(double amount, ByteUnit unit) {
        return this.minus(BigDecimal.valueOf(amount), unit);
    }

    public Bytes plus(BigDecimal amount, ByteUnit unit) {
        if (unit instanceof ByteDecimalUnit || unit instanceof ByteBinaryUnit) {
            BigInteger bits = Bytes.toBits(amount, unit.isBinaryUnit(), unit.getIndex());
            return new Bytes(this.bits.add(bits), this.isBinaryUnit);
        }
        throw new UnexpectedParameterException("Unsupported unit: " + unit, new Object[0]);
    }

    public Bytes minus(BigDecimal amount, ByteUnit unit) {
        if (unit instanceof ByteDecimalUnit || unit instanceof ByteBinaryUnit) {
            BigInteger bits = Bytes.toBits(amount, unit.isBinaryUnit(), unit.getIndex());
            return new Bytes(this.bits.subtract(bits), this.isBinaryUnit);
        }
        throw new UnexpectedParameterException("Unsupported unit: " + unit, new Object[0]);
    }

    public Bytes toAnotherUnit() {
        return new Bytes(this.bits, !this.isBinaryUnit);
    }

    @Override
    public int compareTo(Bytes bytes) {
        Preconditions.checkNullNPE((Object)bytes, (String[])Preconditions.args((String[])new String[]{"bytes"}));
        return this.bits.compareTo(bytes.bits);
    }

    public boolean equals(Object bytes) {
        return bytes instanceof Bytes && this.compareTo((Bytes)bytes) == 0;
    }

    private static BigInteger getTotalBits(long yb, long zb, long eb, long pb, long tb, long gb, long mb, long kb, long b, long bit, boolean isBinaryUnit) {
        BigInteger totalBits = BigInteger.valueOf(bit);
        if (b != 0L) {
            totalBits = totalBits.add(Bytes.toBits(b, isBinaryUnit, 0));
        }
        if (kb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(kb, isBinaryUnit, 1));
        }
        if (mb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(mb, isBinaryUnit, 2));
        }
        if (gb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(gb, isBinaryUnit, 3));
        }
        if (tb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(tb, isBinaryUnit, 4));
        }
        if (pb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(pb, isBinaryUnit, 5));
        }
        if (eb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(eb, isBinaryUnit, 6));
        }
        if (zb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(zb, isBinaryUnit, 7));
        }
        if (yb != 0L) {
            totalBits = totalBits.add(Bytes.toBits(yb, isBinaryUnit, 8));
        }
        return totalBits;
    }

    private static BigInteger toBits(double bytes, boolean isBinaryUnit, int index) {
        return Bytes.toBits(BigDecimal.valueOf(bytes), isBinaryUnit, index);
    }

    private static BigInteger toBits(BigDecimal amount, boolean isBinaryUnit, int index) {
        Preconditions.checkNullNPE((Object)amount, (String[])Preconditions.args((String[])new String[]{"amount"}));
        if (index == -1) {
            return amount.toBigInteger();
        }
        return amount.multiply(new BigDecimal(ByteFactor.getCoef(isBinaryUnit, index))).multiply(new BigDecimal(ByteFactor.X8)).toBigInteger();
    }

    private static Tuple2<Long[], BigInteger[]> standardizingBytes(boolean isBinaryUnit, BigInteger totalBytes) {
        BigInteger factor = isBinaryUnit ? ByteFactor.X1024 : ByteFactor.X1000;
        Long[] ls = new Long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        BigInteger[] ints = new BigInteger[]{BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO, BigInteger.ZERO};
        ints[0] = totalBytes;
        if (ints[0] != null && !ints[0].equals(BigInteger.ZERO)) {
            BigInteger[] totalKBsAndRemainder = ints[0].divideAndRemainder(factor);
            ls[0] = totalKBsAndRemainder[1].longValue();
            ints[1] = totalKBsAndRemainder[0];
            if (!ints[1].equals(BigInteger.ZERO)) {
                BigInteger[] totalMBsAndRemainder = ints[1].divideAndRemainder(factor);
                ls[1] = totalMBsAndRemainder[1].longValue();
                ints[2] = totalMBsAndRemainder[0];
                if (!ints[2].equals(BigInteger.ZERO)) {
                    BigInteger[] totalGBsAndRemainder = ints[2].divideAndRemainder(factor);
                    ls[2] = totalGBsAndRemainder[1].longValue();
                    ints[3] = totalGBsAndRemainder[0];
                    if (!ints[3].equals(BigInteger.ZERO)) {
                        BigInteger[] totalTBsAndRemainder = ints[3].divideAndRemainder(factor);
                        ls[3] = totalTBsAndRemainder[1].longValue();
                        ints[4] = totalTBsAndRemainder[0];
                        if (!ints[4].equals(BigInteger.ZERO)) {
                            BigInteger[] totalPBsAndRemainder = ints[4].divideAndRemainder(factor);
                            ls[4] = totalPBsAndRemainder[1].longValue();
                            ints[5] = totalPBsAndRemainder[0];
                            if (!ints[5].equals(BigInteger.ZERO)) {
                                BigInteger[] totalEBsAndRemainder = ints[5].divideAndRemainder(factor);
                                ls[5] = totalEBsAndRemainder[1].longValue();
                                ints[6] = totalEBsAndRemainder[0];
                                if (!ints[6].equals(BigInteger.ZERO)) {
                                    BigInteger[] totalZBsAndRemainder = ints[6].divideAndRemainder(factor);
                                    ls[6] = totalZBsAndRemainder[1].longValue();
                                    ints[7] = totalZBsAndRemainder[0];
                                    if (!ints[7].equals(BigInteger.ZERO)) {
                                        BigInteger[] totalYBsAndRemainder = ints[7].divideAndRemainder(factor);
                                        ls[7] = totalYBsAndRemainder[1].longValue();
                                        ints[8] = totalYBsAndRemainder[0];
                                        ls[8] = ints[8].longValue();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return Tuple.of((Object)ls, (Object)ints);
    }

    public BigDecimal convertUnit(ByteUnit toUnit) {
        return this.convertUnit(toUnit.getIndex(), toUnit.isBinaryUnit());
    }

    public BigDecimal convertUnit(int unitIndex) {
        return this.convertUnit(unitIndex, this.isBinaryUnit);
    }

    public BigDecimal convertUnit(int unitIndex, boolean isBinaryUnit) {
        if (unitIndex == -1) {
            return new BigDecimal(this.bits);
        }
        BigInteger coef = ByteFactor.getCoef(isBinaryUnit, unitIndex);
        return Bytes.divideForConvertUnit(this.bits, coef);
    }

    public static BigDecimal convertUnit(ByteUnit fromUnit, ByteUnit toUnit, double amount) {
        return Bytes.convertUnit(fromUnit, toUnit, BigDecimal.valueOf(amount));
    }

    public static BigDecimal convertUnit(ByteUnit fromUnit, ByteUnit toUnit, BigDecimal amount) {
        Preconditions.checkArgument((!(fromUnit instanceof ByteDecimalUnit) && !(fromUnit instanceof ByteBinaryUnit) ? 1 : 0) != 0, (String)"Unsupported unit: ${\u2026}", (Object[])new Object[]{fromUnit});
        Preconditions.checkArgument((!(toUnit instanceof ByteDecimalUnit) && !(toUnit instanceof ByteBinaryUnit) ? 1 : 0) != 0, (String)"Unsupported unit: ${\u2026}", (Object[])new Object[]{toUnit});
        BigInteger fromBits = Bytes.toBits(amount, fromUnit.isBinaryUnit(), fromUnit.getIndex());
        int index = toUnit.getIndex();
        if (index == -1) {
            return new BigDecimal(fromBits);
        }
        BigInteger coef = ByteFactor.getCoef(toUnit.isBinaryUnit(), index);
        return Bytes.divideForConvertUnit(fromBits, coef);
    }

    private static BigDecimal divideForConvertUnit(BigInteger fromBits, BigInteger convertCoef) {
        return O.divide((Number)fromBits, (Number)ByteFactor.X8.multiply(convertCoef), (int)20, (boolean)false).stripTrailingZeros();
    }

    public static String formatBytes(long bytes, boolean isBinaryUnit) {
        return Bytes.formatBytes(BigInteger.valueOf(bytes), isBinaryUnit);
    }

    public static String formatBytes(BigInteger bytes, boolean isBinaryUnit) {
        Preconditions.checkNullNPE((Object)bytes, (String[])Preconditions.args((String[])new String[]{"bytes"}));
        if (bytes.compareTo(BigInteger.ZERO) < 0) {
            return "-" + Bytes.formatBytes(bytes.abs(), isBinaryUnit);
        }
        BigInteger coef1 = ByteFactor.getCoef(isBinaryUnit, 1);
        if (bytes.compareTo(coef1) < 0) {
            return bytes + ByteUnit.getUnitType(isBinaryUnit, 0);
        }
        DecimalFormat df = new DecimalFormat("0.0##");
        RoundingMode roundingMode = RoundingMode.HALF_UP;
        df.setRoundingMode(roundingMode);
        int scale = 3;
        BigInteger coef2 = ByteFactor.getCoef(isBinaryUnit, 2);
        if (bytes.compareTo(coef2) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef1, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 1);
        }
        BigInteger coef3 = ByteFactor.getCoef(isBinaryUnit, 3);
        if (bytes.compareTo(coef3) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef2, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 2);
        }
        BigInteger coef4 = ByteFactor.getCoef(isBinaryUnit, 4);
        if (bytes.compareTo(coef4) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef3, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 3);
        }
        BigInteger coef5 = ByteFactor.getCoef(isBinaryUnit, 5);
        if (bytes.compareTo(coef5) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef4, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 4);
        }
        BigInteger coef6 = ByteFactor.getCoef(isBinaryUnit, 6);
        if (bytes.compareTo(coef6) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef5, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 5);
        }
        BigInteger coef7 = ByteFactor.getCoef(isBinaryUnit, 7);
        if (bytes.compareTo(coef7) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef6, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 6);
        }
        BigInteger coef8 = ByteFactor.getCoef(isBinaryUnit, 8);
        if (bytes.compareTo(coef8) < 0) {
            return df.format(O.divide((Number)bytes, (Number)coef7, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 7);
        }
        return df.format(O.divide((Number)bytes, (Number)coef8, (int)scale, (RoundingMode)roundingMode)) + ByteUnit.getUnitType(isBinaryUnit, 8);
    }

    public static String formatBits(long bits, boolean isBinaryUnit) {
        return Bytes.formatBits(BigInteger.valueOf(bits), isBinaryUnit);
    }

    public static String formatBits(BigInteger bits, boolean isBinaryUnit) {
        Preconditions.checkNullNPE((Object)bits, (String[])Preconditions.args((String[])new String[]{"bits"}));
        if (bits.compareTo(BigInteger.ZERO) < 0) {
            return "-" + Bytes.formatBits(bits.abs(), isBinaryUnit);
        }
        if (bits.compareTo(ByteFactor.X8) < 0) {
            return bits + ByteUnit.getUnitType(isBinaryUnit, -1);
        }
        return Bytes.formatBytes(bits.divide(ByteFactor.X8), isBinaryUnit);
    }

    public String format() {
        return Bytes.formatBits(this.bits, this.isBinaryUnit);
    }

    public String toString() {
        String ybStr = ByteUnit.getUnitType(this.isBinaryUnit, 8);
        String zbStr = ByteUnit.getUnitType(this.isBinaryUnit, 7);
        String ebStr = ByteUnit.getUnitType(this.isBinaryUnit, 6);
        String pbStr = ByteUnit.getUnitType(this.isBinaryUnit, 5);
        String tbStr = ByteUnit.getUnitType(this.isBinaryUnit, 4);
        String gbStr = ByteUnit.getUnitType(this.isBinaryUnit, 3);
        String mbStr = ByteUnit.getUnitType(this.isBinaryUnit, 2);
        String kbStr = ByteUnit.getUnitType(this.isBinaryUnit, 1);
        String bStr = ByteUnit.getUnitType(this.isBinaryUnit, 0);
        String bitStr = ByteUnit.getUnitType(this.isBinaryUnit, -1);
        String str = "";
        str = this.yb != 0L ? str + this.yb + ybStr + "`" + this.zb + zbStr + "`" + this.eb + ebStr + "`" + this.pb + pbStr + "`" + this.tb + tbStr + "`" + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.zb != 0L ? str + this.zb + zbStr + "`" + this.eb + ebStr + "`" + this.pb + pbStr + "`" + this.tb + tbStr + "`" + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.eb != 0L ? str + this.eb + ebStr + "`" + this.pb + pbStr + "`" + this.tb + tbStr + "`" + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.pb != 0L ? str + this.pb + pbStr + "`" + this.tb + tbStr + "`" + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.tb != 0L ? str + this.tb + tbStr + "`" + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.gb != 0L ? str + this.gb + gbStr + "`" + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.mb != 0L ? str + this.mb + mbStr + "`" + this.kb + kbStr + "`" + this.b + bStr + "`" : (this.kb != 0L ? str + this.kb + kbStr + "`" + this.b + bStr + "`" : str + this.b + bStr + "`")))))));
        if (this.bit != 0L) {
            str = str + this.bit + bitStr;
        }
        if (str.endsWith("`")) {
            str = str.substring(0, str.length() - 1);
        }
        return "\u5f53\u524d\u91c7\u7528[" + (this.isBinaryUnit ? "\u4e8c\u8fdb\u5236" : "\u5341\u8fdb\u5236") + "]\u5b57\u8282\u5355\u4f4d\u8ba1\u7b97\uff0c\u5b57\u8282\u5927\u5c0f\u4e3a\uff1a[" + str + "]";
    }

    public String toSimpleString() {
        String ybStr = ByteUnit.getUnitType(this.isBinaryUnit, 8);
        String zbStr = ByteUnit.getUnitType(this.isBinaryUnit, 7);
        String ebStr = ByteUnit.getUnitType(this.isBinaryUnit, 6);
        String pbStr = ByteUnit.getUnitType(this.isBinaryUnit, 5);
        String tbStr = ByteUnit.getUnitType(this.isBinaryUnit, 4);
        String gbStr = ByteUnit.getUnitType(this.isBinaryUnit, 3);
        String mbStr = ByteUnit.getUnitType(this.isBinaryUnit, 2);
        String kbStr = ByteUnit.getUnitType(this.isBinaryUnit, 1);
        String bStr = ByteUnit.getUnitType(this.isBinaryUnit, 0);
        String bitStr = ByteUnit.getUnitType(this.isBinaryUnit, -1);
        if (this.yb == 0L && this.zb == 0L && this.eb == 0L && this.pb == 0L && this.tb == 0L && this.gb == 0L && this.mb == 0L && this.kb == 0L && this.b == 0L && this.bit == 0L) {
            return this.bit + bitStr;
        }
        String str = "";
        if (this.yb != 0L) {
            str = str + this.yb + ybStr + "`";
        }
        if (this.zb != 0L) {
            str = str + this.zb + zbStr + "`";
        }
        if (this.eb != 0L) {
            str = str + this.eb + ebStr + "`";
        }
        if (this.pb != 0L) {
            str = str + this.pb + pbStr + "`";
        }
        if (this.tb != 0L) {
            str = str + this.tb + tbStr + "`";
        }
        if (this.gb != 0L) {
            str = str + this.gb + gbStr + "`";
        }
        if (this.mb != 0L) {
            str = str + this.mb + mbStr + "`";
        }
        if (this.kb != 0L) {
            str = str + this.kb + kbStr + "`";
        }
        if (this.b != 0L) {
            str = str + this.b + bStr + "`";
        }
        if (this.bit != 0L) {
            str = str + this.bit + bitStr;
        }
        if (str.endsWith("`")) {
            str = str.substring(0, str.length() - 1);
        }
        return "\u5f53\u524d\u91c7\u7528[" + (this.isBinaryUnit ? "\u4e8c\u8fdb\u5236" : "\u5341\u8fdb\u5236") + "]\u5b57\u8282\u5355\u4f4d\u8ba1\u7b97\uff0c\u5b57\u8282\u5927\u5c0f\u4e3a\uff1a[" + str + "]";
    }

    public String toFullString() {
        String ybStr = ByteUnit.getUnitType(this.isBinaryUnit, 8) + "\n";
        String zbStr = ByteUnit.getUnitType(this.isBinaryUnit, 7) + "\n";
        String ebStr = ByteUnit.getUnitType(this.isBinaryUnit, 6) + "\n";
        String pbStr = ByteUnit.getUnitType(this.isBinaryUnit, 5) + "\n";
        String tbStr = ByteUnit.getUnitType(this.isBinaryUnit, 4) + "\n";
        String gbStr = ByteUnit.getUnitType(this.isBinaryUnit, 3) + "\n";
        String mbStr = ByteUnit.getUnitType(this.isBinaryUnit, 2) + "\n";
        String kbStr = ByteUnit.getUnitType(this.isBinaryUnit, 1) + "\n";
        String bStr = ByteUnit.getUnitType(this.isBinaryUnit, 0) + "\n";
        String bitStr = ByteUnit.getUnitType(this.isBinaryUnit, -1) + "\n";
        String equivalentlyStr = "\n\u76f8\u5f53\u4e8e\uff1a\n";
        return this + equivalentlyStr + "\u25cf " + this.ybs + ybStr + "\u25cf " + this.zbs + zbStr + "\u25cf " + this.ebs + ebStr + "\u25cf " + this.pbs + pbStr + "\u25cf " + this.tbs + tbStr + "\u25cf " + this.gbs + gbStr + "\u25cf " + this.mbs + mbStr + "\u25cf " + this.kbs + kbStr + "\u25cf " + this.bs + bStr + "\u25cf " + this.bits + bitStr;
    }

    public BigInteger getBits() {
        return this.bits;
    }

    public BigInteger getBs() {
        return this.bs;
    }

    public BigInteger getKbs() {
        return this.kbs;
    }

    public BigInteger getMbs() {
        return this.mbs;
    }

    public BigInteger getGbs() {
        return this.gbs;
    }

    public BigInteger getTbs() {
        return this.tbs;
    }

    public BigInteger getPbs() {
        return this.pbs;
    }

    public BigInteger getEbs() {
        return this.ebs;
    }

    public BigInteger getZbs() {
        return this.zbs;
    }

    public BigInteger getYbs() {
        return this.ybs;
    }
}

