/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.tcf.Close;
import com.iofairy.top.S;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Nets {
    public static boolean telnet(String ip, int port) {
        return Nets.telnet(ip, port, 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean telnet(String ip, int port, int timeout) {
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(ip, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            Close.close((AutoCloseable)socket, (boolean)false);
        }
    }

    public static String getLocalIPv4() {
        try {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static List<InterfaceAddress> getLocalIPv6s() {
        String localIPv4 = Nets.getLocalIPv4();
        if (S.isEmpty((CharSequence)localIPv4)) {
            return new ArrayList<InterfaceAddress>();
        }
        try {
            Enumeration<NetworkInterface> niEnum = NetworkInterface.getNetworkInterfaces();
            while (niEnum.hasMoreElements()) {
                NetworkInterface ni = niEnum.nextElement();
                if (!ni.isUp()) continue;
                List<InterfaceAddress> interfaceAddresses = ni.getInterfaceAddresses();
                String ipv4 = null;
                ArrayList<InterfaceAddress> ipv6s = new ArrayList<InterfaceAddress>();
                for (InterfaceAddress ia : interfaceAddresses) {
                    InetAddress address;
                    if (ia == null || (address = ia.getAddress()) == null) continue;
                    if (address instanceof Inet4Address) {
                        ipv4 = address.getHostAddress();
                        continue;
                    }
                    ipv6s.add(ia);
                }
                if (!localIPv4.equals(ipv4)) continue;
                return ipv6s;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<InterfaceAddress>();
    }

    public static String getLinkLocalIPv6() {
        String ipv6 = "";
        List<InterfaceAddress> interfaceAddresses = Nets.getLocalIPv6s();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            InetAddress address = interfaceAddress.getAddress();
            if (!address.isLinkLocalAddress()) continue;
            ipv6 = address.getHostAddress().split("%")[0];
            break;
        }
        return ipv6;
    }

    public static String getPublicIPv6() {
        String ipv6 = "";
        List<InterfaceAddress> interfaceAddresses = Nets.getLocalIPv6s();
        for (InterfaceAddress interfaceAddress : interfaceAddresses) {
            InetAddress address = interfaceAddress.getAddress();
            if (address.isLinkLocalAddress()) continue;
            ipv6 = address.getHostAddress();
            break;
        }
        return ipv6;
    }
}

