/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.os.OS;
import com.iofairy.si.SI;
import com.iofairy.top.O;
import com.iofairy.top.S;
import com.iofairy.validator.Preconditions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class Numbers {
    public static double[] round(float[] floats) {
        return Numbers.round(floats, 2, RoundingMode.HALF_UP);
    }

    public static double[] round(float[] floats, int newScale) {
        return Numbers.round(floats, newScale, RoundingMode.HALF_UP);
    }

    public static double[] round(float[] floats, int newScale, RoundingMode roundingMode) {
        if (floats == null) {
            return null;
        }
        double[] ds = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            ds[i] = Numbers.round(Float.valueOf(floats[i]), newScale, roundingMode);
        }
        return ds;
    }

    public static double[] round(double[] doubles) {
        return Numbers.round(doubles, 2, RoundingMode.HALF_UP);
    }

    public static double[] round(double[] doubles, int newScale) {
        return Numbers.round(doubles, newScale, RoundingMode.HALF_UP);
    }

    public static double[] round(double[] doubles, int newScale, RoundingMode roundingMode) {
        if (doubles == null) {
            return null;
        }
        double[] ds = new double[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            ds[i] = Numbers.round(doubles[i], newScale, roundingMode);
        }
        return ds;
    }

    public static Double[] round(Number[] numbers) {
        return Numbers.round(numbers, 2, RoundingMode.HALF_UP);
    }

    public static Double[] round(Number[] numbers, int newScale) {
        return Numbers.round(numbers, newScale, RoundingMode.HALF_UP);
    }

    public static Double[] round(Number[] numbers, int newScale, RoundingMode roundingMode) {
        if (numbers == null) {
            return null;
        }
        Double[] ds = new Double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            ds[i] = Numbers.round(numbers[i], newScale, roundingMode);
        }
        return ds;
    }

    public static Double[] round(Collection<? extends Number> numbers) {
        return Numbers.round(numbers, 2, RoundingMode.HALF_UP);
    }

    public static Double[] round(Collection<? extends Number> numbers, int newScale) {
        return Numbers.round(numbers, newScale, RoundingMode.HALF_UP);
    }

    public static Double[] round(Collection<? extends Number> numbers, int newScale, RoundingMode roundingMode) {
        if (numbers == null) {
            return null;
        }
        if (numbers.isEmpty()) {
            return new Double[0];
        }
        Double[] ds = new Double[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            ds[i] = Numbers.round(iterator.next(), newScale, roundingMode);
            ++i;
        }
        return ds;
    }

    public static Double round(Number number) {
        return Numbers.round(number, 2, RoundingMode.HALF_UP);
    }

    public static Double round(Number number, int newScale) {
        return Numbers.round(number, newScale, RoundingMode.HALF_UP);
    }

    public static Double round(Number number, int newScale, RoundingMode roundingMode) {
        if (number == null) {
            return null;
        }
        if (O.isInfinityOrNaN((Number)number)) {
            return number.doubleValue();
        }
        if (O.isFloat((Number)number)) {
            return Numbers.round(O.toBigDecimal((Number)number), newScale, roundingMode);
        }
        return newScale < 0 ? Numbers.round(O.toBigDecimal((Number)number), newScale, roundingMode).doubleValue() : number.doubleValue();
    }

    public static Double round(BigDecimal bigDecimal, int newScale, RoundingMode roundingMode) {
        if (bigDecimal == null) {
            return null;
        }
        return bigDecimal.setScale(newScale, roundingMode).doubleValue();
    }

    public static Double[] doubles(Number ... numbers) {
        if (numbers == null) {
            return null;
        }
        Double[] ds = new Double[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            Number number = numbers[i];
            ds[i] = number == null ? null : Double.valueOf(number.doubleValue());
        }
        return ds;
    }

    public static Double[] doubles(Collection<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        if (numbers.isEmpty()) {
            return new Double[0];
        }
        Double[] ds = new Double[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Number number = iterator.next();
            ds[i] = number == null ? null : Double.valueOf(number.doubleValue());
            ++i;
        }
        return ds;
    }

    public static double[] doubles(float[] floats) {
        if (floats == null) {
            return null;
        }
        double[] ds = new double[floats.length];
        for (int i = 0; i < floats.length; ++i) {
            ds[i] = floats[i];
        }
        return ds;
    }

    public static Float[] floats(Number ... numbers) {
        if (numbers == null) {
            return null;
        }
        Float[] fs = new Float[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            Number number = numbers[i];
            fs[i] = number == null ? null : Float.valueOf(number.floatValue());
        }
        return fs;
    }

    public static Float[] floats(Collection<? extends Number> numbers) {
        if (numbers == null) {
            return null;
        }
        if (numbers.isEmpty()) {
            return new Float[0];
        }
        Float[] fs = new Float[numbers.size()];
        Iterator<? extends Number> iterator = numbers.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            Number number = iterator.next();
            fs[i] = number == null ? null : Float.valueOf(number.floatValue());
            ++i;
        }
        return fs;
    }

    public static float[] floats(double[] doubles) {
        if (doubles == null) {
            return null;
        }
        float[] fs = new float[doubles.length];
        for (int i = 0; i < doubles.length; ++i) {
            fs[i] = (float)doubles[i];
        }
        return fs;
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor, int scale, RoundingMode roundingMode, boolean alwaysSetScale) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{dividend, divisor}), (String[])Preconditions.args((String[])new String[]{"dividend", "divisor"}));
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        BigDecimal bdDividend = O.toBigDecimal((Number)dividend);
        BigDecimal bdDivisor = O.toBigDecimal((Number)divisor);
        if (alwaysSetScale) {
            return bdDividend.divide(bdDivisor, scale, roundingMode);
        }
        try {
            return bdDividend.divide(bdDivisor);
        }
        catch (ArithmeticException e) {
            if (e.getMessage() != null && e.getMessage().contains("Non-terminating decimal expansion")) {
                return bdDividend.divide(bdDivisor, scale, roundingMode);
            }
            throw e;
        }
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor, int scale, boolean alwaysSetScale) {
        return Numbers.divide(dividend, divisor, scale, RoundingMode.HALF_UP, alwaysSetScale);
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor, boolean alwaysSetScale) {
        return Numbers.divide(dividend, divisor, 6, RoundingMode.HALF_UP, alwaysSetScale);
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor, int scale, RoundingMode roundingMode) {
        return Numbers.divide(dividend, divisor, scale, roundingMode, true);
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor, int scale) {
        return Numbers.divide(dividend, divisor, scale, RoundingMode.HALF_UP);
    }

    @Deprecated
    public static BigDecimal divide(Number dividend, Number divisor) {
        return Numbers.divide(dividend, divisor, 6, RoundingMode.HALF_UP);
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor, int scale, RoundingMode roundingMode, boolean alwaysSetScale) {
        Preconditions.checkHasNullNPE((Object[])Preconditions.args((Object[])new Object[]{dividend, divisor}), (String[])Preconditions.args((String[])new String[]{"dividend", "divisor"}));
        if (roundingMode == null) {
            roundingMode = RoundingMode.HALF_UP;
        }
        if (O.isInteger((Number)dividend) && O.isInteger((Number)divisor)) {
            return new BigInteger(dividend.toString()).divide(new BigInteger(divisor.toString()));
        }
        if (dividend instanceof BigInteger || divisor instanceof BigInteger || dividend instanceof BigDecimal || divisor instanceof BigDecimal) {
            return Numbers.divide(dividend, divisor, scale, roundingMode, alwaysSetScale);
        }
        double quotient = dividend.doubleValue() / divisor.doubleValue();
        if (Double.isNaN(quotient) || Double.isInfinite(quotient)) {
            return quotient;
        }
        return new BigDecimal(quotient).setScale(scale, roundingMode).doubleValue();
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor, int scale, boolean alwaysSetScale) {
        return Numbers.dividePower(dividend, divisor, scale, RoundingMode.HALF_UP, alwaysSetScale);
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor, boolean alwaysSetScale) {
        return Numbers.dividePower(dividend, divisor, 6, RoundingMode.HALF_UP, alwaysSetScale);
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor, int scale, RoundingMode roundingMode) {
        return Numbers.dividePower(dividend, divisor, scale, roundingMode, true);
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor, int scale) {
        return Numbers.dividePower(dividend, divisor, scale, RoundingMode.HALF_UP);
    }

    @Deprecated
    public static Number dividePower(Number dividend, Number divisor) {
        return Numbers.dividePower(dividend, divisor, 6, RoundingMode.HALF_UP);
    }

    public static BigInteger toBigInteger(BigDecimal bigDecimal, RoundingMode roundingMode) {
        Preconditions.checkNullNPE((Object)bigDecimal, (String[])Preconditions.args((String[])new String[]{"bigDecimal"}));
        if (roundingMode == null) {
            roundingMode = RoundingMode.DOWN;
        }
        return bigDecimal.setScale(0, roundingMode).toBigInteger();
    }

    public static BigInteger toBigInteger(BigDecimal bigDecimal) {
        Preconditions.checkNullNPE((Object)bigDecimal, (String[])Preconditions.args((String[])new String[]{"bigDecimal"}));
        return bigDecimal.toBigInteger();
    }

    public static long longValue(BigDecimal bigDecimal, RoundingMode roundingMode) {
        Preconditions.checkNullNPE((Object)bigDecimal, (String[])Preconditions.args((String[])new String[]{"bigDecimal"}));
        if (roundingMode == null) {
            roundingMode = RoundingMode.DOWN;
        }
        return bigDecimal.setScale(0, roundingMode).longValue();
    }

    public static long longValue(BigDecimal bigDecimal) {
        Preconditions.checkNullNPE((Object)bigDecimal, (String[])Preconditions.args((String[])new String[]{"bigDecimal"}));
        return bigDecimal.longValue();
    }

    public static int randomInt(int digits) {
        if (digits <= 0 || digits > 9) {
            return 0;
        }
        int pow = (int)Math.pow(10.0, digits - 1);
        return new Random().nextInt(9 * pow) + pow;
    }

    public static double log(double base, double antilogarithm) {
        return Math.log(antilogarithm) / Math.log(base);
    }

    public static String radixConversion(String numberStr, int fromRadix, int toRadix) {
        return Numbers.radixConversion(numberStr, fromRadix, toRadix, true);
    }

    public static String radixConversion(String numberStr, int fromRadix, int toRadix, boolean paddingZero) {
        Preconditions.checkArgument((fromRadix > 36 || fromRadix < 2 ? 1 : 0) != 0, (String)"The parameter `fromRadix` must be in [2, 36], currently is [${fromRadix}]. ", (Object[])new Object[]{fromRadix});
        Preconditions.checkArgument((toRadix > 36 || toRadix < 2 ? 1 : 0) != 0, (String)"The parameter `toRadix` must be in [2, 36], currently is [${toRadix}]. ", (Object[])new Object[]{toRadix});
        Preconditions.checkBlank((CharSequence)numberStr, (String[])Preconditions.args((String[])new String[]{"numberStr"}));
        if (fromRadix == toRadix) {
            return numberStr;
        }
        BigInteger bigInteger = null;
        try {
            bigInteger = new BigInteger(numberStr, fromRadix);
        }
        catch (NumberFormatException e) {
            String errorMsg = OS.IS_ZH_LANG ? SI.$((CharSequence)"\u5728${fromRadix}\u8fdb\u5236\u4e0b\uff0c\u5b57\u7b26\u4e32\u3010${numberStr}\u3011\u65e0\u6cd5\u8f6c\u6210\u6570\u5b57\uff01", (Object[])new Object[]{fromRadix, numberStr}) : SI.$((CharSequence)"The [${numberStr}] can't be converted to a number in base [${fromRadix}]. ", (Object[])new Object[]{numberStr, fromRadix});
            throw new NumberFormatException(errorMsg);
        }
        String targetNumberStr = bigInteger.toString(toRadix);
        double log = Numbers.log(toRadix, fromRadix);
        if (paddingZero && log % 1.0 == 0.0) {
            boolean negativeOrNot = numberStr.charAt(0) == '-';
            boolean positiveOrNot = numberStr.charAt(0) == '+';
            int targetBits = (negativeOrNot || positiveOrNot ? numberStr.length() - 1 : numberStr.length()) * (int)log;
            if (negativeOrNot) {
                return "-" + S.padLeftChars((CharSequence)targetNumberStr.substring(1), (char)'0', (int)targetBits);
            }
            return S.padLeftChars((CharSequence)targetNumberStr, (char)'0', (int)targetBits);
        }
        return targetNumberStr;
    }
}

