/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.util;

import com.iofairy.except.UnexpectedParameterException;
import com.iofairy.os.OS;
import com.iofairy.range.IntervalType;
import com.iofairy.range.Range;
import com.iofairy.tuple.Tuple;
import com.iofairy.tuple.Tuple2;
import com.iofairy.validator.Preconditions;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;

@Deprecated
public class Ranges {
    public static List<Range<Long>> split(long beginIndex, long endIndex, int splitCount, float skewRatio) {
        long dataCount = endIndex - beginIndex;
        Preconditions.checkCondition((dataCount < (long)splitCount ? 1 : 0) != 0, (String)"(`endIndex` - `beginIndex`) must be \u2265 `splitCount`! ", (Object[])new Object[0]);
        return Ranges.split((Range<Long>)Range.closedOpen((Comparable)Long.valueOf(beginIndex), (Comparable)Long.valueOf(endIndex)), splitCount, skewRatio);
    }

    public static List<Range<Long>> split(Range<Long> range, int splitCount, float skewRatio) {
        Preconditions.checkNullNPE(range, (String[])Preconditions.args((String[])new String[]{"range"}));
        Preconditions.checkCondition((!range.intervalType.isHalfOpen() ? 1 : 0) != 0, (String)"The `range` must be half open interval! ", (Object[])new Object[0]);
        Preconditions.checkCondition((boolean)range.hasInfinity, (String)"The `range` can't be an infinite interval! ", (Object[])new Object[0]);
        long dataCount = (Long)range.end - (Long)range.start;
        Preconditions.checkCondition((splitCount < 2 ? 1 : 0) != 0, (String)"Parameter `splitCount` must \u2265 2! ", (Object[])new Object[0]);
        Preconditions.checkCondition((dataCount < (long)splitCount ? 1 : 0) != 0, (String)"(`range.end` - `range.start`) must be \u2265 `splitCount`! ", (Object[])new Object[0]);
        Preconditions.checkOutOfBounds((skewRatio <= -1.0f || skewRatio >= 1.0f ? 1 : 0) != 0, (Number)Float.valueOf(skewRatio), (String)(OS.IS_ZH_LANG ? "\u53c2\u6570`skewRatio`\u7684\u53d6\u503c\u8303\u56f4\u4e3a\uff1a(-1, 1)\u3002" : "Parameter `skewRatio` must be in (-1, 1)! "), (Object[])new Object[0]);
        double ratioSum = IntStream.range(0, splitCount).boxed().mapToDouble(i -> Math.pow(1.0f + skewRatio, i.intValue())).sum();
        ratioSum = new BigDecimal(ratioSum).setScale(4, RoundingMode.DOWN).doubleValue();
        ArrayList<Range<Long>> rangeList = new ArrayList<Range<Long>>();
        float floatFirstSize = new BigDecimal((double)dataCount / ratioSum).setScale(4, RoundingMode.DOWN).floatValue();
        long firstSize = new BigDecimal(floatFirstSize).setScale(0, RoundingMode.HALF_UP).longValue();
        rangeList.add(Range.of((Comparable)((Long)range.start), (Comparable)Long.valueOf(firstSize + (Long)range.start), (IntervalType)range.intervalType));
        for (int i2 = 1; i2 < splitCount; ++i2) {
            Range preRange = (Range)rangeList.get(i2 - 1);
            long lineSize = new BigDecimal((double)floatFirstSize * Math.pow(1.0f + skewRatio, i2)).setScale(0, RoundingMode.HALF_UP).longValue();
            rangeList.add((Range<Long>)Range.of((Comparable)((Long)preRange.end), (Comparable)Long.valueOf(i2 < splitCount - 1 ? (Long)preRange.end + lineSize : (Long)range.end), (IntervalType)range.intervalType));
        }
        return rangeList;
    }

    @Deprecated
    public static List<Tuple2<Long, Long>> divideRange(long beginIndex, long endIndex, int divideCount, float skewRatio) {
        if (divideCount < 2) {
            throw new UnexpectedParameterException("parameter `divideCount` must \u2265 2!", new Object[0]);
        }
        long dataCount = endIndex - beginIndex;
        if (dataCount < (long)divideCount) {
            throw new UnexpectedParameterException("(`endIndex` - `beginIndex`) must be \u2265 `divideCount`!", new Object[0]);
        }
        if (skewRatio <= -1.0f || skewRatio >= 1.0f) {
            throw new UnexpectedParameterException("parameter `skewRatio` must be in (-1, 1)!", new Object[0]);
        }
        double ratioSum = IntStream.range(0, divideCount).boxed().mapToDouble(i -> Math.pow(1.0f + skewRatio, i.intValue())).sum();
        ratioSum = new BigDecimal(ratioSum).setScale(4, RoundingMode.DOWN).doubleValue();
        ArrayList<Tuple2<Long, Long>> rangeList = new ArrayList<Tuple2<Long, Long>>();
        float floatFirstSize = new BigDecimal((double)dataCount / ratioSum).setScale(4, RoundingMode.DOWN).floatValue();
        long firstSize = new BigDecimal(floatFirstSize).setScale(0, RoundingMode.HALF_UP).longValue();
        rangeList.add(Tuple.of((Object)beginIndex, (Object)(firstSize + beginIndex)).alias(new String[]{"beginInclusive", "endExclusive"}));
        for (int i2 = 1; i2 < divideCount; ++i2) {
            Tuple2 preRange = (Tuple2)rangeList.get(i2 - 1);
            long lineSize = new BigDecimal((double)floatFirstSize * Math.pow(1.0f + skewRatio, i2)).setScale(0, RoundingMode.HALF_UP).longValue();
            rangeList.add((Tuple2<Long, Long>)Tuple.of((Object)((Long)preRange._2), (Object)(i2 < divideCount - 1 ? (Long)preRange._2 + lineSize : endIndex)).alias(new String[]{"beginInclusive", "endExclusive"}));
        }
        return rangeList;
    }
}

