/*
 * Decompiled with CFR 0.152.
 */
package com.iofairy.falcon.zip;

import com.iofairy.falcon.zip.ArchiveType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum ArchiveFormat {
    A(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".a", "Unix Archiver"),
    AR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".ar", "Unix Archiver"),
    CPIO(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".cpio", "cpio"),
    SHAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".shar", "Shell archive"),
    LBR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".LBR", ".LBR"),
    MAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".mar", "Mozilla ARchive"),
    SBX(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".sbx", "SeqBox"),
    TAR(EnumSet.of(ArchiveType.ARCHIVING_ONLY), ".tar", "Tape archive. TAR is used to bundle multiple files into a single archive. "),
    BROTLI(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".br", "Brotli"),
    BZIP2(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".bz2", "bzip2"),
    GZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".gz", "gzip"),
    LZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lz", "lzip"),
    LZ4(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lz4", "LZ4"),
    LZMA(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lzma", "lzma"),
    LZOP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".lzo", "lzop"),
    RZIP(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".rz", "rzip"),
    SZ(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".sz", "The Snappy uses either 'framing' or 'framing2'"),
    SNAPPY(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".snappy", "The snappy in Java"),
    XZ(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".xz", "xz"),
    Z_PACK(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".z", "pack"),
    Z_COMPRESS(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".Z", "compress"),
    ZSTD(EnumSet.of(ArchiveType.COMPRESSION_ONLY), ".zst", "Zstandard"),
    SEVEN_ZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".7z", "7z"),
    S7Z(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".s7z", "7zX"),
    ACE(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".ace", "ACE"),
    ARJ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".arj", "ARJ"),
    RAR(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".rar", "RAR supports data compression, error correction and file spanning. "),
    TAR_GZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.gz", "tar with gzip"),
    TGZ(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".tgz", "tar with gzip or Slackware Package(based on tar with gzip)"),
    TAZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".taz", "tar with gzip"),
    TAR_Z(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.z", "tar with compress (.tar.Z)"),
    TZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tz", "tar with compress (.tZ)"),
    TAR_BZ2(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.bz2", "tar with bzip2"),
    TBZ2(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tbz2", "tar with bzip2"),
    TAR_LZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.lz", "tar with lzip"),
    TLZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tlz", "tar with lzip"),
    TAR_XZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.xz", "tar with xz"),
    TXZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".txz", "tar with xz"),
    TAR_ZST(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.zst", "tar with Zstandard"),
    TZST(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tzst", "tar with Zstandard"),
    TAR_SZ(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.sz", "tar with Snappy"),
    TAR_SNAPPY(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.snappy", "tar with Snappy"),
    TAR_LZMA(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".tar.lzma", "tar with lzma"),
    ZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".zip", "ZIP"),
    ZZIP(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".zz", "Zzip"),
    UC_II(EnumSet.of(ArchiveType.MULTI_FUNCTION), ".uc", "UltraCompressor II (UC2) is a 1990s-era compression and archiving program for the PC platform (DOS, Windows, OS/2, DesqView) which claimed to be both faster and more compact than other compression systems. It had special support for OS/2 extended attributes. \nUltraCompressor 2.3 was developed to act as an alternative to the then popular PKZIP application. The main feature of the application is its ability to create large archives. This means that compressed archives with the UC2 file extension can hold almost 1 million files. "),
    DEB(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".deb", "Debian package (deb)"),
    PKG(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".pkg", "Macintosh Installer"),
    MPKG(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".mpkg", "Macintosh Installer"),
    RPM(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".rpm", "RPM Package Manager (RPM)"),
    MSI(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".msi", "Windows Installer (also MSI)"),
    JAR(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".jar", "Java Archive (JAR)"),
    WAR(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".war", "Web Application archive (Java-based web app)"),
    IPA(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".ipa", "iOS and iPadOS application package"),
    APK(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apk", "Android application package"),
    XAPK(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".xapk", "Android application package"),
    APKS(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apks", "Android application package"),
    APKM(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".apkm", "Android application package"),
    CRX(EnumSet.of(ArchiveType.SOFTWARE_PACKAGING, ArchiveType.MULTI_FUNCTION), ".crx", "Google Chrome extension package"),
    DMG(EnumSet.of(ArchiveType.DISK_IMAGE, ArchiveType.MULTI_FUNCTION), ".dmg", "Apple Disk Image"),
    ISO(EnumSet.of(ArchiveType.DISK_IMAGE, ArchiveType.ARCHIVING_ONLY), ".iso", "ISO-9660 image"),
    WIM(EnumSet.of(ArchiveType.DISK_IMAGE, ArchiveType.MULTI_FUNCTION), ".wim", "Windows Image. File-based disk image format developed to deploy Microsoft Windows. ");

    public final EnumSet<ArchiveType> archiveTypes;
    public final String extName;
    public final String description;
    static final Map<String, ArchiveFormat> SA_MAP;
    public static final ArchiveFormat[] MIXED_FORMATS;
    public static final ArchiveFormat[] MULTI_EXTS_FORMATS;
    static final Map<ArchiveFormat, ArchiveFormat> CONSISTENT_FORMAT1;
    static final Map<ArchiveFormat, ArchiveFormat> CONSISTENT_FORMAT2;

    private ArchiveFormat(EnumSet<ArchiveType> archiveTypes, String extName, String description) {
        this.archiveTypes = archiveTypes;
        this.extName = extName;
        this.description = description;
    }

    public static ArchiveFormat of(String extName) {
        return ArchiveFormat.of(extName, false);
    }

    public static ArchiveFormat of(String extName, boolean isUnionType) {
        ArchiveFormat consistentFormat;
        if (extName == null) {
            return null;
        }
        if (!extName.startsWith(".")) {
            extName = "." + extName;
        }
        String lowerExtName = extName.toLowerCase();
        if (isUnionType && (consistentFormat = CONSISTENT_FORMAT2.get((Object)SA_MAP.get(lowerExtName))) != null) {
            return consistentFormat;
        }
        return SA_MAP.get(extName.equals(".z") || extName.equals(".Z") ? extName : lowerExtName);
    }

    public boolean isMixedFormat() {
        return ArchiveFormat.isMixedFormat(this);
    }

    public boolean isMultiExtsFormat() {
        return ArchiveFormat.isMultiExtsFormat(this);
    }

    public static boolean isMixedFormat(ArchiveFormat archiveFormat) {
        return Arrays.asList(MIXED_FORMATS).contains((Object)archiveFormat);
    }

    public static boolean isMultiExtsFormat(ArchiveFormat archiveFormat) {
        return Arrays.asList(MULTI_EXTS_FORMATS).contains((Object)archiveFormat);
    }

    static {
        SA_MAP = new HashMap<String, ArchiveFormat>();
        MIXED_FORMATS = new ArchiveFormat[]{TAR_GZ, TGZ, TAZ, TAR_Z, TZ, TAR_BZ2, TBZ2, TAR_LZ, TLZ, TAR_XZ, TXZ, TAR_ZST, TZST, TAR_SZ, TAR_SNAPPY, TAR_LZMA};
        MULTI_EXTS_FORMATS = new ArchiveFormat[]{TAR_GZ, TAR_Z, TAR_BZ2, TAR_LZ, TAR_XZ, TAR_ZST, TAR_SZ, TAR_SNAPPY, TAR_LZMA};
        CONSISTENT_FORMAT1 = new HashMap<ArchiveFormat, ArchiveFormat>();
        CONSISTENT_FORMAT2 = new HashMap<ArchiveFormat, ArchiveFormat>();
        for (ArchiveFormat value : ArchiveFormat.values()) {
            String ext = value.extName;
            if (ext.equals(".z") || ext.equals(".Z")) {
                SA_MAP.put(value.extName, value);
                continue;
            }
            SA_MAP.put(ext.toLowerCase(), value);
        }
        SA_MAP.put(".uc", UC_II);
        SA_MAP.put(".uc0", UC_II);
        SA_MAP.put(".uc2", UC_II);
        SA_MAP.put(".ucn", UC_II);
        SA_MAP.put(".ur2", UC_II);
        SA_MAP.put(".ue2", UC_II);
        CONSISTENT_FORMAT1.put(TAR_GZ, TGZ);
        CONSISTENT_FORMAT1.put(TAR_BZ2, TBZ2);
        CONSISTENT_FORMAT1.put(TAR_LZ, TLZ);
        CONSISTENT_FORMAT1.put(TAR_XZ, TXZ);
        CONSISTENT_FORMAT1.put(TAR_ZST, TZST);
        CONSISTENT_FORMAT1.put(TAR_Z, TZ);
        CONSISTENT_FORMAT2.put(TGZ, TAR_GZ);
        CONSISTENT_FORMAT2.put(TAZ, TAR_GZ);
        CONSISTENT_FORMAT2.put(TBZ2, TAR_BZ2);
        CONSISTENT_FORMAT2.put(TLZ, TAR_LZ);
        CONSISTENT_FORMAT2.put(TXZ, TAR_XZ);
        CONSISTENT_FORMAT2.put(TZST, TAR_ZST);
        CONSISTENT_FORMAT2.put(TZ, TAR_Z);
    }
}

