/*
 * Decompiled with CFR 0.152.
 */
package com.iotake.suller.sullerj.examples.basic;

import com.iotake.suller.sullerj.binder.ExtendedDocumentObjectBinder;
import com.iotake.suller.sullerj.binder.ExtendedDocumentObjectBinderBuilder;
import com.iotake.suller.sullerj.binder.server.DocumentBinderInjector;
import com.iotake.suller.sullerj.examples.basic.Phone;
import com.iotake.suller.sullerj.examples.basic.User;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.beans.DocumentObjectBinder;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;

public class BasicExample {
    public static void main(String[] args) throws Exception {
        String core = "suller_examples";
        String url = "http://localhost:8983/solr/" + core;
        HttpSolrServer server = new HttpSolrServer(url);
        ExtendedDocumentObjectBinder binder = new ExtendedDocumentObjectBinderBuilder().build();
        DocumentBinderInjector.inject((SolrServer)server, (DocumentObjectBinder)binder);
        User user = new User();
        user.id = System.currentTimeMillis();
        user.name = "John Doe";
        user.aliases = new String[]{"Spooge", "Diesel"};
        user.email = "test@email.com";
        user.phones = Arrays.asList(new Phone("home", "415-123-1234"), new Phone("mobile", "415-321-4321"));
        System.out.println("\nStoring:\n" + ReflectionToStringBuilder.toString((Object)user, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        server.addBean((Object)user);
        server.commit();
        SolrQuery query = new SolrQuery();
        query.setQuery("Person__id:" + user.id);
        QueryResponse rsp = server.query((SolrParams)query);
        List storedEntities = rsp.getBeans(Object.class);
        System.out.println("Result count: " + storedEntities.size());
        for (Object storedEntity : storedEntities) {
            System.out.println("\nRetrieved:\n" + ReflectionToStringBuilder.toString(storedEntity, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        }
    }
}

