/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.AbstractApiDaemon;
import com.ircclouds.irc.api.AbstractCommandServerImpl;
import com.ircclouds.irc.api.AbstractMessageReader;
import com.ircclouds.irc.api.ICommandServer;
import com.ircclouds.irc.api.IIRCSession;
import com.ircclouds.irc.api.IMessageDispatcher;
import com.ircclouds.irc.api.IMessageReader;
import com.ircclouds.irc.api.MessageDispatcherImpl;
import com.ircclouds.irc.api.commands.ICommand;
import com.ircclouds.irc.api.comms.IConnection;
import com.ircclouds.irc.api.comms.SSLSocketChannelConnection;
import com.ircclouds.irc.api.comms.SocketChannelConnection;
import com.ircclouds.irc.api.domain.IRCServer;
import com.ircclouds.irc.api.domain.IRCServerOptions;
import com.ircclouds.irc.api.filters.IMessageFilter;
import com.ircclouds.irc.api.listeners.IMessageListener;
import com.ircclouds.irc.api.listeners.MESSAGE_VISIBILITY;
import java.io.IOException;

public abstract class AbstractIRCSession
implements IIRCSession {
    private IMessageDispatcher dispatcher = new MessageDispatcherImpl();
    private ICommandServer cmdServ = new AbstractCommandServerImpl(){

        @Override
        public IConnection getConnection() {
            return AbstractIRCSession.this.conn;
        }
    };
    private IMessageReader reader = new AbstractMessageReader(){

        @Override
        protected IRCServerOptions getIRCServerOptions() {
            return AbstractIRCSession.this.getIRCServerOptions();
        }

        @Override
        public IConnection getConnection() {
            return AbstractIRCSession.this.conn;
        }
    };
    private AbstractApiDaemon daemon = new AbstractApiDaemon(this.reader, this.dispatcher){

        @Override
        protected void onExit() {
            try {
                AbstractIRCSession.this.close();
            }
            catch (IOException aExc) {
                throw new RuntimeException(aExc);
            }
        }

        @Override
        protected IMessageFilter getMessageFilter() {
            return AbstractIRCSession.this.getMessageFilter();
        }
    };
    private IConnection conn;

    public void execute(ICommand aCommand) throws IOException {
        this.cmdServ.execute(aCommand);
    }

    @Override
    public void addListeners(MESSAGE_VISIBILITY aListenerLevel, IMessageListener ... aListeners) {
        for (IMessageListener _listener : aListeners) {
            this.dispatcher.register(_listener, aListenerLevel);
        }
    }

    @Override
    public ICommandServer getCommandServer() {
        return this.cmdServ;
    }

    @Override
    public void removeListener(IMessageListener aListener) {
        this.dispatcher.unregister(aListener);
    }

    @Override
    public boolean open(IRCServer aServer) throws IOException {
        this.conn = aServer.isSSL() == false ? new SocketChannelConnection() : new SSLSocketChannelConnection();
        if (this.conn.open(aServer.getHostname(), aServer.getPort())) {
            if (!this.daemon.isAlive()) {
                this.daemon.start();
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        this.conn.close();
        this.reader.reset();
    }

    protected abstract IRCServerOptions getIRCServerOptions();
}

