package com.ironsoftware.ironpdf.annotation;

/**
 * Icons used to interact (open/close) with a PDF annotation on a page.
 */
public enum AnnotationIcon {
    /**
     * No icon, this is useful when an annotation will be signified by an existing graphic or object.
     */
    NO_ICON,

    /**
     * A Comment Icon
     */
    COMMENT,

    /**
     * A Help Icon
     */
    HELP,

    /**
     * An 'Insert' Icon
     */
    INSERT,

    /**
     * A Key Icon
     */
    KEY,

    /**
     * A New Paragraph Icon
     */
    NEW_PARAGRAPH,

    /**
     * A Note Icon
     */
    NOTE,

    /**
     * A 'Paragraph of Text' Icon
     */
    PARAGRAPH
}
