/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Setting_Api {
    static final Logger logger = LoggerFactory.getLogger(Setting_Api.class);
    public static int subProcessPort = Setting_Api.findFreePort();
    public static String licenseKey = "";
    public static boolean enableDebug = false;
    public static Path logPath = Paths.get("ironpdfengine.log", new String[0]);
    public static Path ironPdfEngineFolder = Paths.get(System.getProperty("user.dir"), Setting_Api.getIronPdfEngineFolderName());
    public static Path defaultPathToIronPdfEngineFolder = Paths.get(Setting_Api.getIronPdfEngineFolderName(), new String[0]);
    public static String subProcessHost = "127.0.0.1";
    public static final String IRON_PDF_ENGINE_VERSION = "2022.11.10413";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort() {
        try (ServerSocket socket = new ServerSocket(0, 1, InetAddress.getByName("127.0.0.1"));){
            socket.setReuseAddress(true);
            int port = socket.getLocalPort();
            socket.close();
            int n = port;
            return n;
        }
        catch (IOException iOException) {
            throw new IllegalStateException("Could not find a free port to start IronPdfEngine");
        }
    }

    public static Optional<File> getAvailableIronPdfEngineFile() {
        try {
            URL resourceUrl = Class.forName("com.ironsoftware.ironpdf.internal.EngineResource" + Setting_Api.currentOsFullName() + Setting_Api.currentOsArch()).getResource("/" + Setting_Api.getIronPdfEngineFolderName());
            Path fp = Paths.get(Paths.get(Objects.requireNonNull(resourceUrl).toURI()).toString(), Setting_Api.getIronPdfEngineFileName());
            if (Files.exists(fp, new LinkOption[0])) {
                logger.info("IronPdfEngine found (from ironpdf-engine package) (EngineResource) at: " + fp);
                return Optional.of(fp.toFile());
            }
        }
        catch (Exception resourceUrl) {
            // empty catch block
        }
        try {
            if (Files.exists(Setting_Api.getCustomIronPdfEnginePath(), new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + Setting_Api.getCustomIronPdfEnginePath());
                return Optional.of(Setting_Api.getCustomIronPdfEnginePath().toFile());
            }
        }
        catch (Exception resourceUrl) {
            // empty catch block
        }
        logger.info("IronPdfEngine not found at: " + Setting_Api.getCustomIronPdfEnginePath());
        try {
            if (Files.exists(Setting_Api.getDefaultIronPdfEnginePath(), new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + Setting_Api.getDefaultIronPdfEnginePath());
                return Optional.of(Setting_Api.getDefaultIronPdfEnginePath().toFile());
            }
        }
        catch (Exception resourceUrl) {
            // empty catch block
        }
        logger.info("IronPdfEngine not found at: " + Setting_Api.getDefaultIronPdfEnginePath());
        try {
            Path dir = Paths.get(System.getProperty("user.dir"), Setting_Api.getIronPdfEngineFolderName());
            if (Files.exists(dir, new LinkOption[0])) {
                logger.info("IronPdfEngine found at: " + dir);
                return Optional.of(dir.toFile());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.info("IronPdfEngine not found at: System.getProperty(\"user.dir\")/" + Setting_Api.getIronPdfEngineFolderName());
        return Optional.empty();
    }

    static String currentOsFullName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Windows";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "Linux";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "MacOS";
        }
        throw new RuntimeException("unknown OS:" + SystemUtils.OS_NAME);
    }

    static String currentOsArch() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (System.getProperty("os.arch").equalsIgnoreCase("x86")) {
                return "x86";
            }
            return "x64";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "x64";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "x64";
        }
        throw new RuntimeException("unknown OS:" + SystemUtils.OS_NAME);
    }

    private static String getIronPdfEngineFolderName() {
        return "IronPdfEngine.2022.11.10413." + Setting_Api.currentOsFullName() + "." + Setting_Api.currentOsArch();
    }

    private static String getIronPdfEngineFileName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "IronPdfEngine.exe";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "IronPdfEngine";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "IronPdfEngine";
        }
        return "IronPdfEngine";
    }

    public static Path getCustomIronPdfEnginePath() {
        return Paths.get(ironPdfEngineFolder.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFileName());
    }

    public static Path getDefaultIronPdfEnginePath() {
        return Paths.get(Setting_Api.getIronPdfEngineFolderName(), Setting_Api.getIronPdfEngineFileName());
    }
}

