/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.form.CheckBoxField;
import com.ironsoftware.ironpdf.form.ComboBoxField;
import com.ironsoftware.ironpdf.form.FormFieldTypes;
import com.ironsoftware.ironpdf.form.TextField;
import com.ironsoftware.ironpdf.internal.proto.FormField;
import com.ironsoftware.ironpdf.internal.proto.PdfForm;
import java.util.List;
import java.util.stream.Collectors;

final class Form_Converter {
    Form_Converter() {
    }

    static List<com.ironsoftware.ironpdf.form.FormField> fromProto(PdfForm proto) {
        return proto.getFormFieldsList().stream().map(x -> {
            switch (x.getSubTypeCase()) {
                case COMBO_BOX_FIELD: {
                    return Form_Converter.fromProtoToComboBoxField(x);
                }
                case CHECK_BOX_FIELD: {
                    return Form_Converter.fromProtoToCheckBoxField(x);
                }
                case TEXT_FIELD: {
                    return Form_Converter.fromProtoToTextField(x);
                }
                case SUBTYPE_NOT_SET: 
                case UNKNOWN_FIELD: {
                    return Form_Converter.fromProtoToFormField(x);
                }
            }
            throw new IndexOutOfBoundsException();
        }).collect(Collectors.toList());
    }

    static ComboBoxField fromProtoToComboBoxField(FormField proto) {
        return new ComboBoxField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), (List<String>)proto.getComboBoxField().getOptionsList(), proto.getComboBoxField().getSelectedIndex(), proto.getReadOnly());
    }

    static CheckBoxField fromProtoToCheckBoxField(FormField proto) {
        return new CheckBoxField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getCheckBoxField().getBooleanValue(), proto.getReadOnly());
    }

    static TextField fromProtoToTextField(FormField proto) {
        return new TextField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static com.ironsoftware.ironpdf.form.FormField fromProtoToFormField(FormField proto) {
        return new com.ironsoftware.ironpdf.form.FormField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), Form_Converter.fromProto(proto.getType()), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static FormFieldTypes fromProto(com.ironsoftware.ironpdf.internal.proto.FormFieldTypes input) {
        return FormFieldTypes.values()[input.getEnumValue()];
    }
}

