/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.font.FontTypes;
import com.ironsoftware.ironpdf.form.FormField;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumFlattenFormRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetFormRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetFormResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRenameFieldRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRenameFormFieldResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetFormFieldFontRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetFormFieldIsReadOnlyRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetFormFieldValueRequestP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.FontTypes_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Form_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import java.util.List;
import java.util.stream.Collectors;

public final class Form_Api {
    public static List<FormField> getFields(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetFormRequestP.Builder request = PdfiumGetFormRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        PdfiumGetFormResultP response = client.blockingStub.pdfiumFormGetForm(request.build());
        if (response.getResultOrExceptionCase() == PdfiumGetFormResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(response.getException());
        }
        return Form_Converter.fromProto(response.getResult());
    }

    public static String renameField(InternalPdfDocument internalPdfDocument, String currentFieldName, String newFieldName) {
        RpcClient client = Access.ensureConnection();
        PdfiumRenameFieldRequestP.Builder request = PdfiumRenameFieldRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setCurrentFieldName(currentFieldName);
        request.setNewFieldName(newFieldName);
        PdfiumRenameFormFieldResultP response = client.blockingStub.pdfiumFormRenameField(request.build());
        if (response.getResultOrExceptionCase() == PdfiumRenameFormFieldResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(response.getException());
        }
        return response.getResult();
    }

    public static void setFieldValue(InternalPdfDocument internalPdfDocument, int annotationIndex, String value) {
        RpcClient client = Access.ensureConnection();
        PdfiumSetFormFieldValueRequestP.Builder request = PdfiumSetFormFieldValueRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setAnnotationIndex(annotationIndex);
        request.setFormFieldValue(value);
        EmptyResultP response = client.blockingStub.pdfiumFormSetFieldValue(request.build());
        Utils_Util.handleEmptyResult(response);
    }

    public static void setTextFieldFont(InternalPdfDocument internalPdfDocument, String textFieldName, FontTypes font, int fontSize) {
        RpcClient client = Access.ensureConnection();
        PdfiumSetFormFieldFontRequestP.Builder request = PdfiumSetFormFieldFontRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setFieldName(textFieldName);
        request.setFontType(FontTypes_Converter.toProto(font));
        request.setFontSize(fontSize);
        EmptyResultP response = client.blockingStub.pdfiumFormSetFieldFont(request.build());
        Utils_Util.handleEmptyResult(response);
    }

    public static void flattenPdfFrom(InternalPdfDocument internalPdfDocument) {
        Form_Api.flattenPdfFrom(internalPdfDocument, null);
    }

    public static void flattenPdfFrom(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        PdfiumFlattenFormRequestP.Builder req = PdfiumFlattenFormRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllPageIndexes(pageIndexes);
        EmptyResultP res = client.blockingStub.pdfiumFormFlattenForm(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void setFormFieldIsReadOnly(InternalPdfDocument internalPdfDocument, int annotationIndex, boolean isReadOnly) {
        RpcClient client = Access.ensureConnection();
        PdfiumSetFormFieldIsReadOnlyRequestP.Builder request = PdfiumSetFormFieldIsReadOnlyRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setAnnotationIndex(annotationIndex);
        request.setIsReadOnly(isReadOnly);
        EmptyResultP response = client.blockingStub.pdfiumFormSetFormFieldIsReadOnly(request.build());
        Utils_Util.handleEmptyResult(response);
    }
}

