/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.edit.PageSelection;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Image_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.signature.Signature;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;

public final class InternalPdfDocument
implements AutoCloseable,
Printable {
    final PdfDocumentP remoteDocument;
    List<PageInfo> tempPagesInfo = Collections.emptyList();
    private boolean disposed = false;
    public List<Signature> signatures = Collections.emptyList();
    public String userPassword = "";
    public String ownerPassword = "";

    InternalPdfDocument(PdfDocumentP remoteDocument) {
        this.remoteDocument = remoteDocument;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public synchronized void close() {
        try {
            if (this.disposed) {
                return;
            }
            RpcClient client = Access.ensureConnection();
            EmptyResultP res = client.blockingStub.pdfiumDispose(this.remoteDocument);
            Utils_Util.handleEmptyResult(res);
            this.disposed = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        try {
            if (pageIndex >= this.tempPagesInfo.size()) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            byte[] bytes = Image_Api.pdfToImage(this, Collections.singletonList(pageIndex), 300).get(0);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
            BufferedImage image = ImageIO.read(byteArrayInputStream);
            graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            graphics2D.drawImage(image, 0, 0, (int)pageFormat.getPaper().getWidth(), (int)pageFormat.getPaper().getHeight(), null);
            return 0;
        }
        catch (IOException e) {
            throw new PrinterException(e.getMessage());
        }
    }

    public List<Integer> getPageList(PageSelection pageSelection) {
        List<PageInfo> pageInfos = Page_Api.getPagesInfo(this);
        if (pageSelection.pagesList.isEmpty()) {
            return pageInfos.stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        return pageSelection.pagesList.stream().map(i -> {
            if (i == -1) {
                return pageInfos.size() - 1;
            }
            return i;
        }).collect(Collectors.toList());
    }

    public List<PageInfo> getPageInfoList(PageSelection pageSelection) {
        List<PageInfo> pageInfos = Page_Api.getPagesInfo(this);
        if (pageSelection.pagesList.isEmpty()) {
            return pageInfos;
        }
        return pageSelection.pagesList.stream().map(i -> {
            if (i == -1) {
                return (PageInfo)pageInfos.get(pageInfos.size() - 1);
            }
            return (PageInfo)pageInfos.get((int)i);
        }).collect(Collectors.toList());
    }
}

