/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.internal.proto.ChromeHttpLoginCredentialsP;
import com.ironsoftware.ironpdf.internal.proto.ChromePdfRenderOptionsP;
import com.ironsoftware.ironpdf.internal.proto.ChromeRenderPdfDocumentFromHtmlRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.ChromeRenderPdfDocumentFromRtfStringRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.ChromeRenderPdfDocumentFromUriRequestP;
import com.ironsoftware.ironpdf.internal.proto.ChromeRenderPdfDocumentFromZipFileRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.render.ChromeHttpLoginCredentials;
import com.ironsoftware.ironpdf.render.ChromePdfRenderOptions;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Render_Api {
    static final Logger logger = LoggerFactory.getLogger(Render_Api.class);

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, null, null);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        if (Utils_StringHelper.isNullOrWhiteSpace(htmlFilePath)) {
            throw new IllegalArgumentException("Value 'htmlFilePath' cannot be null or empty.");
        }
        File htmlFile = new File(htmlFilePath);
        String absoluteFilePath = htmlFile.getAbsolutePath();
        if (!new File(absoluteFilePath).isFile()) {
            throw new IOException(String.format("%1$s is not a valid Html file path. That file does not exist.", absoluteFilePath));
        }
        List<String> htmlList = Files.readAllLines(Paths.get(htmlFilePath, new String[0]));
        if (htmlList.size() == 0) {
            throw new IOException(String.format("html data is null or empty.  Can not create a PDF document from invalid data. %1$s", htmlFilePath));
        }
        return Render_Api.renderHtmlAsPdf(String.join((CharSequence)"", htmlList), renderOptions, loginCredentials);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        ChromeHttpLoginCredentialsP login;
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        StreamObserver<ChromeRenderPdfDocumentFromHtmlRequestStreamP> requestStream = client.stub.chromeRenderFromHtml(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        ChromeRenderPdfDocumentFromHtmlRequestStreamP.InfoP.Builder info = ChromeRenderPdfDocumentFromHtmlRequestStreamP.InfoP.newBuilder();
        ChromePdfRenderOptionsP renderOp = Render_Converter.toProto(renderOptions);
        if (renderOp != null) {
            info.setRenderOptions(renderOp);
        }
        if ((login = Render_Converter.toProto(loginCredentials)) != null) {
            info.setHttpOptions(login);
        }
        ChromeRenderPdfDocumentFromHtmlRequestStreamP.Builder infoMsg = ChromeRenderPdfDocumentFromHtmlRequestStreamP.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        Iterator<char[]> it = Utils_Util.chunk(html.toCharArray());
        while (it.hasNext()) {
            char[] htmlChunk = it.next();
            ChromeRenderPdfDocumentFromHtmlRequestStreamP.Builder dataMsg = ChromeRenderPdfDocumentFromHtmlRequestStreamP.newBuilder();
            dataMsg.setHtmlChunk(String.valueOf(htmlChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, null, loginCredentials);
    }

    public static InternalPdfDocument renderHtmlFileAsPdf(String htmlFilePath, ChromePdfRenderOptions renderOptions) throws IOException {
        return Render_Api.renderHtmlFileAsPdf(htmlFilePath, renderOptions, null);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url) {
        return Render_Api.renderUrlAsPdf(url, null, null);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) {
        RpcClient client = Access.ensureConnection();
        ChromeRenderPdfDocumentFromUriRequestP.Builder request = ChromeRenderPdfDocumentFromUriRequestP.newBuilder();
        request.setUri(url);
        if (renderOptions == null) {
            renderOptions = new ChromePdfRenderOptions();
        }
        request.setRenderOptions(Render_Converter.toProto(renderOptions));
        if (loginCredentials == null) {
            loginCredentials = new ChromeHttpLoginCredentials();
        }
        request.setHttpOptions(Render_Converter.toProto(loginCredentials));
        PdfDocumentResultP res = client.blockingStub.chromeRenderFromUri(request.build());
        return Utils_Util.handlePdfDocumentResult(res);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderUrlAsPdf(url, null, loginCredentials);
    }

    public static InternalPdfDocument renderUrlAsPdf(String url, ChromePdfRenderOptions renderOptions) {
        return Render_Api.renderUrlAsPdf(url, renderOptions, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html) {
        return Render_Api.renderHtmlAsPdf(html, null, null);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, ChromeHttpLoginCredentials loginCredentials) {
        return Render_Api.renderHtmlAsPdf(html, null, loginCredentials);
    }

    public static InternalPdfDocument renderHtmlAsPdf(String html, ChromePdfRenderOptions renderOptions) {
        return Render_Api.renderHtmlAsPdf(html, renderOptions, null);
    }

    public static InternalPdfDocument renderRtfAsPdf(String rtfString) {
        RpcClient client = Access.ensureConnection();
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        StreamObserver<ChromeRenderPdfDocumentFromRtfStringRequestStreamP> requestStream = client.stub.chromeRenderRtfToPdf(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        ChromeRenderPdfDocumentFromRtfStringRequestStreamP.InfoP.Builder info = ChromeRenderPdfDocumentFromRtfStringRequestStreamP.InfoP.newBuilder();
        info.setRenderOptions(Render_Converter.toProto(new ChromePdfRenderOptions()));
        info.setHttpOptions(Render_Converter.toProto(new ChromeHttpLoginCredentials()));
        requestStream.onNext((Object)ChromeRenderPdfDocumentFromRtfStringRequestStreamP.newBuilder().setInfo(info.build()).build());
        Iterator<char[]> it = Utils_Util.chunk(rtfString.toCharArray());
        while (it.hasNext()) {
            char[] htmlChunk = it.next();
            ChromeRenderPdfDocumentFromRtfStringRequestStreamP.Builder dataMsg = ChromeRenderPdfDocumentFromRtfStringRequestStreamP.newBuilder();
            dataMsg.setRtfStringChunk(String.valueOf(htmlChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static InternalPdfDocument renderZipAsPdf(Path zipFilePath, String mainFile, ChromePdfRenderOptions renderOptions, ChromeHttpLoginCredentials loginCredentials) throws IOException {
        ChromeHttpLoginCredentialsP login;
        RpcClient client = Access.ensureConnection();
        ChromeRenderPdfDocumentFromZipFileRequestStreamP.InfoP.Builder info = ChromeRenderPdfDocumentFromZipFileRequestStreamP.InfoP.newBuilder();
        ChromePdfRenderOptionsP renderOp = Render_Converter.toProto(renderOptions);
        if (renderOp != null) {
            info.setRenderOptions(renderOp);
        }
        if ((login = Render_Converter.toProto(loginCredentials)) != null) {
            info.setHttpOptions(login);
        }
        if (mainFile != null) {
            info.setMainFile(mainFile);
        }
        ChromeRenderPdfDocumentFromZipFileRequestStreamP.Builder infoMsg = ChromeRenderPdfDocumentFromZipFileRequestStreamP.newBuilder();
        infoMsg.setInfo(info);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        StreamObserver<ChromeRenderPdfDocumentFromZipFileRequestStreamP> requestStream = client.stub.chromeRenderFromZipFile(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        requestStream.onNext((Object)infoMsg.build());
        byte[] zipByte = Files.readAllBytes(zipFilePath);
        Iterator<byte[]> it = Utils_Util.chunk(zipByte);
        while (it.hasNext()) {
            byte[] zipChunk = it.next();
            ChromeRenderPdfDocumentFromZipFileRequestStreamP.Builder dataMsg = ChromeRenderPdfDocumentFromZipFileRequestStreamP.newBuilder();
            dataMsg.setZipChunk(ByteString.copyFrom((byte[])zipChunk));
            requestStream.onNext((Object)dataMsg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }
}

