/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfDocumentPermissionsP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfEditSecurityP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfPrintSecurityP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfSecuritySettingsP;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.security.PdfEditSecurity;
import com.ironsoftware.ironpdf.security.PdfPrintSecurity;
import com.ironsoftware.ironpdf.security.SecurityOptions;

final class Security_Converter {
    Security_Converter() {
    }

    public static int convertPermissionsInterfaceToEnum(SecurityOptions securityOptions) {
        int enumObject = PdfDocumentPermissionsEnum.AllowAll.getValue();
        enumObject = securityOptions.isAllowUserCopyPasteContent().booleanValue() ? (enumObject |= PdfDocumentPermissionsEnum.AllowExtractContent.getValue()) : (enumObject &= ~PdfDocumentPermissionsEnum.AllowExtractContent.getValue());
        enumObject = securityOptions.isAllowUserCopyPasteContentForAccessibility().booleanValue() ? (enumObject |= PdfDocumentPermissionsEnum.AllowAccessibilityExtractContent.getValue()) : (enumObject &= ~PdfDocumentPermissionsEnum.AllowAccessibilityExtractContent.getValue());
        enumObject = securityOptions.isAllowUserAnnotations().booleanValue() ? (enumObject |= PdfDocumentPermissionsEnum.AllowAnnotations.getValue()) : (enumObject &= ~PdfDocumentPermissionsEnum.AllowAnnotations.getValue());
        enumObject = securityOptions.isAllowUserFormData().booleanValue() ? (enumObject |= PdfDocumentPermissionsEnum.AllowFillForms.getValue()) : (enumObject &= ~PdfDocumentPermissionsEnum.AllowFillForms.getValue());
        switch (securityOptions.getAllowUserEdits()) {
            case NO_EDIT: {
                enumObject &= ~PdfDocumentPermissionsEnum.AllowModify.getValue();
                enumObject &= ~PdfDocumentPermissionsEnum.AllowAssembleDocument.getValue();
                break;
            }
            case EDIT_PAGES: {
                enumObject &= ~PdfDocumentPermissionsEnum.AllowModify.getValue();
                enumObject |= PdfDocumentPermissionsEnum.AllowAssembleDocument.getValue();
                break;
            }
            case EDIT_ALL: {
                enumObject |= PdfDocumentPermissionsEnum.AllowModify.getValue();
                enumObject |= PdfDocumentPermissionsEnum.AllowAssembleDocument.getValue();
            }
        }
        switch (securityOptions.getAllowUserPrinting()) {
            case NO_PRINT: {
                enumObject &= ~PdfDocumentPermissionsEnum.AllowPrint.getValue();
                enumObject &= ~PdfDocumentPermissionsEnum.AllowPrintFullQuality.getValue();
                break;
            }
            case PRINT_LOW_QUALITY: {
                enumObject |= PdfDocumentPermissionsEnum.AllowPrint.getValue();
                enumObject &= ~PdfDocumentPermissionsEnum.AllowPrintFullQuality.getValue();
                break;
            }
            case FULL_PRINT_RIGHTS: {
                enumObject |= PdfDocumentPermissionsEnum.AllowPrint.getValue();
                enumObject |= PdfDocumentPermissionsEnum.AllowPrintFullQuality.getValue();
            }
        }
        return enumObject;
    }

    public static SecurityOptions convertPdfiumPdfDocumentPermissionsPToInterface(PdfiumPdfDocumentPermissionsP inputEnum) {
        SecurityOptions securityOptions = new SecurityOptions();
        securityOptions.setAllowUserAnnotations((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowAnnotations.getValue()) != 0);
        securityOptions.setAllowUserCopyPasteContent((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowExtractContent.getValue()) != 0);
        if ((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowModify.getValue()) != 0) {
            securityOptions.setAllowUserEdits(PdfEditSecurity.EDIT_ALL);
        } else if ((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowAssembleDocument.getValue()) != 0) {
            securityOptions.setAllowUserEdits(PdfEditSecurity.EDIT_PAGES);
        } else {
            securityOptions.setAllowUserEdits(PdfEditSecurity.NO_EDIT);
        }
        securityOptions.setAllowUserCopyPasteContentForAccessibility((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowAccessibilityExtractContent.getValue()) != 0);
        if ((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowPrint.getValue()) != 0) {
            if ((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowPrintFullQuality.getValue()) != 0) {
                securityOptions.setAllowUserPrinting(PdfPrintSecurity.FULL_PRINT_RIGHTS);
            } else {
                securityOptions.setAllowUserPrinting(PdfPrintSecurity.PRINT_LOW_QUALITY);
            }
        } else {
            securityOptions.setAllowUserPrinting(PdfPrintSecurity.NO_PRINT);
        }
        securityOptions.setAllowUserFormData((inputEnum.getEnumValue() & PdfDocumentPermissionsEnum.AllowFillForms.getValue()) != 0);
        return securityOptions;
    }

    static PdfiumPdfSecuritySettingsP toProto(SecurityOptions iron) {
        PdfiumPdfDocumentPermissionsP.Builder permission = PdfiumPdfDocumentPermissionsP.newBuilder();
        permission.setEnumValue(Security_Converter.convertPermissionsInterfaceToEnum(iron));
        PdfiumPdfSecuritySettingsP.Builder proto = PdfiumPdfSecuritySettingsP.newBuilder();
        proto.setOwnerPassword(iron.getOwnerPassword());
        proto.setUserPassword(iron.getUserPassword());
        proto.setPermissions(permission);
        return proto.build();
    }

    static PdfiumPdfEditSecurityP toProto(PdfEditSecurity input) {
        PdfiumPdfEditSecurityP.Builder tempVar = PdfiumPdfEditSecurityP.newBuilder();
        tempVar.setEnumValue(input.ordinal());
        return tempVar.build();
    }

    static PdfiumPdfPrintSecurityP toProto(PdfPrintSecurity input) {
        PdfiumPdfPrintSecurityP.Builder tempVar = PdfiumPdfPrintSecurityP.newBuilder();
        tempVar.setEnumValue(input.ordinal());
        return tempVar.build();
    }

    static SecurityOptions fromProto(PdfiumPdfSecuritySettingsP proto) {
        SecurityOptions iron = Security_Converter.convertPdfiumPdfDocumentPermissionsPToInterface(proto.getPermissions());
        if (!Utils_StringHelper.isNullOrWhiteSpace(proto.getUserPassword())) {
            iron.setUserPassword(proto.getUserPassword());
        }
        if (!Utils_StringHelper.isNullOrWhiteSpace(proto.getOwnerPassword())) {
            iron.setOwnerPassword(proto.getOwnerPassword());
        }
        return iron;
    }

    static PdfEditSecurity fromProto(PdfiumPdfEditSecurityP input) {
        return PdfEditSecurity.values()[input.getEnumValue()];
    }

    static PdfPrintSecurity fromProto(PdfiumPdfPrintSecurityP input) {
        return PdfPrintSecurity.values()[input.getEnumValue()];
    }

    public static enum PdfDocumentPermissionsEnum {
        None(-3904),
        AllowAccessibilityExtractContent(512),
        AllowAnnotations(32),
        AllowAssembleDocument(1024),
        AllowExtractContent(16),
        AllowFillForms(256),
        AllowPrintFullQuality(2048),
        AllowModify(8),
        AllowPrint(4),
        AllowAll(-4);

        private final int value;

        private PdfDocumentPermissionsEnum(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

