/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.render;

import com.ironsoftware.ironpdf.render.CssMediaType;
import com.ironsoftware.ironpdf.render.FitToPaperModes;
import com.ironsoftware.ironpdf.render.PaperOrientation;
import com.ironsoftware.ironpdf.render.PaperSize;
import com.ironsoftware.ironpdf.render.WaitFor;

public class ChromePdfRenderOptions
implements Cloneable {
    private boolean createPdfFormsFromHtml = true;
    private CssMediaType CssMediaType = com.ironsoftware.ironpdf.render.CssMediaType.SCREEN;
    private String customCssUrl = "";
    private double customPaperHeight = 297.0;
    private double customPaperWidth = 210.0;
    private boolean enableJavaScript = true;
    private FitToPaperModes fitToPaperMode = FitToPaperModes.Zoom;
    private int viewPortWidth = 1024;
    private int viewPortHeight = 1280;
    private int zoom = 100;
    private boolean grayScale = false;
    private String inputEncoding = "utf-8";
    private double marginBottom = 25.0;
    private double marginLeft = 25.0;
    private double marginRight = 25.0;
    private double marginTop = 25.0;
    private PaperOrientation paperOrientation = PaperOrientation.PORTRAIT;
    private PaperSize paperSize = PaperSize.A4;
    private boolean printHtmlBackgrounds = true;
    private String title;
    private String javascript;
    private WaitFor waitFor = new WaitFor();

    public boolean isCreatePdfFormsFromHtml() {
        return this.createPdfFormsFromHtml;
    }

    public void setCreatePdfFormsFromHtml(boolean value) {
        this.createPdfFormsFromHtml = value;
    }

    public CssMediaType getCssMediaType() {
        return this.CssMediaType;
    }

    public void setCssMediaType(CssMediaType value) {
        this.CssMediaType = value;
    }

    public String getCustomCssUrl() {
        return this.customCssUrl;
    }

    public void setCustomCssUrl(String value) {
        this.customCssUrl = value;
    }

    public double getCustomPaperHeight() {
        return this.customPaperHeight;
    }

    public void setCustomPaperHeight(double value) {
        this.customPaperHeight = value;
    }

    public double getCustomPaperWidth() {
        return this.customPaperWidth;
    }

    public void setCustomPaperWidth(double value) {
        this.customPaperWidth = value;
    }

    public boolean isEnableJavaScript() {
        return this.enableJavaScript;
    }

    public void setEnableJavaScript(boolean value) {
        this.enableJavaScript = value;
    }

    public FitToPaperModes getFitToPaperMode() {
        return this.fitToPaperMode;
    }

    public void setFitToPaperMode(FitToPaperModes value) {
        this.fitToPaperMode = value;
    }

    public boolean isGrayScale() {
        return this.grayScale;
    }

    public void setGrayScale(boolean value) {
        this.grayScale = value;
    }

    public String getInputEncoding() {
        return this.inputEncoding;
    }

    public double getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(double value) {
        this.marginBottom = value;
    }

    public double getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(double value) {
        this.marginLeft = value;
    }

    public double getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(double value) {
        this.marginRight = value;
    }

    public double getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(double value) {
        this.marginTop = value;
    }

    public PaperOrientation getPaperOrientation() {
        return this.paperOrientation;
    }

    public void setPaperOrientation(PaperOrientation value) {
        this.paperOrientation = value;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public void setPaperSize(PaperSize value) {
        this.paperSize = value;
    }

    public boolean isPrintHtmlBackgrounds() {
        return this.printHtmlBackgrounds;
    }

    public void setPrintHtmlBackgrounds(boolean value) {
        this.printHtmlBackgrounds = value;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public String getJavascript() {
        return this.javascript;
    }

    public Object Clone() throws CloneNotSupportedException {
        return (ChromePdfRenderOptions)this.clone();
    }

    public void setCustomPaperSizeInCentimeters(double width, double height) {
        this.setCustomPaperWidth(width * 10.0);
        this.setCustomPaperHeight(height * 10.0);
        this.setPaperSize(PaperSize.Custom);
    }

    public void setCustomPaperSizeInMillimeters(double width, double height) {
        this.setCustomPaperWidth(width);
        this.setCustomPaperHeight(height);
        this.setPaperSize(PaperSize.Custom);
    }

    public void setCustomPaperSizeInPixelsOrPoints(double width, double height) {
        this.setCustomPaperSizeInPixelsOrPoints(width, height, 96);
    }

    public void setCustomPaperSizeInPixelsOrPoints(double width, double height, int DPI) {
        this.SetCustomPaperSizeInInches(width / (double)DPI, height / (double)DPI);
    }

    public void SetCustomPaperSizeInInches(double width, double height) {
        this.setCustomPaperWidth(width * 25.4);
        this.setCustomPaperHeight(height * 25.4);
        this.setPaperSize(PaperSize.Custom);
    }

    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }

    public WaitFor getWaitFor() {
        return this.waitFor;
    }

    public void setWaitFor(WaitFor waitFor) {
        this.waitFor = waitFor;
    }

    public int getViewPortWidth() {
        return this.viewPortWidth;
    }

    public int getViewPortHeight() {
        return this.viewPortHeight;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void UseChromeDefaultRendering() {
        this.fitToPaperMode = FitToPaperModes.Zoom;
        this.zoom = 100;
    }

    public void UseScaledRendering() {
        this.UseScaledRendering(100);
    }

    public void UseScaledRendering(int zoomPercentage) {
        this.fitToPaperMode = FitToPaperModes.Zoom;
        this.zoom = zoomPercentage;
    }

    public void UseResponsiveCssRendering() {
        this.UseResponsiveCssRendering(1280);
    }

    public void UseResponsiveCssRendering(int viewPortWidthValue) {
        this.fitToPaperMode = FitToPaperModes.FixedPixelWidth;
        this.zoom = 100;
        this.viewPortWidth = viewPortWidthValue;
    }

    public void UseFitToPageRendering() {
        this.UseFitToPageRendering(0);
    }

    public void UseFitToPageRendering(int minimumPixelWidth) {
        this.fitToPaperMode = FitToPaperModes.FixedPixelWidth;
        this.zoom = 100;
        this.viewPortWidth = minimumPixelWidth;
    }

    public void UseContinuousFeedRendering() {
        this.UseContinuousFeedRendering(80.0, 5);
    }

    public void UseContinuousFeedRendering(int margin) {
        this.UseContinuousFeedRendering(80.0, margin);
    }

    public void UseContinuousFeedRendering(double width) {
        this.UseContinuousFeedRendering(width, 5);
    }

    public void UseContinuousFeedRendering(double width, int margin) {
        this.fitToPaperMode = FitToPaperModes.ContinuousFeed;
        this.paperSize = PaperSize.Custom;
        this.customPaperWidth = width;
        this.marginTop = 0.0;
        this.marginBottom = 0.0;
        this.marginLeft = margin;
        this.marginRight = margin;
    }
}

