/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.edit.PageSelection;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumExtractAllTextRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumReplaceTextRequestP;
import com.ironsoftware.ironpdf.internal.proto.StringResultP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import java.util.List;
import java.util.stream.Collectors;

public final class Text_Api {
    public static String extractAllText(InternalPdfDocument internalPdfDocument) {
        return Text_Api.extractAllText(internalPdfDocument, internalPdfDocument.getPageList(PageSelection.allPages()));
    }

    public static String extractAllText(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) {
        RpcClient client = Access.ensureConnection();
        PdfiumExtractAllTextRequestP.Builder req = PdfiumExtractAllTextRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllPageIndexes(pageIndexes);
        StringResultP res = client.GetBlockingStub("extractAllText").pdfiumTextExtractAllText(req.build());
        if (res.getResultOrExceptionCase() == StringResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult();
    }

    public static void replaceTextOnPage(InternalPdfDocument internalPdfDocument, int pageIndex, String oldText, String newText) {
        RpcClient client = Access.ensureConnection();
        PdfiumReplaceTextRequestP.Builder req = PdfiumReplaceTextRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageIndex(pageIndex);
        req.setCurrentText(oldText);
        req.setNewText(newText);
        EmptyResultP res = client.GetBlockingStub("replaceTextOnPage").pdfiumTextReplaceText(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

