/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.google.protobuf.ByteString;
import com.ironsoftware.ironpdf.image.ImageBehavior;
import com.ironsoftware.ironpdf.internal.proto.ChromeImageFilesToPdfRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.ImageResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.ImagesResultStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumDrawBitmapRequestStreamP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumExtractAllRawImagesRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfToImagesRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfToMultiPageTiffImageRequestP;
import com.ironsoftware.ironpdf.internal.proto.RawImageChunkWithIndexAndFileTypeP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Image_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.Render_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_ReceivingCustomStreamObserver;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import com.ironsoftware.ironpdf.render.ChromePdfRenderOptions;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class Image_Api {
    public static InternalPdfDocument imageToPdf(List<ImageData> imagesData, ImageBehavior imageBehavior, ChromePdfRenderOptions renderOptions) {
        RpcClient client = Access.ensureConnection();
        ChromeImageFilesToPdfRequestStreamP.InfoP.Builder info = ChromeImageFilesToPdfRequestStreamP.InfoP.newBuilder();
        info.setRenderOptions(Render_Converter.toProto(renderOptions != null ? renderOptions : new ChromePdfRenderOptions()));
        info.setImageBehavior(Image_Converter.toProto(imageBehavior));
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<PdfDocumentResultP> resultChunks = new ArrayList<PdfDocumentResultP>();
        StreamObserver<ChromeImageFilesToPdfRequestStreamP> requestStream = client.GetStub("imageToPdf").chromeImageImageFilesToPdf(new Utils_ReceivingCustomStreamObserver<PdfDocumentResultP>(finishLatch, resultChunks));
        ChromeImageFilesToPdfRequestStreamP.Builder infoMsg = ChromeImageFilesToPdfRequestStreamP.newBuilder();
        infoMsg.setInfo(info);
        requestStream.onNext((Object)infoMsg.build());
        for (int imageIndex : IntStream.range(0, imagesData.size()).toArray()) {
            ImageData imageData = imagesData.get(imageIndex);
            Iterator<byte[]> it = Utils_Util.chunk(imageData.data);
            while (it.hasNext()) {
                byte[] chunk = it.next();
                ChromeImageFilesToPdfRequestStreamP.Builder msg = ChromeImageFilesToPdfRequestStreamP.newBuilder();
                RawImageChunkWithIndexAndFileTypeP.Builder rawImageFilesChunkWithIndex = RawImageChunkWithIndexAndFileTypeP.newBuilder();
                rawImageFilesChunkWithIndex.setRawImageChunk(ByteString.copyFrom((byte[])chunk));
                rawImageFilesChunkWithIndex.setImageIndex(imageIndex);
                rawImageFilesChunkWithIndex.setFileType(imageData.fileExtension);
                msg.setRawImagesFileChunk(rawImageFilesChunkWithIndex);
                requestStream.onNext((Object)msg.build());
            }
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handlePdfDocumentChunks(resultChunks);
    }

    public static void drawImage(InternalPdfDocument internalPdfDocument, byte[] imageBytes, List<Integer> pageIndexes, double x, double y, double desiredWidth, double desiredHeight) {
        RpcClient client = Access.ensureConnection();
        PdfiumDrawBitmapRequestStreamP.InfoP.Builder info = PdfiumDrawBitmapRequestStreamP.InfoP.newBuilder();
        info.setDocument(internalPdfDocument.remoteDocument);
        info.setX(x);
        info.setY(y);
        info.setDesiredWidth(desiredWidth);
        info.setDesiredHeight(desiredHeight);
        info.addAllPageIndexes(pageIndexes);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<EmptyResultP> resultChunks = new ArrayList<EmptyResultP>();
        StreamObserver<PdfiumDrawBitmapRequestStreamP> requestStream = client.GetStub("drawImage").pdfiumImageDrawBitmap(new Utils_ReceivingCustomStreamObserver<EmptyResultP>(finishLatch, resultChunks));
        requestStream.onNext((Object)PdfiumDrawBitmapRequestStreamP.newBuilder().setInfo(info).build());
        Iterator<byte[]> it = Utils_Util.chunk(imageBytes);
        while (it.hasNext()) {
            byte[] bytes = it.next();
            PdfiumDrawBitmapRequestStreamP.Builder msg = PdfiumDrawBitmapRequestStreamP.newBuilder();
            msg.setRawImageChunk(ByteString.copyFrom((byte[])bytes));
            requestStream.onNext((Object)msg.build());
        }
        requestStream.onCompleted();
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        Utils_Util.handleEmptyResultChunks(resultChunks);
    }

    public static List<byte[]> extractAllImages(InternalPdfDocument internalPdfDocument) throws IOException {
        return Image_Api.extractAllImages(internalPdfDocument, null);
    }

    public static List<byte[]> extractAllImages(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) throws IOException {
        RpcClient client = Access.ensureConnection();
        PdfiumExtractAllRawImagesRequestP.Builder req = PdfiumExtractAllRawImagesRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllPageIndexes(pageIndexes);
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImagesResultStreamP> resultChunks = new ArrayList<ImagesResultStreamP>();
        client.GetStub("extractAllImages").pdfiumImageExtractAllRawImages(req.build(), new Utils_ReceivingCustomStreamObserver<ImagesResultStreamP>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImagesResult(resultChunks);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes, int dpi, Integer imageMaxWidth) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, dpi, imageMaxWidth, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes, int dpi, Integer imageMaxWidth, Integer imageMaxHeight) throws IOException {
        RpcClient client = Access.ensureConnection();
        PdfiumPdfToImagesRequestP.Builder request = PdfiumPdfToImagesRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setDpi(dpi);
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        request.addAllPageIndexes(pageIndexes);
        if (imageMaxWidth != null) {
            request.setMaxWidth(imageMaxWidth);
        }
        if (imageMaxHeight != null) {
            request.setMaxHeight(imageMaxHeight);
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImagesResultStreamP> resultChunks = new ArrayList<ImagesResultStreamP>();
        client.GetStub("pdfToImage").pdfiumImagePdfToImages(request.build(), new Utils_ReceivingCustomStreamObserver<ImagesResultStreamP>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImagesResult(resultChunks);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes, int dpi) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, dpi, null, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, pageIndexes, 92, null, null);
    }

    public static List<byte[]> pdfToImage(InternalPdfDocument internalPdfDocument) throws IOException {
        return Image_Api.pdfToImage(internalPdfDocument, null, 92, null, null);
    }

    public static byte[] toMultiPageTiff(InternalPdfDocument internalPdfDocument, List<Integer> pageIndexes, int dpi, Integer imageMaxWidth, Integer imageMaxHeight) throws IOException {
        RpcClient client = Access.ensureConnection();
        PdfiumPdfToMultiPageTiffImageRequestP.Builder request = PdfiumPdfToMultiPageTiffImageRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setDpi(dpi);
        if (pageIndexes == null || pageIndexes.isEmpty()) {
            pageIndexes = Page_Api.getPagesInfo(internalPdfDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        request.addAllPageIndexes(pageIndexes);
        if (imageMaxWidth != null) {
            request.setMaxWidth(imageMaxWidth);
        }
        if (imageMaxHeight != null) {
            request.setMaxHeight(imageMaxHeight);
        }
        CountDownLatch finishLatch = new CountDownLatch(1);
        ArrayList<ImageResultStreamP> resultChunks = new ArrayList<ImageResultStreamP>();
        client.GetStub("toMultiPageTiff").pdfiumImagePdfToMultiPageTiffImage(request.build(), new Utils_ReceivingCustomStreamObserver<ImageResultStreamP>(finishLatch, resultChunks));
        Utils_Util.waitAndCheck(finishLatch, resultChunks);
        return Utils_Util.handleImageResult(resultChunks);
    }

    public static class ImageData {
        byte[] data;
        String fileExtension;

        public ImageData(byte[] data, String fileExtension) {
            this.data = data;
            this.fileExtension = fileExtension;
        }
    }
}

