/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.bookmark.Bookmark;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetBookmarksDescriptorRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetBookmarksDescriptorResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumInsertBookmarkRequestP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Bookmark_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import java.util.List;

public final class Bookmark_Api {
    public static List<Bookmark> getBookmarks(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetBookmarksDescriptorRequestP.Builder request = PdfiumGetBookmarksDescriptorRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        PdfiumGetBookmarksDescriptorResultP result = client.blockingStub.pdfiumBookmarkGetBookmarksDescriptor(request.build());
        if (result.getResultOrExceptionCase() == PdfiumGetBookmarksDescriptorResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(result.getException());
        }
        return Bookmark_Converter.fromProto(result.getResult());
    }

    public static void insertBookmarkAsFirstChild(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, parentText, null);
    }

    public static void insertBookmark(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText, String previousText) {
        RpcClient client = Access.ensureConnection();
        PdfiumInsertBookmarkRequestP.Builder request = PdfiumInsertBookmarkRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setPageIndex(pageIndex);
        request.setText(text);
        if (parentText != null) {
            request.setParentText(parentText);
        }
        if (previousText != null) {
            request.setPreviousText(previousText);
        }
        EmptyResultP res = client.blockingStub.pdfiumBookmarkInsertBookmark(request.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void insertBookmarkAtStart(InternalPdfDocument internalPdfDocument, int pageIndex, String text) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, null, null);
    }
}

