/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Setting_Api {
    static final Logger logger = LoggerFactory.getLogger(Setting_Api.class);
    public static int subProcessPort = Setting_Api.getDefaultPort();
    public static String licenseKey = "";
    public static boolean enableDebug = false;
    static boolean isIronPdfEngineDocker = false;
    public static Path logPath = Paths.get("ironpdfengine.log", new String[0]);
    public static Path ironPdfEngineWorkingDirectory = Paths.get(System.getProperty("user.dir"), new String[0]);
    public static String subProcessHost = "127.0.0.1";
    public static Path tempFolderPath = null;
    public static final String IRON_PDF_ENGINE_VERSION = "2024.6.1";
    public static boolean singleProcess = false;
    public static int chromeBrowserLimit = 30;
    public static Path chromeBrowserCachePath = null;
    public static int chromeGpuMode = 0;
    public static boolean linuxAndDockerAutoConfig = true;
    public static int ironPdfEngineTimeout = 120;

    public static int getDefaultPort() {
        return 33350;
    }

    static String currentOsFullName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Windows";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "Linux";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "MacOS";
        }
        throw new RuntimeException("unknown OS:" + SystemUtils.OS_NAME);
    }

    static String currentOsArch() {
        if (SystemUtils.IS_OS_WINDOWS) {
            if (System.getProperty("os.arch").equalsIgnoreCase("x86")) {
                return "x86";
            }
            return "x64";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "x64";
        }
        if (SystemUtils.IS_OS_MAC) {
            if (System.getProperty("os.arch").toLowerCase().contains("arm")) {
                return "arm64";
            }
            return "x64";
        }
        throw new RuntimeException("unknown OS:" + SystemUtils.OS_NAME);
    }

    public static String getIronPdfEngineFolderName() {
        return "IronPdfEngine.2024.6.1." + Setting_Api.currentOsFullName() + "." + Setting_Api.currentOsArch();
    }

    public static String getIronPdfEngineZipName() {
        return Setting_Api.getIronPdfEngineFolderName() + ".zip";
    }

    public static String getIronPdfEngineExecutableFileName() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "IronPdfEngineConsole.exe";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "IronPdfEngineConsole";
        }
        if (SystemUtils.IS_OS_MAC) {
            return "IronPdfEngineConsole";
        }
        return "IronPdfEngineConsole";
    }

    public static Path getIronPdfEngineExecutablePath(Path workingDir) {
        return Paths.get(workingDir.toAbsolutePath().toString(), Setting_Api.getIronPdfEngineFolderName(), Setting_Api.getIronPdfEngineExecutableFileName());
    }

    public static void useIronPdfEngineDocker(int port) {
        logger.info("Using IronPdfEngine Docker port:" + port);
        subProcessPort = port;
        isIronPdfEngineDocker = true;
    }
}

