/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.annotation.TextAnnotation;
import com.ironsoftware.ironpdf.internal.proto.IntResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumAddTextAnnotationRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetAnnotationCountRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetAnnotationRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetTextAnnotationResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumTextAnnotationP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Annotation_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import java.util.ArrayList;
import java.util.List;

public final class Annotation_Api {
    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y, int width) {
        Annotation_Api.addTextAnnotation(internalPdfDocument, textAnnotation, pageIndex, x, y, width, 30);
    }

    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y, int width, int height) {
        textAnnotation.setPageIndex(pageIndex);
        textAnnotation.setX(x);
        textAnnotation.setY(y);
        textAnnotation.setWidth(width);
        textAnnotation.setHeight(height);
        Annotation_Api.addTextAnnotation(internalPdfDocument, textAnnotation);
    }

    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation, int pageIndex, int x, int y) {
        Annotation_Api.addTextAnnotation(internalPdfDocument, textAnnotation, pageIndex, x, y, 30, 30);
    }

    public static void addTextAnnotation(InternalPdfDocument internalPdfDocument, TextAnnotation textAnnotation) {
        RpcClient client = Access.ensureConnection();
        PdfiumTextAnnotationP annotation = Annotation_Converter.toProto(textAnnotation);
        PdfiumAddTextAnnotationRequestP.Builder req = PdfiumAddTextAnnotationRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setAnnotation(annotation);
        IntResultP res = client.blockingStub.pdfiumAnnotationAddTextAnnotation(req.build());
        if (res.getResultOrExceptionCase() == IntResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
    }

    public static int getAnnotationCount(InternalPdfDocument internalPdfDocument, int pageIndex) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetAnnotationCountRequestP.Builder req = PdfiumGetAnnotationCountRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setPageIndex(pageIndex);
        IntResultP res = client.blockingStub.pdfiumAnnotationGetAnnotationCountRequestP(req.build());
        if (res.getResultOrExceptionCase() == IntResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult();
    }

    public static List<TextAnnotation> getAnnotaionList(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        ArrayList<TextAnnotation> annotationList = new ArrayList<TextAnnotation>();
        for (int pageIndex = 0; pageIndex < Page_Api.getPagesInfo(internalPdfDocument).size(); ++pageIndex) {
            int annotationCount = Annotation_Api.getAnnotationCount(internalPdfDocument, pageIndex);
            for (int annotationIndex = 0; annotationIndex < annotationCount; ++annotationIndex) {
                PdfiumGetAnnotationRequestP.Builder req = PdfiumGetAnnotationRequestP.newBuilder();
                req.setDocument(internalPdfDocument.remoteDocument);
                req.setPageIndex(pageIndex);
                req.setAnnotIndex(annotationIndex);
                PdfiumGetTextAnnotationResultP res = client.blockingStub.pdfiumAnnotationGetTextAnnotationRequestP(req.build());
                if (res.getResultOrExceptionCase() == PdfiumGetTextAnnotationResultP.ResultOrExceptionCase.EXCEPTION) {
                    throw Exception_Converter.fromProto(res.getException());
                }
                annotationList.add(Annotation_Converter.fromProto(res.getResult()));
            }
        }
        return annotationList;
    }
}

