/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.bookmark.Bookmark;
import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumBookmarkDescriptorP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumBookmarkP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetBookmarksDescriptorRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetBookmarksDescriptorResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumInsertBookmarkRequestP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Bookmark_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import java.util.List;

public final class Bookmark_Api {
    public static List<Bookmark> getBookmarks(InternalPdfDocument internalPdfDocument) {
        PdfiumGetBookmarksDescriptorResultP dres = Bookmark_Api.getBookmarkDescriptors(internalPdfDocument);
        return Bookmark_Converter.fromProto(dres.getResult());
    }

    public static void insertBookmarkAsFirstChild(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, parentText, null);
    }

    public static void insertBookmark(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText, String previousText) {
        RpcClient client = Access.ensureConnection();
        PdfiumInsertBookmarkRequestP.Builder request = PdfiumInsertBookmarkRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setPageIndex(pageIndex);
        request.setText(text);
        if (parentText != null) {
            request.setParentText(parentText);
        }
        if (previousText != null) {
            request.setPreviousText(previousText);
        }
        String parentId = null;
        if (parentText != null && !parentText.isEmpty()) {
            PdfiumGetBookmarksDescriptorResultP dres = Bookmark_Api.getBookmarkDescriptors(internalPdfDocument);
            parentId = dres.getResult().getBookmarkDescriptorsList().stream().filter(p -> parentText.equals(p.getText())).sorted((a, b) -> Integer.compare(Bookmark_Api.depth(a.getHierarchy()), Bookmark_Api.depth(b.getHierarchy()))).map(PdfiumBookmarkDescriptorP::getItemId).filter(id -> id != null && !id.isEmpty()).findFirst().orElse(null);
        }
        PdfiumBookmarkP.Builder parent = PdfiumBookmarkP.newBuilder();
        if (parentId != null && !parentId.isEmpty()) {
            parent.setItemId(parentId);
            if (parentText != null && !parentText.isEmpty()) {
                parent.setText(parentText);
            }
        } else if (parentText != null && !parentText.isEmpty()) {
            parent.setText(parentText);
            request.setParentText(parentText);
        } else {
            request.clearParentText();
        }
        request.setParent(parent.build());
        EmptyResultP res = client.GetBlockingStub("insertBookmark").pdfiumBookmarkInsertBookmark(request.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void insertBookmarkAtStart(InternalPdfDocument internalPdfDocument, int pageIndex, String text) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, null, null);
    }

    private static PdfiumGetBookmarksDescriptorResultP getBookmarkDescriptors(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetBookmarksDescriptorRequestP.Builder request = PdfiumGetBookmarksDescriptorRequestP.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        PdfiumGetBookmarksDescriptorResultP result = client.GetBlockingStub("getBookmarks").pdfiumBookmarkGetBookmarksDescriptor(request.build());
        if (result.getResultOrExceptionCase() == PdfiumGetBookmarksDescriptorResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(result.getException());
        }
        return result;
    }

    private static int depth(String h) {
        if (h == null || h.isEmpty()) {
            return 0;
        }
        int d = 0;
        int i = 0;
        int n = h.length();
        while (i < n) {
            while (i < n && h.charAt(i) == '\\') {
                ++i;
            }
            int start = i;
            while (i < n && h.charAt(i) != '\\') {
                ++i;
            }
            if (i <= start) continue;
            ++d;
        }
        return d;
    }
}

