/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.bookmark.Bookmark;
import com.ironsoftware.ironpdf.bookmark.BookmarkDestinations;
import com.ironsoftware.ironpdf.internal.proto.PdfiumBookmarkDescriptorCollectionP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumBookmarkDescriptorP;
import com.ironsoftware.ironpdf.internal.staticapi.BookmarkDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

final class Bookmark_Converter {
    Bookmark_Converter() {
    }

    static List<Bookmark> fromProto(PdfiumBookmarkDescriptorCollectionP proto) {
        return Bookmark_Converter.convertDescriptorsToBookmarks(proto.getBookmarkDescriptorsList().stream().map(Bookmark_Converter::fromProto).collect(Collectors.toList()));
    }

    static BookmarkDescriptor fromProto(PdfiumBookmarkDescriptorP proto) {
        return new BookmarkDescriptor(proto.getHierarchy(), proto.getPageIndex(), proto.getText(), proto.getItemId(), proto.getParentItemId());
    }

    public static List<Bookmark> convertDescriptorsToBookmarks(List<BookmarkDescriptor> descriptors) {
        ArrayList<Bookmark> bookmarks = new ArrayList<Bookmark>();
        String regex = "\\\\";
        for (int i = 0; i < descriptors.size(); ++i) {
            BookmarkDescriptor descriptor = descriptors.get(i);
            String text = descriptor.getText();
            int pageIndex = descriptor.getPageIndex();
            String[] hierarchyParts = (String[])Arrays.stream(descriptor.getHierarchy().split("\\\\")).filter(part -> !part.isEmpty()).toArray(String[]::new);
            String parentBookmarkText = "";
            if (hierarchyParts.length > 1) {
                parentBookmarkText = hierarchyParts[hierarchyParts.length - 1];
            }
            String previousBookmarkText = "";
            String nextBookmarkText = "";
            if (i > 0) {
                String prevParent;
                BookmarkDescriptor prevDescriptor = descriptors.get(i - 1);
                String[] prevHierarchyParts = (String[])Arrays.stream(prevDescriptor.getHierarchy().split("\\\\")).filter(part -> !part.isEmpty()).toArray(String[]::new);
                String string = prevParent = prevHierarchyParts.length > 1 ? prevHierarchyParts[prevHierarchyParts.length - 1] : "";
                if (parentBookmarkText != null && parentBookmarkText.equals(prevParent)) {
                    previousBookmarkText = prevDescriptor.getText();
                }
            }
            if (i < descriptors.size() - 1) {
                String nextParent;
                BookmarkDescriptor nextDescriptor = descriptors.get(i + 1);
                String[] nextHierarchyParts = (String[])Arrays.stream(nextDescriptor.getHierarchy().split("\\\\")).filter(part -> !part.isEmpty()).toArray(String[]::new);
                String string = nextParent = nextHierarchyParts.length > 1 ? nextHierarchyParts[nextHierarchyParts.length - 1] : "";
                if (parentBookmarkText != null && parentBookmarkText.equals(nextParent)) {
                    nextBookmarkText = nextDescriptor.getText();
                }
            }
            bookmarks.add(new Bookmark(text, pageIndex, parentBookmarkText, BookmarkDestinations.PAGE, nextBookmarkText, previousBookmarkText));
        }
        return bookmarks;
    }
}

