/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfDocumentResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfSecuritySettingsRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumGetPdfSecuritySettingsResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfSecuritySettingsP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumRemovePasswordsAndEncryptionRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumSetPdfSecuritySettingsRequestP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Security_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_StringHelper;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.security.PdfEditSecurity;
import com.ironsoftware.ironpdf.security.PdfPrintSecurity;
import com.ironsoftware.ironpdf.security.SecurityOptions;

public final class Security_Api {
    public static void removePasswordsAndEncryption(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumRemovePasswordsAndEncryptionRequestP.Builder req = PdfiumRemovePasswordsAndEncryptionRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        EmptyResultP res = client.GetBlockingStub("removePasswordsAndEncryption").pdfiumSecurityRemovePasswordsAndEncryption(req.buildPartial());
        Utils_Util.handleEmptyResult(res);
        internalPdfDocument.userPassword = "";
        internalPdfDocument.ownerPassword = "";
    }

    public static SecurityOptions getPdfSecurityOptions(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        PdfiumGetPdfSecuritySettingsRequestP.Builder req = PdfiumGetPdfSecuritySettingsRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        PdfiumGetPdfSecuritySettingsResultP res = client.GetBlockingStub("getPdfSecurityOptions").pdfiumSecurityGetPdfSecuritySettings(req.build());
        if (res.getResultOrExceptionCase() == PdfiumGetPdfSecuritySettingsResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        SecurityOptions opt = Security_Converter.fromProto(res.getSecuritySettings());
        opt.setOwnerPassword(internalPdfDocument.ownerPassword);
        opt.setUserPassword(internalPdfDocument.userPassword);
        return opt;
    }

    public static void makePdfDocumentReadOnly(InternalPdfDocument internalPdfDocument, String ownerPassword) {
        if (Utils_StringHelper.isNullOrWhiteSpace(ownerPassword)) {
            throw new RuntimeException("MakePdfDocumentReadOnly :: A string for owner password is required to enable PDF encryption and all document security options.");
        }
        PdfiumPdfSecuritySettingsP.Builder iron = PdfiumPdfSecuritySettingsP.newBuilder();
        SecurityOptions securityOptions = new SecurityOptions();
        securityOptions.setAllowUserCopyPasteContent(false);
        securityOptions.setAllowUserCopyPasteContentForAccessibility(false);
        securityOptions.setAllowUserAnnotations(false);
        securityOptions.setAllowUserEdits(PdfEditSecurity.NO_EDIT);
        securityOptions.setAllowUserFormData(false);
        securityOptions.setAllowUserPrinting(PdfPrintSecurity.FULL_PRINT_RIGHTS);
        securityOptions.setOwnerPassword(ownerPassword);
        Security_Api.setPdfSecuritySettings(internalPdfDocument, securityOptions);
        internalPdfDocument.userPassword = securityOptions.getUserPassword();
        internalPdfDocument.ownerPassword = securityOptions.getOwnerPassword();
    }

    public static void setPdfSecuritySettings(InternalPdfDocument internalPdfDocument, SecurityOptions securityOptions) {
        RpcClient client = Access.ensureConnection();
        PdfiumSetPdfSecuritySettingsRequestP.Builder req = PdfiumSetPdfSecuritySettingsRequestP.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setSettings(Security_Converter.toProto(securityOptions));
        PdfDocumentResultP res = client.GetBlockingStub("setPdfSecuritySettings").pdfiumSecuritySetPdfSecuritySettings(req.buildPartial());
        if (res.getResultOrExceptionCase() == PdfDocumentResultP.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        internalPdfDocument.userPassword = securityOptions.getUserPassword();
        internalPdfDocument.ownerPassword = securityOptions.getOwnerPassword();
    }
}

