/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf;

import io.grpc.ManagedChannel;

public class IronPdfEngineConnection {
    private String host;
    private int port;
    private String target;
    private ConnectionMode mode;
    private ManagedChannel channel;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final String DEFAULT_OFFICIAL_CLOUD_TARGET = "grpc.ironpdfservice.com:443";
    private static final int DEFAULT_PORT = 33350;

    public static IronPdfEngineConnection configure() {
        return new IronPdfEngineConnection();
    }

    public IronPdfEngineConnection withHostPort(String host, int port) {
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("Host cannot be null or empty.");
        }
        if (port <= 0 || port > 65535) {
            throw new IllegalArgumentException("Port must be between 1 and 65535.");
        }
        this.host = host;
        this.port = port;
        this.target = null;
        this.mode = ConnectionMode.HOST_PORT;
        this.channel = null;
        return this;
    }

    public IronPdfEngineConnection withTarget(String target) {
        this.target = target;
        this.host = null;
        this.port = -1;
        this.mode = ConnectionMode.TARGET;
        return this;
    }

    public IronPdfEngineConnection withSubprocess() {
        this.host = DEFAULT_HOST;
        this.port = 33350;
        this.target = null;
        this.mode = ConnectionMode.SUBPROCESS;
        this.channel = null;
        return this;
    }

    public IronPdfEngineConnection withSubprocess(int port) {
        this.host = DEFAULT_HOST;
        this.port = 33350;
        this.target = null;
        this.mode = ConnectionMode.SUBPROCESS;
        this.channel = null;
        return this;
    }

    public IronPdfEngineConnection withOfficialCloud() {
        this.target = DEFAULT_OFFICIAL_CLOUD_TARGET;
        this.host = null;
        this.port = -1;
        this.mode = ConnectionMode.OFFICIAL_CLOUD;
        this.channel = null;
        return this;
    }

    public IronPdfEngineConnection withCustomGrpcConnection(ManagedChannel customChannel) {
        this.channel = customChannel;
        this.target = null;
        this.host = null;
        this.port = -1;
        this.mode = ConnectionMode.CUSTOM;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getTarget() {
        return this.target;
    }

    public ConnectionMode getMode() {
        return this.mode;
    }

    public ManagedChannel getCustomChannel() {
        return this.channel;
    }

    public String toString() {
        switch (this.mode) {
            case HOST_PORT: {
                return "IronPdfEngine Host: " + this.host + ", Port: " + this.port;
            }
            case TARGET: {
                return "IronPdfEngine Target: " + this.target;
            }
            case SUBPROCESS: {
                return "IronPdfEngine launched as subprocess on port: " + this.port;
            }
            case OFFICIAL_CLOUD: {
                return "IronPdfEngine official cloud Target: " + this.target;
            }
            case CUSTOM: {
                return "Custom connection";
            }
        }
        return "Unknown IronPdfEngine configuration. Host: " + this.host + ", Port: " + this.port + ", Target: " + this.target;
    }

    public static enum ConnectionMode {
        SUBPROCESS,
        HOST_PORT,
        TARGET,
        OFFICIAL_CLOUD,
        CUSTOM;

    }
}

