/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResultP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumAddBackgroundForegroundRequestP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumLayerModesP;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.Page_Api;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import com.ironsoftware.ironpdf.page.PageInfo;
import java.util.List;
import java.util.stream.Collectors;

public final class BackgroundForeground_Api {
    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument, List<Integer> basePdfPageIndexes) {
        BackgroundForeground_Api.addBackground(baseDocument, backgroundDocument, basePdfPageIndexes, 0);
    }

    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument, List<Integer> basePdfPageIndexes, int backgroundPdfPageIndex) {
        RpcClient client = Access.ensureConnection();
        PdfiumAddBackgroundForegroundRequestP.Builder req = PdfiumAddBackgroundForegroundRequestP.newBuilder();
        req.setSourcePdf(backgroundDocument.remoteDocument);
        req.setDestinationPdf(baseDocument.remoteDocument);
        req.setSrcPageIndex(backgroundPdfPageIndex);
        if (basePdfPageIndexes == null || basePdfPageIndexes.isEmpty()) {
            basePdfPageIndexes = Page_Api.getPagesInfo(baseDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllDestPageIndices(basePdfPageIndexes);
        req.setLayerMode(PdfiumLayerModesP.newBuilder().setEnumValue(1).build());
        EmptyResultP res = client.GetBlockingStub("addBackground").pdfiumBackgroundForegroundAddBackgroundForeground(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void addBackground(InternalPdfDocument baseDocument, InternalPdfDocument backgroundDocument) {
        BackgroundForeground_Api.addBackground(baseDocument, backgroundDocument, null, 0);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument, List<Integer> basePdfPageIndexes) {
        BackgroundForeground_Api.addForeground(baseDocument, foregroundDocument, basePdfPageIndexes, 0);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument, List<Integer> basePdfPageIndexes, int foregroundPdfPageIndex) {
        RpcClient client = Access.ensureConnection();
        PdfiumAddBackgroundForegroundRequestP.Builder req = PdfiumAddBackgroundForegroundRequestP.newBuilder();
        req.setSourcePdf(foregroundDocument.remoteDocument);
        req.setDestinationPdf(baseDocument.remoteDocument);
        req.setSrcPageIndex(foregroundPdfPageIndex);
        if (basePdfPageIndexes == null || basePdfPageIndexes.isEmpty()) {
            basePdfPageIndexes = Page_Api.getPagesInfo(baseDocument).stream().map(PageInfo::getPageIndex).collect(Collectors.toList());
        }
        req.addAllDestPageIndices(basePdfPageIndexes);
        req.setLayerMode(PdfiumLayerModesP.newBuilder().setEnumValue(0).build());
        EmptyResultP res = client.GetBlockingStub("addForeground").pdfiumBackgroundForegroundAddBackgroundForeground(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void addForeground(InternalPdfDocument baseDocument, InternalPdfDocument foregroundDocument) {
        BackgroundForeground_Api.addForeground(baseDocument, foregroundDocument, null, 0);
    }
}

