/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;

class DownloadInputStream
extends InputStream {
    private InputStream in;
    private long totalLength;
    private long sumRead;
    private double percent;
    private double previousPercent;
    Logger logger;

    public DownloadInputStream(InputStream inputStream, long totalLength, Logger logger) throws IOException {
        this.in = inputStream;
        this.sumRead = 0L;
        this.previousPercent = -10.0;
        this.totalLength = totalLength;
        this.logger = logger;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int readCount = this.in.read(b);
        this.evaluatePercent(readCount);
        return readCount;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int readCount = this.in.read(b, off, len);
        this.evaluatePercent(readCount);
        return readCount;
    }

    @Override
    public long skip(long n) throws IOException {
        long skip = this.in.skip(n);
        this.evaluatePercent(skip);
        return skip;
    }

    @Override
    public int read() throws IOException {
        int read = this.in.read();
        if (read != -1) {
            this.evaluatePercent(1L);
        }
        return read;
    }

    private void evaluatePercent(long readCount) {
        if (readCount != -1L) {
            this.sumRead += readCount;
            this.percent = (double)this.sumRead * 0.01 / (double)this.totalLength;
            if (this.percent > this.previousPercent + 10.0 && this.percent < 100.0) {
                this.previousPercent = this.percent;
                Utils_Util.logInfoOrSystemOut(this.logger, "Downloading.. " + (int)this.percent + "%");
            }
        } else {
            Utils_Util.logInfoOrSystemOut(this.logger, "Download finished");
        }
    }
}

