/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.form.CheckBoxField;
import com.ironsoftware.ironpdf.form.ComboBoxField;
import com.ironsoftware.ironpdf.form.FormField;
import com.ironsoftware.ironpdf.form.FormFieldTypes;
import com.ironsoftware.ironpdf.form.ImageField;
import com.ironsoftware.ironpdf.form.RadioField;
import com.ironsoftware.ironpdf.form.SignatureField;
import com.ironsoftware.ironpdf.form.TextField;
import com.ironsoftware.ironpdf.internal.proto.PdfiumFormFieldP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfFormFieldTypeP;
import com.ironsoftware.ironpdf.internal.proto.PdfiumPdfFormP;
import java.util.List;
import java.util.stream.Collectors;

final class Form_Converter {
    Form_Converter() {
    }

    static List<FormField> fromProto(PdfiumPdfFormP proto) {
        return proto.getFormFieldsList().stream().map(x -> {
            switch (x.getSubTypeCase()) {
                case COMBO_BOX_FIELD: {
                    return Form_Converter.fromProtoToComboBoxField(x);
                }
                case CHECK_BOX_FIELD: {
                    return Form_Converter.fromProtoToCheckBoxField(x);
                }
                case TEXT_FIELD: {
                    return Form_Converter.fromProtoToTextField(x);
                }
                case IMAGE_FIELD: {
                    return Form_Converter.fromProtoToImageField(x);
                }
                case RADIO_FIELD: {
                    return Form_Converter.fromProtoToRadioField(x);
                }
                case SIGNATURE_FIELD: {
                    return Form_Converter.fromProtoToSignatureField(x);
                }
                case SUBTYPE_NOT_SET: 
                case UNKNOWN_FIELD: {
                    return Form_Converter.fromProtoToFormField(x);
                }
            }
            throw new IndexOutOfBoundsException();
        }).collect(Collectors.toList());
    }

    static ComboBoxField fromProtoToComboBoxField(PdfiumFormFieldP proto) {
        return new ComboBoxField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), (List<String>)proto.getComboBoxField().getOptionsList(), proto.getComboBoxField().getSelectedIndex(), proto.getReadOnly());
    }

    static CheckBoxField fromProtoToCheckBoxField(PdfiumFormFieldP proto) {
        return new CheckBoxField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getCheckBoxField().getBooleanValue(), proto.getReadOnly());
    }

    static TextField fromProtoToTextField(PdfiumFormFieldP proto) {
        return new TextField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static ImageField fromProtoToImageField(PdfiumFormFieldP proto) {
        return new ImageField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static RadioField fromProtoToRadioField(PdfiumFormFieldP proto) {
        return new RadioField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), (List<String>)proto.getRadioField().getOptionsList(), proto.getRadioField().getSelectedIndex(), proto.getReadOnly());
    }

    static SignatureField fromProtoToSignatureField(PdfiumFormFieldP proto) {
        return new SignatureField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static FormField fromProtoToFormField(PdfiumFormFieldP proto) {
        return new FormField(proto.getAnnotationIndex(), proto.getName(), proto.getPageIndex(), proto.getType(), proto.getX(), proto.getY(), proto.getWidth(), proto.getHeight(), proto.getValue(), proto.getReadOnly());
    }

    static FormFieldTypes fromProto(PdfiumPdfFormFieldTypeP input) {
        return FormFieldTypes.values()[input.getEnumValue()];
    }
}

